/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class Monomial {
    private final Map<Term, Rational> mVariable2Exponent;
    private final Sort mSort;

    public Monomial(Term term, Rational rational) {
        this.checkIfTermIsLegalVariable(term);
        this.mSort = term.getSort();
        this.mVariable2Exponent = Collections.singletonMap(term, rational);
    }

    public Monomial(Monomial ... monomialArray) {
        this.mSort = monomialArray[0].getSort();
        this.mVariable2Exponent = new HashMap<Term, Rational>();
        Monomial[] monomialArray2 = monomialArray;
        int n = monomialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monomial monomial = monomialArray2[n2];
            for (Map.Entry<Term, Rational> entry : monomial.getVariable2Exponent().entrySet()) {
                assert (entry.getKey().getSort() == this.mSort) : "Sort mismatch: " + String.valueOf(entry.getKey().getSort()) + " vs. " + String.valueOf(this.mSort);
                assert (entry.getValue().signum() != -1);
                Rational rational = this.mVariable2Exponent.get(entry.getKey());
                if (rational == null) {
                    this.mVariable2Exponent.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (rational.isNegative() || entry.getValue().isNegative()) {
                    throw new UnsupportedOperationException("Division is only allowed by constants");
                }
                Rational rational2 = rational.add(entry.getValue());
                if (rational2.equals((Object)Rational.ZERO)) {
                    this.mVariable2Exponent.remove(entry.getKey());
                    continue;
                }
                this.mVariable2Exponent.put(entry.getKey(), rational2);
            }
            ++n2;
        }
    }

    public void checkIfTermIsLegalVariable(Term term) {
        if (!(term instanceof TermVariable) && !(term instanceof ApplicationTerm)) {
            throw new IllegalArgumentException("Variable of Monomial has to be TermVariable or ApplicationTerm");
        }
    }

    public boolean isLinear() {
        return this.getSingleVariable() != null;
    }

    public Term getSingleVariable() {
        Iterator<Map.Entry<Term, Rational>> iterator = this.getVariable2Exponent().entrySet().iterator();
        if (!iterator.hasNext()) {
            throw new AssertionError((Object)"empty monomial are not supported");
        }
        Map.Entry<Term, Rational> entry = iterator.next();
        if (!entry.getValue().equals((Object)Rational.ONE)) {
            return null;
        }
        if (iterator.hasNext()) {
            return null;
        }
        return entry.getKey();
    }

    public Map<Term, Rational> getVariable2Exponent() {
        return Collections.unmodifiableMap(this.mVariable2Exponent);
    }

    public boolean isVariable(Term term) {
        return this.getVariable2Exponent().containsKey(term);
    }

    public Occurrence isExclusiveVariable(Term term) {
        boolean bl = false;
        for (Map.Entry<Term, Rational> entry : this.getVariable2Exponent().entrySet()) {
            if (entry.getKey().equals(term)) {
                if (bl) {
                    throw new AssertionError((Object)"var occurs twice");
                }
                bl = true;
                continue;
            }
            boolean bl2 = new SubtermPropertyChecker(term2 -> term2 == term).isSatisfiedBySomeSubterm(entry.getKey());
            if (!bl2) continue;
            return Occurrence.NON_EXCLUSIVE_OR_SUBTERM;
        }
        if (bl) {
            return Occurrence.AS_EXCLUSIVE_VARIABlE;
        }
        return Occurrence.NOT;
    }

    public Sort getSort() {
        return this.mSort;
    }

    public Term toTerm(Script script) {
        return this.timesCoefficientToTerm(script, Rational.ONE);
    }

    public Term timesCoefficientToTerm(Script script, Rational rational) {
        int n;
        Term[] termArray;
        int n2 = this.sumOfExponents();
        if (rational.equals((Object)Rational.ONE)) {
            termArray = new Term[n2];
            n = 0;
        } else {
            termArray = new Term[n2 + 1];
            termArray[0] = SmtUtils.rational2Term(script, rational, this.mSort);
            n = 1;
        }
        for (Map.Entry<Term, Rational> term2 : this.mVariable2Exponent.entrySet()) {
            Term term = term2.getKey();
            int n3 = term2.getValue().numerator().intValueExact();
            int n4 = 0;
            while (n4 < n3) {
                termArray[n] = term;
                ++n;
                ++n4;
            }
        }
        Term term = SmtUtils.mul(script, this.mSort, termArray);
        return term;
    }

    private int sumOfExponents() {
        Rational rational = Rational.ZERO;
        for (Rational rational2 : this.mVariable2Exponent.values()) {
            assert (!rational2.equals((Object)Rational.ZERO)) : "zero is no legal exponent in AffineTerm";
            assert (rational2.signum() != -1);
            assert (rational2.isIntegral());
            rational = rational.add(rational2);
        }
        return rational.numerator().intValueExact();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var2_6;
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Term, Rational> object2 : this.mVariable2Exponent.entrySet()) {
            stringBuilder.append(object2.getKey());
            stringBuilder.append("^" + (object2.getValue().isNegative() ? "[-" : "[") + String.valueOf(object2.getValue().abs()) + "]");
        }
        String string = stringBuilder.toString();
        if (string.charAt(0) == ' ') {
            String string2 = string.substring(1);
        }
        return var2_6;
    }

    public int hashCode() {
        return Objects.hash(this.mSort, this.mVariable2Exponent);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Monomial monomial = (Monomial)object;
        if (this.mSort == null ? monomial.getSort() != null : !this.mSort.equals(monomial.getSort())) {
            return false;
        }
        return !(this.mVariable2Exponent == null ? monomial.getVariable2Exponent() != null : !this.mVariable2Exponent.equals(monomial.getVariable2Exponent()));
    }

    public static enum Occurrence {
        NOT,
        AS_EXCLUSIVE_VARIABlE,
        NON_EXCLUSIVE_OR_SUBTERM;

    }
}

