/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.Payload;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;

public abstract class CodeBlock
extends IcfgEdge
implements IActionWithBranchEncoders {
    private static final long serialVersionUID = 1L;
    protected final ILogger mLogger;
    private final int mSerialnumber;
    protected UnmodifiableTransFormula mTransitionFormula;
    protected UnmodifiableTransFormula mTransitionFormulaWithBranchEncoders;
    private String mPrecedingProcedure;
    private String mSucceedingProcedure;

    CodeBlock(int n, BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, ILogger iLogger) {
        super((IcfgLocation)boogieIcfgLocation, (IcfgLocation)boogieIcfgLocation2, (IPayload)(boogieIcfgLocation == null ? new Payload() : new Payload(boogieIcfgLocation.getPayload())));
        this.mSerialnumber = n;
        this.mLogger = iLogger;
        this.connectSource(boogieIcfgLocation);
        this.connectTarget(boogieIcfgLocation2);
        this.setPreceedingProcedure(boogieIcfgLocation);
        this.setSucceedingProcedure(boogieIcfgLocation2);
    }

    @Deprecated
    public CodeBlock(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, ILogger iLogger) {
        super((IcfgLocation)boogieIcfgLocation, (IcfgLocation)boogieIcfgLocation2, (IPayload)(boogieIcfgLocation == null ? new Payload() : new Payload(boogieIcfgLocation.getPayload())));
        this.mSerialnumber = -1;
        this.mLogger = iLogger;
        this.connectSource(boogieIcfgLocation);
        this.connectTarget(boogieIcfgLocation2);
    }

    @Visualizable
    public abstract String getPrettyPrintedStatements();

    @Visualizable
    public UnmodifiableTransFormula getTransformula() {
        return this.mTransitionFormula;
    }

    public UnmodifiableTransFormula getTransitionFormulaWithBranchEncoders() {
        return this.mTransitionFormulaWithBranchEncoders;
    }

    public void setTransitionFormula(UnmodifiableTransFormula unmodifiableTransFormula) {
        this.mTransitionFormula = unmodifiableTransFormula;
        this.mTransitionFormulaWithBranchEncoders = unmodifiableTransFormula;
    }

    public int getSerialNumber() {
        return this.mSerialnumber;
    }

    private void setPreceedingProcedure(IcfgLocation icfgLocation) {
        if (icfgLocation instanceof BoogieIcfgLocation) {
            String string = icfgLocation.getProcedure();
            if (this.mPrecedingProcedure == null) {
                this.mPrecedingProcedure = string;
            } else if (!this.mPrecedingProcedure.equals(string)) {
                throw new AssertionError((Object)"proc must not change");
            }
        }
    }

    private void setSucceedingProcedure(IcfgLocation icfgLocation) {
        if (icfgLocation instanceof BoogieIcfgLocation) {
            String string = icfgLocation.getProcedure();
            if (this.mSucceedingProcedure == null) {
                this.mSucceedingProcedure = string;
            } else if (!this.mSucceedingProcedure.equals(string)) {
                throw new AssertionError((Object)"proc must not change");
            }
        }
    }

    public final void connectSource(IcfgLocation icfgLocation) {
        if (icfgLocation != null) {
            this.setSource(icfgLocation);
            icfgLocation.addOutgoing((IModifiableMultigraphEdge)this);
        }
    }

    public final void connectTarget(IcfgLocation icfgLocation) {
        if (icfgLocation != null) {
            this.setTarget(icfgLocation);
            icfgLocation.addIncoming((IModifiableMultigraphEdge)this);
        }
    }

    public String getPrecedingProcedure() {
        if (this.mPrecedingProcedure == null) {
            throw new IllegalArgumentException("Preceding procedure has not yet been determined.");
        }
        return this.mPrecedingProcedure;
    }

    public String getSucceedingProcedure() {
        if (this.mSucceedingProcedure == null) {
            throw new IllegalArgumentException("Succeeding procedure has not yet been determined.");
        }
        return this.mSucceedingProcedure;
    }

    public abstract String toString();

    public void setTarget(IcfgLocation icfgLocation) {
        this.setSucceedingProcedure(icfgLocation);
        super.setTarget((IModifiableExplicitEdgesMultigraph)icfgLocation);
    }

    public void setSource(IcfgLocation icfgLocation) {
        this.setPreceedingProcedure(icfgLocation);
        super.setSource((IModifiableExplicitEdgesMultigraph)icfgLocation);
    }

    protected int getNumberOfOpenCalls() {
        return 0;
    }

    public final int hashCode() {
        return this.getSerialNumber();
    }
}

