/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.annotations.UseDefSequence;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors.SimpleRCFGVisitor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors.UseDefSet;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.RootEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;

public class UseDefVisitor
extends SimpleRCFGVisitor {
    public UseDefVisitor(ILogger iLogger) {
        super(iLogger);
    }

    @Override
    public void pre(IcfgEdge icfgEdge) {
        super.pre(icfgEdge);
        UseDefSequence useDefSequence = new UseDefSequence();
        if (icfgEdge instanceof StatementSequence) {
            for (Statement statement : ((StatementSequence)icfgEdge).getStatements()) {
                useDefSequence.Sequence.add(this.processStatement(statement));
            }
        } else if (icfgEdge instanceof Call) {
            useDefSequence.Sequence.add(this.processStatement((Statement)((Call)icfgEdge).getCallStatement()));
        } else {
            if (icfgEdge instanceof GotoEdge) {
                this.mLogger.info((Object)("Ignoring GotoEdge edge " + String.valueOf(icfgEdge)));
                return;
            }
            if (icfgEdge instanceof ParallelComposition) {
                this.mLogger.info((Object)("Ignoring ParallelComposition edge " + String.valueOf(icfgEdge)));
                return;
            }
            if (icfgEdge instanceof Return) {
                this.mLogger.info((Object)("Ignoring Return edge " + String.valueOf(icfgEdge)));
                return;
            }
            if (icfgEdge instanceof SequentialComposition) {
                this.mLogger.info((Object)("Ignoring SequentialComposition edge " + String.valueOf(icfgEdge)));
                return;
            }
            if (icfgEdge instanceof Summary) {
                this.mLogger.info((Object)("Ignoring summary edge " + String.valueOf(icfgEdge)));
                return;
            }
            if (icfgEdge instanceof RootEdge) {
                this.mLogger.info((Object)("Ignoring root edge " + String.valueOf(icfgEdge)));
                return;
            }
            this.mLogger.debug((Object)("Unknown edge type: " + icfgEdge.getClass().getCanonicalName() + " " + String.valueOf(icfgEdge)));
            return;
        }
        useDefSequence.addAnnotation((IElement)icfgEdge);
    }

    private UseDefSet processStatement(Statement statement) {
        UseDefSet useDefSet = new UseDefSet();
        if (statement instanceof AssignmentStatement) {
            LeftHandSide leftHandSide;
            AssignmentStatement assignmentStatement = (AssignmentStatement)statement;
            LeftHandSide[] leftHandSideArray = assignmentStatement.getLhs();
            int n = leftHandSideArray.length;
            int n2 = 0;
            while (n2 < n) {
                leftHandSide = leftHandSideArray[n2];
                useDefSet = useDefSet.merge(this.processLeftHandSide(leftHandSide));
                ++n2;
            }
            leftHandSideArray = assignmentStatement.getRhs();
            n = leftHandSideArray.length;
            n2 = 0;
            while (n2 < n) {
                leftHandSide = leftHandSideArray[n2];
                useDefSet = useDefSet.merge(this.processExpression((Expression)leftHandSide));
                ++n2;
            }
            return useDefSet;
        }
        if (!(statement instanceof AssertStatement)) {
            if (statement instanceof AssumeStatement) {
                return this.processExpression(((AssumeStatement)statement).getFormula());
            }
            if (statement instanceof BreakStatement) {
                return useDefSet;
            }
            if (statement instanceof CallStatement) {
                VariableLHS variableLHS;
                CallStatement callStatement = (CallStatement)statement;
                VariableLHS[] variableLHSArray = callStatement.getLhs();
                int n = variableLHSArray.length;
                int n3 = 0;
                while (n3 < n) {
                    variableLHS = variableLHSArray[n3];
                    useDefSet.Def.add(variableLHS.toString());
                    ++n3;
                }
                variableLHSArray = callStatement.getArguments();
                n = variableLHSArray.length;
                n3 = 0;
                while (n3 < n) {
                    variableLHS = variableLHSArray[n3];
                    useDefSet = useDefSet.merge(this.processExpression((Expression)variableLHS));
                    ++n3;
                }
                return useDefSet;
            }
            if (statement instanceof GotoStatement) {
                return useDefSet;
            }
            if (statement instanceof HavocStatement) {
                VariableLHS[] variableLHSArray = ((HavocStatement)statement).getIdentifiers();
                int n = variableLHSArray.length;
                int n4 = 0;
                while (n4 < n) {
                    VariableLHS variableLHS = variableLHSArray[n4];
                    useDefSet.Def.add(variableLHS.toString());
                    ++n4;
                }
                return useDefSet;
            }
            if (statement instanceof IfStatement) {
                Statement statement2;
                IfStatement ifStatement = (IfStatement)statement;
                this.mLogger.debug((Object)"IfStatement in edge?");
                useDefSet = this.processExpression(ifStatement.getCondition());
                Statement[] statementArray = ifStatement.getThenPart();
                int n = statementArray.length;
                int n5 = 0;
                while (n5 < n) {
                    statement2 = statementArray[n5];
                    useDefSet = useDefSet.merge(this.processStatement(statement2));
                    ++n5;
                }
                statementArray = ifStatement.getElsePart();
                n = statementArray.length;
                n5 = 0;
                while (n5 < n) {
                    statement2 = statementArray[n5];
                    useDefSet = useDefSet.merge(this.processStatement(statement2));
                    ++n5;
                }
                return useDefSet;
            }
            if (statement instanceof Label) {
                return useDefSet;
            }
            if (statement instanceof ReturnStatement) {
                return useDefSet;
            }
            if (statement instanceof WhileStatement) {
                WhileStatement whileStatement = (WhileStatement)statement;
                this.mLogger.debug((Object)"WhileStatement in edge?");
                useDefSet = this.processExpression(whileStatement.getCondition());
                Statement[] statementArray = whileStatement.getBody();
                int n = statementArray.length;
                int n6 = 0;
                while (n6 < n) {
                    Statement statement3 = statementArray[n6];
                    useDefSet = useDefSet.merge(this.processStatement(statement3));
                    ++n6;
                }
                return useDefSet;
            }
        }
        this.mLogger.debug((Object)("Unknown statement type: " + statement.getClass().getCanonicalName() + " " + String.valueOf(statement)));
        return useDefSet;
    }

    private UseDefSet processExpression(Expression expression) {
        UseDefSet useDefSet = new UseDefSet();
        if (expression instanceof ArrayAccessExpression) {
            ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)expression;
            useDefSet = useDefSet.merge(this.processExpression(arrayAccessExpression.getArray()));
            Expression[] expressionArray = arrayAccessExpression.getIndices();
            int n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression2 = expressionArray[n2];
                useDefSet = useDefSet.merge(this.processExpression(expression2));
                ++n2;
            }
            return useDefSet;
        }
        if (!(expression instanceof ArrayStoreExpression)) {
            if (expression instanceof BinaryExpression) {
                BinaryExpression binaryExpression = (BinaryExpression)expression;
                return this.processExpression(binaryExpression.getLeft()).merge(this.processExpression(binaryExpression.getRight()));
            }
            if (expression instanceof BitvecLiteral) {
                return useDefSet;
            }
            if (!(expression instanceof BitVectorAccessExpression)) {
                if (expression instanceof BooleanLiteral) {
                    return useDefSet;
                }
                if (expression instanceof FunctionApplication) {
                    Expression[] expressionArray = ((FunctionApplication)expression).getArguments();
                    int n = expressionArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Expression expression3 = expressionArray[n3];
                        useDefSet = useDefSet.merge(this.processExpression(expression3));
                        ++n3;
                    }
                    return useDefSet;
                }
                if (expression instanceof IdentifierExpression) {
                    useDefSet.Use.add(((IdentifierExpression)expression).getIdentifier());
                    return useDefSet;
                }
                if (expression instanceof IfThenElseExpression) {
                    IfThenElseExpression ifThenElseExpression = (IfThenElseExpression)expression;
                    useDefSet = useDefSet.merge(this.processExpression(ifThenElseExpression.getCondition()));
                    useDefSet = useDefSet.merge(this.processExpression(ifThenElseExpression.getThenPart()));
                    useDefSet = useDefSet.merge(this.processExpression(ifThenElseExpression.getElsePart()));
                    return useDefSet;
                }
                if (expression instanceof IntegerLiteral) {
                    return useDefSet;
                }
                if (expression instanceof QuantifierExpression) {
                    this.mLogger.warn((Object)"Ignoring quantifier expression");
                    return useDefSet;
                }
                if (expression instanceof RealLiteral) {
                    return useDefSet;
                }
                if (expression instanceof StringLiteral) {
                    return useDefSet;
                }
                if (!(expression instanceof StructAccessExpression)) {
                    if (expression instanceof UnaryExpression) {
                        return this.processExpression(((UnaryExpression)expression).getExpr());
                    }
                    if (expression instanceof WildcardExpression) {
                        return useDefSet;
                    }
                }
            }
        }
        this.mLogger.debug((Object)("Unknown expression type: " + expression.getClass().getCanonicalName() + " " + String.valueOf(expression)));
        return useDefSet;
    }

    private UseDefSet processLeftHandSide(LeftHandSide leftHandSide) {
        UseDefSet useDefSet = new UseDefSet();
        if (!(leftHandSide instanceof ArrayLHS) && !(leftHandSide instanceof StructLHS) && leftHandSide instanceof VariableLHS) {
            useDefSet.Def.add(((VariableLHS)leftHandSide).getIdentifier());
            return useDefSet;
        }
        this.mLogger.debug((Object)("Unknown LeftHandSide type: " + leftHandSide.getClass().getCanonicalName() + " " + String.valueOf(leftHandSide)));
        return useDefSet;
    }

    public boolean performedChanges() {
        return false;
    }

    @Override
    public boolean abortCurrentBranch() {
        return false;
    }

    @Override
    public boolean abortAll() {
        return false;
    }
}

