/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.IncrementalImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConjunctiveAbstractInterpretationUtils {
    private ConjunctiveAbstractInterpretationUtils() {
    }

    public static <LOC extends IcfgLocation> Map<IcfgLocation, IPredicate> computeInvariants(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg, Widening widening) {
        BasicPredicateFactory basicPredicateFactory = new BasicPredicateFactory(iUltimateServiceProvider, iIcfg.getCfgSmtToolkit().getManagedScript(), iIcfg.getCfgSmtToolkit().getSymbolTable());
        HashMap<IcfgLocation, IPredicate> hashMap = new HashMap<IcfgLocation, IPredicate>();
        ArrayDeque arrayDeque = new ArrayDeque();
        ConjunctiveAbstractInterpretationUtils.initializeMapAndWorklist(iIcfg, arrayDeque, basicPredicateFactory, hashMap);
        ConjunctiveAbstractInterpretationUtils.doFixpointIteration(iUltimateServiceProvider, iIcfg, basicPredicateFactory, widening, arrayDeque, hashMap);
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(ConjunctiveAbstractInterpretationUtils.class);
        if (iLogger.isInfoEnabled()) {
            ConjunctiveAbstractInterpretationUtils.logInvariantInformation(iLogger, iIcfg, hashMap);
        }
        return hashMap;
    }

    private static <LOC extends IcfgLocation> void logInvariantInformation(ILogger iLogger, IIcfg<LOC> iIcfg, Map<IcfgLocation, IPredicate> map) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (Map.Entry<IcfgLocation, IPredicate> entry : map.entrySet()) {
            if (IcfgUtils.isErrorLocation(iIcfg, entry.getKey())) {
                ++n3;
                if (SmtUtils.isFalseLiteral((Term)entry.getValue().getFormula())) {
                    ++n4;
                }
            }
            if (SmtUtils.isTrueLiteral((Term)entry.getValue().getFormula())) {
                ++n;
                continue;
            }
            if (!SmtUtils.isFalseLiteral((Term)entry.getValue().getFormula())) continue;
            ++n2;
        }
        iLogger.info((Object)String.format("Applied ConjunctiveAbstractInterpretation to ICFG %s: %s locations (thereof %s times true, %s times false). ICFG has %s error locations (thereof %s labelled by false).", iIcfg.getIdentifier(), map.size(), n, n2, n3, n4));
    }

    private static <LOC extends IcfgLocation> void initializeMapAndWorklist(IIcfg<LOC> iIcfg, ArrayDeque<LOC> arrayDeque, BasicPredicateFactory basicPredicateFactory, Map<IcfgLocation, IPredicate> map) {
        IPredicate iPredicate = ConjunctiveAbstractInterpretationUtils.constructTruePredicate(iIcfg, basicPredicateFactory);
        IPredicate iPredicate2 = ConjunctiveAbstractInterpretationUtils.constructFalsePredicate(iIcfg, basicPredicateFactory);
        for (Map.Entry<String, Map<DebugIdentifier, LOC>> entry : iIcfg.getProgramPoints().entrySet()) {
            for (Map.Entry<DebugIdentifier, LOC> entry2 : entry.getValue().entrySet()) {
                IcfgLocation icfgLocation = (IcfgLocation)entry2.getValue();
                if (iIcfg.getInitialNodes().contains(icfgLocation)) {
                    map.put(icfgLocation, iPredicate);
                    arrayDeque.add(icfgLocation);
                    continue;
                }
                map.put(icfgLocation, iPredicate2);
            }
        }
    }

    private static <LOC extends IcfgLocation> IPredicate constructFalsePredicate(IIcfg<LOC> iIcfg, BasicPredicateFactory basicPredicateFactory) {
        return basicPredicateFactory.newPredicate(iIcfg.getCfgSmtToolkit().getManagedScript().getScript().term("false", new Term[0]));
    }

    private static <LOC extends IcfgLocation> IPredicate constructTruePredicate(IIcfg<LOC> iIcfg, BasicPredicateFactory basicPredicateFactory) {
        return basicPredicateFactory.newPredicate(iIcfg.getCfgSmtToolkit().getManagedScript().getScript().term("true", new Term[0]));
    }

    private static <LOC extends IcfgLocation> void doFixpointIteration(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg, BasicPredicateFactory basicPredicateFactory, Widening widening, ArrayDeque<LOC> arrayDeque, Map<IcfgLocation, IPredicate> map) {
        ManagedScript managedScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer = new PredicateTransformer<Term, IPredicate, TransFormula>(managedScript, new TermDomainOperationProvider(iUltimateServiceProvider, managedScript));
        long l = 0L;
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            IPredicate iPredicate = map.get(icfgLocation);
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                Object object;
                Object object2;
                Object object3;
                Term term;
                if (icfgEdge instanceof IIcfgInternalTransition) {
                    term = predicateTransformer.strongestPostcondition(iPredicate, icfgEdge.getTransformula());
                } else if (icfgEdge instanceof IIcfgSummaryTransition) {
                    if (((IIcfgSummaryTransition)((Object)icfgEdge)).calledProcedureHasImplementation()) continue;
                    term = predicateTransformer.strongestPostcondition(iPredicate, icfgEdge.getTransformula());
                } else if (icfgEdge instanceof IIcfgCallTransition) {
                    object3 = icfgEdge.getSucceedingProcedure();
                    object2 = icfgEdge.getTransformula();
                    object = iIcfg.getCfgSmtToolkit().getOldVarsAssignmentCache().getGlobalVarsAssignment((String)object3);
                    var18_17 = iIcfg.getCfgSmtToolkit().getOldVarsAssignmentCache().getGlobalVarsAssignment((String)object3);
                    var19_18 = iIcfg.getCfgSmtToolkit().getModifiableGlobalsTable().getModifiedBoogieVars((String)object3);
                    term = predicateTransformer.strongestPostconditionCall(iPredicate, (TransFormula)object2, (TransFormula)object, (TransFormula)var18_17, (Set<IProgramNonOldVar>)var19_18);
                } else if (icfgEdge instanceof IIcfgReturnTransition) {
                    object3 = icfgEdge.getPrecedingProcedure();
                    object2 = ((IIcfgReturnTransition)((Object)icfgEdge)).getCorrespondingCall();
                    object = iIcfg.getCfgSmtToolkit().getOldVarsAssignmentCache().getGlobalVarsAssignment((String)object3);
                    var18_17 = iIcfg.getCfgSmtToolkit().getModifiableGlobalsTable().getModifiedBoogieVars((String)object3);
                    var19_18 = map.get(((IIcfgReturnTransition)((Object)icfgEdge)).getCallerProgramPoint());
                    term = predicateTransformer.strongestPostconditionReturn(iPredicate, (IPredicate)var19_18, icfgEdge.getTransformula(), object2.getLocalVarsAssignment(), (TransFormula)object, (Set<IProgramNonOldVar>)var18_17);
                } else {
                    throw new AssertionError((Object)("Yet unsupported: " + icfgEdge.getClass().getSimpleName()));
                }
                object3 = (IcfgLocation)icfgEdge.getTarget();
                object2 = map.get(object3);
                object = ConjunctiveAbstractInterpretationUtils.widen(iUltimateServiceProvider, iIcfg, basicPredicateFactory, widening, (IPredicate)object2, term);
                if (object == null) continue;
                map.put((IcfgLocation)object3, (IPredicate)object);
                arrayDeque.add(object3);
            }
            ++l;
        }
        System.out.println("Iterations " + l);
    }

    private static <LOC extends IcfgLocation> IPredicate widen(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg, BasicPredicateFactory basicPredicateFactory, Widening widening, IPredicate iPredicate, Term term) {
        Term term2;
        HashSet<Term> hashSet = new HashSet<Term>(Arrays.asList(SmtUtils.getConjuncts((Term)iPredicate.getFormula())));
        HashSet<Term> hashSet2 = new HashSet<Term>(Arrays.asList(SmtUtils.getConjuncts((Term)term)));
        if (ConjunctiveAbstractInterpretationUtils.isFalse(hashSet)) {
            term2 = term;
        } else {
            Set<Term> set = switch (widening) {
                case Widening.INTERSECTION -> ConjunctiveAbstractInterpretationUtils.widenNaively(hashSet, hashSet2);
                case Widening.POLY_PAC -> throw new AssertionError((Object)"Not yet implemented.");
                case Widening.SMT_SOLVER -> ConjunctiveAbstractInterpretationUtils.widenBySolver(iUltimateServiceProvider, iIcfg.getCfgSmtToolkit().getManagedScript(), basicPredicateFactory, iPredicate, term, hashSet, hashSet2);
                default -> throw new MatchException(null, null);
            };
            term2 = SmtUtils.and((Script)iIcfg.getCfgSmtToolkit().getManagedScript().getScript(), set);
        }
        if (term2.equals(iPredicate.getFormula())) {
            return null;
        }
        return basicPredicateFactory.newPredicate(term2);
    }

    public static Set<Term> widenNaively(Set<Term> set, Set<Term> set2) {
        return DataStructureUtils.intersection(set2, set);
    }

    public static Set<Term> widenBySolver(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, BasicPredicateFactory basicPredicateFactory, IPredicate iPredicate, Term term, Set<Term> set, Set<Term> set2) {
        HashSet<Term> hashSet = new HashSet<Term>();
        BasicPredicate basicPredicate = basicPredicateFactory.newPredicate(term);
        ConjunctiveAbstractInterpretationUtils.addImplied(iUltimateServiceProvider, managedScript, basicPredicateFactory, iPredicate, set, set2, hashSet);
        ConjunctiveAbstractInterpretationUtils.addImplied(iUltimateServiceProvider, managedScript, basicPredicateFactory, basicPredicate, set2, set, hashSet);
        return hashSet;
    }

    public static void addImplied(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, BasicPredicateFactory basicPredicateFactory, IPredicate iPredicate, Set<Term> set, Set<Term> set2, Set<Term> set3) {
        IncrementalImplicationChecker incrementalImplicationChecker = new IncrementalImplicationChecker(iUltimateServiceProvider, managedScript);
        for (Term term : set2) {
            BasicPredicate basicPredicate;
            IncrementalPlicationChecker.Validity validity;
            if (set.contains(term)) {
                set3.add(term);
                continue;
            }
            if (!QuantifierUtils.isQuantifierFree((Term)term) || (validity = incrementalImplicationChecker.checkImplication(iPredicate, basicPredicate = basicPredicateFactory.newPredicate(term))) != IncrementalPlicationChecker.Validity.VALID) continue;
            set3.add(term);
        }
        incrementalImplicationChecker.releaseLock();
    }

    private static boolean isFalse(Set<Term> set) {
        return set.size() == 1 && SmtUtils.isFalseLiteral((Term)set.iterator().next());
    }

    public static enum Widening {
        INTERSECTION,
        SMT_SOLVER,
        POLY_PAC;

    }
}

