/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.core.runtime.CoreException;

public class ManagedConfigStorageElement
implements ICStorageElement {
    private IManagedConfigElement fElement;
    private List<IManagedConfigElement> fChildList;
    private ManagedConfigStorageElement fParent;

    public ManagedConfigStorageElement(IManagedConfigElement el) {
        this(el, null);
    }

    public ManagedConfigStorageElement(IManagedConfigElement el, ManagedConfigStorageElement parent) {
        this.fElement = el;
        this.fParent = parent;
    }

    public void clear() {
        throw new WriteAccessException();
    }

    public ICStorageElement createChild(String name) {
        throw new WriteAccessException();
    }

    public String getAttribute(String name) {
        return this.fElement.getAttribute(name);
    }

    public boolean hasAttribute(String name) {
        return this.fElement.getAttribute(name) != null;
    }

    public ICStorageElement[] getChildren() {
        List<IManagedConfigElement> list = this.getChildList(true);
        return list.toArray(new ManagedConfigStorageElement[list.size()]);
    }

    private List<IManagedConfigElement> getChildList(boolean create) {
        if (this.fChildList == null && create) {
            IManagedConfigElement[] children = this.fElement.getChildren();
            this.fChildList = new ArrayList<IManagedConfigElement>(children.length);
            this.fChildList.addAll(Arrays.asList(children));
        }
        return this.fChildList;
    }

    public ICStorageElement[] getChildrenByName(String name) {
        ArrayList<ICStorageElement> children = new ArrayList<ICStorageElement>();
        ICStorageElement[] iCStorageElementArray = this.getChildren();
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (name.equals(child.getName())) {
                children.add(child);
            }
            ++n2;
        }
        return children.toArray(new ICStorageElement[children.size()]);
    }

    public boolean hasChildren() {
        return this.getChildList(true).isEmpty();
    }

    public String getName() {
        return this.fElement.getName();
    }

    public ICStorageElement getParent() {
        return this.fParent;
    }

    public String getValue() {
        return null;
    }

    public ICStorageElement importChild(ICStorageElement el) throws UnsupportedOperationException {
        throw new WriteAccessException();
    }

    public void removeAttribute(String name) {
        throw new WriteAccessException();
    }

    public void removeChild(ICStorageElement el) {
        throw new WriteAccessException();
    }

    public void setAttribute(String name, String value) {
        throw new WriteAccessException();
    }

    public void setValue(String value) {
        throw new WriteAccessException();
    }

    public String[] getAttributeNames() {
        throw new UnsupportedOperationException();
    }

    public ICStorageElement createCopy() throws UnsupportedOperationException, CoreException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(ICStorageElement other) {
        throw new UnsupportedOperationException();
    }
}

