/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.LazyPetriNet2FiniteAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.PetriNet2FiniteAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareProofSettings;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.NwaHoareProofProducer;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.IInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class Petri2FiniteAutomatonAbstractionProvider<L extends IIcfgTransition<?>, A extends INwaOutgoingLetterAndTransitionProvider<L, IPredicate>>
implements IInitialAbstractionProvider<L, A> {
    protected final IInitialAbstractionProvider<L, ? extends IPetriNet<L, IPredicate>> mUnderlying;
    protected final IUltimateServiceProvider mServices;
    protected final AutomataLibraryServices mAutomataServices;
    protected final IPetriNet2FiniteAutomatonStateFactory<IPredicate> mStateFactory;

    public Petri2FiniteAutomatonAbstractionProvider(IUltimateServiceProvider iUltimateServiceProvider, IInitialAbstractionProvider<L, ? extends IPetriNet<L, IPredicate>> iInitialAbstractionProvider, IPetriNet2FiniteAutomatonStateFactory<IPredicate> iPetriNet2FiniteAutomatonStateFactory) {
        this.mUnderlying = iInitialAbstractionProvider;
        this.mServices = iUltimateServiceProvider;
        this.mAutomataServices = new AutomataLibraryServices(iUltimateServiceProvider);
        this.mStateFactory = iPetriNet2FiniteAutomatonStateFactory;
    }

    protected static boolean areAllLocationsHopeless(Map<IcfgLocation, Boolean> map, Set<? extends IcfgLocation> set, Marking<IPredicate> marking) {
        for (IPredicate iPredicate : marking) {
            IcfgLocation icfgLocation;
            if (!(iPredicate instanceof ISLPredicate) || Petri2FiniteAutomatonAbstractionProvider.isLocationHopeless(map, set, icfgLocation = ((ISLPredicate)iPredicate).getProgramPoint())) continue;
            return false;
        }
        return true;
    }

    private static boolean isLocationHopeless(Map<IcfgLocation, Boolean> map, Set<? extends IcfgLocation> set, IcfgLocation icfgLocation2) {
        if (set.contains(icfgLocation2)) {
            return false;
        }
        return !IcfgUtils.canReachCached((IcfgLocation)icfgLocation2, icfgEdge -> set.contains(icfgEdge.getTarget()), icfgEdge -> false, icfgLocation -> {
            if (!map.containsKey(icfgLocation)) {
                return Script.LBool.UNKNOWN;
            }
            return (Boolean)map.get(icfgLocation) != false ? Script.LBool.SAT : Script.LBool.UNSAT;
        }, (icfgLocation, bl) -> {
            assert (map.getOrDefault(icfgLocation, (Boolean)bl) == bl) : "contradictory reachability";
            assert (bl != null);
            map.put((IcfgLocation)icfgLocation, (Boolean)bl);
        });
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mUnderlying.getStatistics();
    }

    public static class Eager<L extends IIcfgTransition<?>>
    extends Petri2FiniteAutomatonAbstractionProvider<L, INestedWordAutomaton<L, IPredicate>> {
        private INestedWordAutomaton<L, IPredicate> mAbstraction;
        private CfgSmtToolkit mCsToolkit;

        public Eager(IUltimateServiceProvider iUltimateServiceProvider, IInitialAbstractionProvider<L, ? extends IPetriNet<L, IPredicate>> iInitialAbstractionProvider, IPetriNet2FiniteAutomatonStateFactory<IPredicate> iPetriNet2FiniteAutomatonStateFactory) {
            super(iUltimateServiceProvider, iInitialAbstractionProvider, iPetriNet2FiniteAutomatonStateFactory);
        }

        @Override
        public INestedWordAutomaton<L, IPredicate> getInitialAbstraction(IIcfg<? extends IcfgLocation> iIcfg, Set<? extends IcfgLocation> set) throws AutomataLibraryException {
            this.mCsToolkit = iIcfg.getCfgSmtToolkit();
            IPetriNet iPetriNet = (IPetriNet)this.mUnderlying.getInitialAbstraction(iIcfg, set);
            try {
                HashMap hashMap = new HashMap();
                this.mAbstraction = new PetriNet2FiniteAutomaton(this.mAutomataServices, this.mStateFactory, (IPetriNetTransitionProvider)iPetriNet, marking -> Eager.areAllLocationsHopeless(hashMap, set, (Marking<IPredicate>)marking)).getResult();
                return this.mAbstraction;
            }
            catch (PetriNetNot1SafeException petriNetNot1SafeException) {
                Collection collection = petriNetNot1SafeException.getUnsafePlaces();
                if (collection == null) {
                    throw new AssertionError((Object)"Unable to find Petri net place that violates 1-safety");
                }
                ISLPredicate iSLPredicate = (ISLPredicate)collection.iterator().next();
                String string = iSLPredicate.getProgramPoint().getProcedure();
                throw new IllegalStateException("Petrification does not provide enough thread instances for " + string);
            }
        }

        public NwaHoareProofProducer<L> getProofProducer(PredicateFactory predicateFactory, HoareProofSettings hoareProofSettings) {
            return new NwaHoareProofProducer(this.mServices, this.mAbstraction, this.mCsToolkit, predicateFactory, hoareProofSettings, this.mAbstraction.getStates());
        }
    }

    public static class Lazy<L extends IIcfgTransition<?>>
    extends Petri2FiniteAutomatonAbstractionProvider<L, LazyPetriNet2FiniteAutomaton<L, IPredicate>> {
        public Lazy(IUltimateServiceProvider iUltimateServiceProvider, IInitialAbstractionProvider<L, ? extends IPetriNet<L, IPredicate>> iInitialAbstractionProvider, IPetriNet2FiniteAutomatonStateFactory<IPredicate> iPetriNet2FiniteAutomatonStateFactory) {
            super(iUltimateServiceProvider, iInitialAbstractionProvider, iPetriNet2FiniteAutomatonStateFactory);
        }

        @Override
        public LazyPetriNet2FiniteAutomaton<L, IPredicate> getInitialAbstraction(IIcfg<? extends IcfgLocation> iIcfg, Set<? extends IcfgLocation> set) throws AutomataLibraryException {
            IPetriNet iPetriNet = (IPetriNet)this.mUnderlying.getInitialAbstraction(iIcfg, set);
            HashMap hashMap = new HashMap();
            return new LazyPetriNet2FiniteAutomaton(this.mAutomataServices, this.mStateFactory, (IPetriNetTransitionProvider)iPetriNet, marking -> Lazy.areAllLocationsHopeless(hashMap, set, (Marking<IPredicate>)marking));
        }
    }
}

