/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.IInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceSettings;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe.PetriNetLargeBlockEncoding;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.Set;

public class PetriLbeInitialAbstractionProvider<L extends IIcfgTransition<?>>
implements IInitialAbstractionProvider<L, BoundedPetriNet<L, IPredicate>> {
    private final IUltimateServiceProvider mServices;
    private final IInitialAbstractionProvider<L, BoundedPetriNet<L, IPredicate>> mUnderlying;
    private final PetriNetLargeBlockEncoding.IPLBECompositionFactory<L> mCompositionFactory;
    private final Class<L> mTransitionClazz;
    private final IndependenceSettings mIndependenceSettings;
    private final Statistics mStatistics;

    public PetriLbeInitialAbstractionProvider(IUltimateServiceProvider iUltimateServiceProvider, IInitialAbstractionProvider<L, BoundedPetriNet<L, IPredicate>> iInitialAbstractionProvider, Class<L> clazz, IndependenceSettings independenceSettings, PetriNetLargeBlockEncoding.IPLBECompositionFactory<L> iPLBECompositionFactory) {
        this.mUnderlying = iInitialAbstractionProvider;
        this.mServices = iUltimateServiceProvider;
        this.mTransitionClazz = clazz;
        this.mIndependenceSettings = independenceSettings;
        this.mCompositionFactory = iPLBECompositionFactory;
        this.mStatistics = new Statistics();
    }

    @Override
    public BoundedPetriNet<L, IPredicate> getInitialAbstraction(IIcfg<? extends IcfgLocation> iIcfg, Set<? extends IcfgLocation> set) throws AutomataLibraryException {
        BoundedPetriNet<L, IPredicate> boundedPetriNet = this.mUnderlying.getInitialAbstraction(iIcfg, set);
        PetriNetLargeBlockEncoding<L> petriNetLargeBlockEncoding = new PetriNetLargeBlockEncoding<L>(this.mServices, iIcfg.getCfgSmtToolkit(), boundedPetriNet, this.mIndependenceSettings, this.mCompositionFactory, this.mTransitionClazz);
        BoundedPetriNet<L, IPredicate> boundedPetriNet2 = petriNetLargeBlockEncoding.getResult();
        this.mServices.getBacktranslationService().addTranslator((ITranslator)petriNetLargeBlockEncoding.getBacktranslator());
        this.mStatistics.reportLiptonStatistics(petriNetLargeBlockEncoding);
        return boundedPetriNet2;
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    private class Statistics
    extends AbstractStatisticsDataProvider {
        private static final String LIPTON_STATISTICS = "PetriNetLargeBlockEncoding benchmarks";
        private static final String UNDERLYING_STATISTICS = "Statistics of underlying abstraction provider";

        public Statistics() {
            this.forward(UNDERLYING_STATISTICS, PetriLbeInitialAbstractionProvider.this.mUnderlying::getStatistics);
        }

        private void reportLiptonStatistics(PetriNetLargeBlockEncoding<?> petriNetLargeBlockEncoding) {
            StatisticsData statisticsData = new StatisticsData();
            statisticsData.aggregateBenchmarkData(petriNetLargeBlockEncoding.getStatistics());
            this.include(LIPTON_STATISTICS, () -> statisticsData);
        }
    }
}

