/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public final class BuchiClosureNwa<LETTER, STATE>
implements IDoubleDeckerAutomaton<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final Set<STATE> mAcceptingStates;

    public BuchiClosureNwa(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mOperand = iNestedWordAutomaton;
        this.mAcceptingStates = this.computeSetOfAcceptingStates();
    }

    public Set<STATE> computeSetOfAcceptingStates() {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Accepting states before buchiClosure: " + this.mOperand.getFinalStates().size()));
        }
        HashSet<STATE> hashSet = new HashSet<STATE>();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        hashSet.addAll(this.mOperand.getFinalStates());
        for (Object object : this.mOperand.getFinalStates()) {
            this.addAllNonFinalPredecessors(object, linkedHashSet, hashSet);
        }
        while (!linkedHashSet.isEmpty()) {
            Object object;
            object = linkedHashSet.iterator().next();
            linkedHashSet.remove(object);
            assert (!hashSet.contains(object));
            if (!this.allSuccessorsAccepting(object, hashSet)) continue;
            hashSet.add(object);
            this.addAllNonFinalPredecessors(object, linkedHashSet, hashSet);
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Accepting states after buchiClosure: " + hashSet.size()));
        }
        return hashSet;
    }

    private void addAllNonFinalPredecessors(STATE STATE, Set<STATE> set, Set<STATE> set2) {
        for (IncomingInternalTransition<LETTER, STATE> iTransitionlet : this.mOperand.internalPredecessors(STATE)) {
            if (set2.contains(iTransitionlet.getPred())) continue;
            set.add(iTransitionlet.getPred());
        }
        for (IncomingCallTransition incomingCallTransition : this.mOperand.callPredecessors(STATE)) {
            if (set2.contains(incomingCallTransition.getPred())) continue;
            set.add(incomingCallTransition.getPred());
        }
        for (IncomingReturnTransition incomingReturnTransition : this.mOperand.returnPredecessors(STATE)) {
            if (set2.contains(incomingReturnTransition.getLinPred())) continue;
            set.add(incomingReturnTransition.getLinPred());
        }
    }

    private boolean allSuccessorsAccepting(STATE STATE, Set<STATE> set) {
        STATE STATE2;
        for (OutgoingInternalTransition iOutgoingTransitionlet : this.mOperand.internalSuccessors(STATE)) {
            STATE2 = iOutgoingTransitionlet.getSucc();
            if (set.contains(STATE2)) continue;
            return false;
        }
        for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(STATE)) {
            STATE2 = outgoingCallTransition.getSucc();
            if (set.contains(STATE2)) continue;
            return false;
        }
        for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessors(STATE)) {
            STATE2 = outgoingReturnTransition.getSucc();
            if (set.contains(STATE2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<STATE> getInitialStates() {
        return this.mOperand.getInitialStates();
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mOperand.getStateFactory();
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mOperand.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mAcceptingStates.contains(STATE);
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mOperand.getEmptyStackState();
    }

    @Override
    public Set<LETTER> lettersInternal(STATE STATE) {
        return this.mOperand.lettersInternal(STATE);
    }

    @Override
    public Set<LETTER> lettersCall(STATE STATE) {
        return this.mOperand.lettersCall(STATE);
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        return this.mOperand.lettersReturn(STATE, STATE2);
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE) {
        return this.mOperand.lettersReturn(STATE);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        return this.mOperand.internalSuccessors(STATE, LETTER);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        return this.mOperand.internalSuccessors(STATE);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        return this.mOperand.callSuccessors(STATE, LETTER);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        return this.mOperand.callSuccessors(STATE);
    }

    @Override
    public int size() {
        return this.mOperand.size();
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mOperand.getAlphabet();
    }

    @Override
    public String sizeInformation() {
        return this.mOperand.sizeInformation();
    }

    @Override
    public Set<STATE> getStates() {
        return this.mOperand.getStates();
    }

    @Override
    public Collection<STATE> getFinalStates() {
        return this.mAcceptingStates;
    }

    @Override
    public Iterable<SummaryReturnTransition<LETTER, STATE>> summarySuccessors(STATE STATE, LETTER LETTER) {
        return this.mOperand.summarySuccessors(STATE, LETTER);
    }

    @Override
    public Iterable<SummaryReturnTransition<LETTER, STATE>> summarySuccessors(STATE STATE) {
        return this.mOperand.summarySuccessors(STATE);
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE) {
        return this.mOperand.internalPredecessors(STATE);
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE, LETTER LETTER) {
        return this.mOperand.internalPredecessors(STATE, LETTER);
    }

    @Override
    public Set<LETTER> lettersInternalIncoming(STATE STATE) {
        return this.mOperand.lettersInternalIncoming(STATE);
    }

    @Override
    public Set<LETTER> lettersCallIncoming(STATE STATE) {
        return this.mOperand.lettersCallIncoming(STATE);
    }

    @Override
    public Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(STATE STATE, LETTER LETTER) {
        return this.mOperand.callPredecessors(STATE, LETTER);
    }

    @Override
    public Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(STATE STATE) {
        return this.mOperand.callPredecessors(STATE);
    }

    @Override
    public Set<LETTER> lettersReturnIncoming(STATE STATE) {
        return this.mOperand.lettersReturnIncoming(STATE);
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        return this.mOperand.returnPredecessors(STATE, STATE2, LETTER);
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE, LETTER LETTER) {
        return this.mOperand.returnPredecessors(STATE, LETTER);
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE) {
        return this.mOperand.returnPredecessors(STATE);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        return this.mOperand.returnSuccessors(STATE, STATE2, LETTER);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE) {
        return this.mOperand.returnSuccessors(STATE);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        return this.mOperand.returnSuccessorsGivenHier(STATE, STATE2);
    }

    @Override
    public Set<LETTER> lettersSummary(STATE STATE) {
        return this.mOperand.lettersSummary(STATE);
    }

    @Override
    public boolean isDoubleDecker(STATE STATE, STATE STATE2) {
        return ((IDoubleDeckerAutomaton)this.mOperand).isDoubleDecker(STATE, STATE2);
    }

    @Override
    @Deprecated
    public Set<STATE> getDownStates(STATE STATE) {
        return ((IDoubleDeckerAutomaton)this.mOperand).getDownStates(STATE);
    }
}

