/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.SmtFeatureHeuristic;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractionTermClassifier;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashedPriorityQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class IsEmptyHeuristic<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private static final boolean DEBUG_MESSAGES_USE_HASHCODE = false;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final Predicate<STATE> mIsGoalState;
    private final Predicate<STATE> mIsForbiddenState;
    private final NestedRun<LETTER, STATE> mAcceptingRun;
    private final STATE mDummyEmptyStackState;
    private final IHeuristic<STATE, LETTER> mHeuristic;

    public IsEmptyHeuristic(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, IHeuristic.getZeroHeuristic());
    }

    public IsEmptyHeuristic(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IHeuristic<STATE, LETTER> iHeuristic) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, CoreUtil.constructHashSet(iNwaOutgoingLetterAndTransitionProvider.getInitialStates()), (STATE object) -> false, iNwaOutgoingLetterAndTransitionProvider::isFinal, iHeuristic);
    }

    public IsEmptyHeuristic(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Set<STATE> set, Predicate<STATE> predicate, Predicate<STATE> predicate2, IHeuristic<STATE, LETTER> iHeuristic) throws AutomataOperationCanceledException {
        this(automataLibraryServices, (INwaOutgoingLetterAndTransitionProvider<LETTER, STATE>)iNestedWordAutomaton, set, predicate, predicate2, iHeuristic);
        assert (iNestedWordAutomaton.getStates().containsAll(set)) : "unknown states";
    }

    private IsEmptyHeuristic(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, Set<STATE> set, Predicate<STATE> predicate, Predicate<STATE> predicate2, IHeuristic<STATE, LETTER> iHeuristic) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mIsGoalState = predicate2;
        this.mIsForbiddenState = predicate;
        this.mHeuristic = iHeuristic;
        assert (set != null);
        assert (this.mIsGoalState != null);
        assert (this.mIsForbiddenState != null);
        assert (this.mOperand != null);
        this.mDummyEmptyStackState = this.mOperand.getEmptyStackState();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mAcceptingRun = this.getAcceptingRun(set, iHeuristic);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private NestedRun<LETTER, STATE> getAcceptingRun(Collection<STATE> collection, IHeuristic<STATE, LETTER> iHeuristic) throws AutomataOperationCanceledException {
        Object object2;
        Object object32;
        HashedPriorityQueue hashedPriorityQueue = new HashedPriorityQueue(Comparator.comparing(item -> item.mEstimatedCostToTarget));
        for (Object object32 : collection) {
            object2 = new Item(object32);
            ((Item)object2).setCostSoFar(0.0);
            hashedPriorityQueue.add(object2);
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)String.format("Initial queue: %s", hashedPriorityQueue));
        }
        object32 = new HashMap();
        HashMap hashMap = new HashMap();
        object2 = new HashMap();
        HashMap<Object, Set> hashMap2 = new HashMap<Object, Set>();
        HashMap<CallTransition, Map<ReturnTransition, SummaryItem>> hashMap3 = new HashMap<CallTransition, Map<ReturnTransition, SummaryItem>>();
        HashMap<CallTransition, Map<ReturnTransition, Set<Item>>> hashMap4 = new HashMap<CallTransition, Map<ReturnTransition, Set<Item>>>();
        while (!hashedPriorityQueue.isEmpty()) {
            Object object4;
            Object object5;
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                object5 = "searching accepting run (input had " + this.mOperand.size() + " states)";
                object4 = new RunningTaskInfo(this.getClass(), (String)object5);
                throw new AutomataOperationCanceledException((RunningTaskInfo)object4);
            }
            object5 = (Item)hashedPriorityQueue.poll();
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)String.format("Current: %s", object5));
            }
            if (this.mIsGoalState.test(((Item)object5).mTargetState)) {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)"  Is target");
                    this.printDebugStats(hashMap, (Map<Item, Double>)object32, (Map<CallTransition, Map<ReturnTransition, SummaryItem>>)hashMap3);
                }
                return ((Item)object5).constructRun();
            }
            object4 = ((Item)object5).mItemType == ItemType.RETURN ? this.updateSummaries(hashMap3, hashMap4, (Item)object5) : Collections.emptyList();
            List<Item> list = this.getUnvaluatedSuccessors((Item)object5, (Map<STATE, Set<STATE>>)object2, (Map<STATE, Set<Item>>)hashMap2);
            if (this.mLogger.isDebugEnabled() && list.isEmpty()) {
                this.mLogger.debug((Object)"  No successors");
                continue;
            }
            List<Item> list2 = this.addCostAndSummaries(list, hashMap3, hashMap4, iHeuristic, ((Item)object5).mCostSoFar);
            list2.addAll((Collection<Item>)object4);
            if (iHeuristic instanceof SmtFeatureHeuristic && ((SmtFeatureHeuristic)iHeuristic).getScoringMethod() == SMTFeatureExtractionTermClassifier.ScoringMethod.COMPARE_FEATURES) {
                ((SmtFeatureHeuristic)iHeuristic).compareSuccessors(list2);
            }
            for (Item item2 : list2) {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)String.format("  Succ: %s", item2));
                }
                double d = item2.mCostSoFar;
                Double d2 = item2.mItemType == ItemType.CALL ? (Double)hashMap.get(item2) : (Double)object32.get(item2);
                if (d2 != null && d >= d2) {
                    if (!this.mLogger.isDebugEnabled()) continue;
                    this.mLogger.debug((Object)String.format("    Skip (cost %s, but have seen with cost %s)", d, d2));
                    continue;
                }
                if (item2.mItemType == ItemType.CALL && !this.isCheapestAncestor(hashMap, (Map<STATE, Set<STATE>>)object2, item2, d)) {
                    hashMap2.computeIfAbsent(((Item)object5).getHierPreState(), object -> new LinkedHashSet()).add(item2);
                    continue;
                }
                double d3 = iHeuristic.getHeuristicValue(item2.mTargetState, item2.getHierPreState(), item2.mLetter);
                item2.setEstimatedCostToTarget(d3);
                if (hashedPriorityQueue.remove((Object)item2)) {
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug((Object)String.format("    Updated: %s", item2));
                    }
                } else if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)String.format("    Insert: %s", item2));
                }
                hashedPriorityQueue.add((Object)item2);
                if (item2.mItemType == ItemType.CALL) {
                    hashMap.put(item2, d);
                    continue;
                }
                object32.put(item2, d);
            }
        }
        if (this.mLogger.isDebugEnabled()) {
            this.printDebugStats(hashMap, (Map<Item, Double>)object32, (Map<CallTransition, Map<ReturnTransition, SummaryItem>>)hashMap3);
        }
        return null;
    }

    private void printDebugStats(Map<Item, Double> map, Map<Item, Double> map2, Map<CallTransition, Map<ReturnTransition, SummaryItem>> map3) {
        this.mLogger.debug((Object)String.format("Found %d lowest call configurations", map.size()));
        this.mLogger.debug((Object)String.format("Found %d lowest configurations", map2.size()));
        this.mLogger.debug((Object)String.format("Found summaries for %d calls", map3.size()));
        this.mLogger.debug((Object)String.format("Summary size histogram: [%s]", map3.entrySet().stream().map(entry -> ((Map)entry.getValue()).size()).sorted((n, n2) -> -Integer.compare(n, n2)).map(String::valueOf).collect(Collectors.joining(","))));
    }

    private List<Item> addCostAndSummaries(List<Item> list, Map<CallTransition, Map<ReturnTransition, SummaryItem>> map, Map<CallTransition, Map<ReturnTransition, Set<Item>>> map2, IHeuristic<STATE, LETTER> iHeuristic, double d) {
        ArrayList<Item> arrayList = new ArrayList<Item>(2 * list.size());
        for (Item item : list) {
            CallTransition callTransition2;
            Map<ReturnTransition, SummaryItem> map3;
            if (item.mCostSoFar >= 0.0) {
                arrayList.add(item);
                continue;
            }
            double d2 = iHeuristic.getConcreteCost(item.mLetter);
            if (item.mItemType == ItemType.CALL && (map3 = map.get(callTransition2 = new CallTransition(item))) != null) {
                assert (!map3.isEmpty());
                item.setCostSoFar(d + d2);
                Map map4 = map2.computeIfAbsent(callTransition2, callTransition -> new HashMap());
                for (Map.Entry<ReturnTransition, SummaryItem> entry : map3.entrySet()) {
                    SummaryItem summaryItem = entry.getValue();
                    Item item2 = new Item(item, summaryItem);
                    item2.setCostSoFar(item.mCostSoFar + summaryItem.mSummaryCost);
                    arrayList.add(item2);
                    map4.computeIfAbsent(entry.getKey(), returnTransition -> new LinkedHashSet()).add(item);
                    if (!this.mLogger.isDebugEnabled()) continue;
                    this.mLogger.debug((Object)String.format("  Using summary %s instead of %s", summaryItem, item));
                    this.mLogger.debug((Object)String.format("    Subrun: %s ", summaryItem.mSubrun));
                }
                continue;
            }
            item.setCostSoFar(d + d2);
            arrayList.add(item);
        }
        return arrayList;
    }

    private List<Item> updateSummaries(Map<CallTransition, Map<ReturnTransition, SummaryItem>> map, Map<CallTransition, Map<ReturnTransition, Set<Item>>> map2, Item item) {
        Item item2 = item.findCorrespondingCallItem();
        CallTransition callTransition2 = new CallTransition(item2);
        ReturnTransition returnTransition = new ReturnTransition(item);
        Map map3 = map.computeIfAbsent(callTransition2, callTransition -> new HashMap());
        SummaryItem summaryItem = (SummaryItem)map3.get(returnTransition);
        if (summaryItem == null) {
            Map<ReturnTransition, Set<Item>> map4;
            SummaryItem summaryItem2 = new SummaryItem(item, item2);
            map3.put(returnTransition, summaryItem2);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)String.format("  Is fresh summary: %s", summaryItem2));
            }
            if ((map4 = map2.get(callTransition2)) != null) {
                ArrayList<Item> arrayList = new ArrayList<Item>();
                for (Map.Entry<ReturnTransition, Set<Item>> entry : map4.entrySet()) {
                    for (Item item3 : entry.getValue()) {
                        Item item4 = new Item(item3, summaryItem2);
                        item4.setCostSoFar(item3.mCostSoFar + summaryItem2.mSummaryCost);
                        arrayList.add(item4);
                    }
                }
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)String.format("  Re-added %d items for the fresh summary", arrayList.size()));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }
        double d = item.mCostSoFar - item2.mCostSoFar;
        if (d < summaryItem.mSummaryCost) {
            SummaryItem summaryItem3 = new SummaryItem(item, item2);
            map3.put(returnTransition, summaryItem3);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)String.format("  Found cheaper summary (old cost was %s, new is %s): %s", summaryItem.mSummaryCost, d, summaryItem3));
            }
        } else if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)String.format("  Will not replace old summary (cost %s) with this one (cost %s)", summaryItem.mSummaryCost, d));
        }
        return Collections.emptyList();
    }

    private boolean isCheapestAncestor(Map<Item, Double> map, Map<STATE, Set<STATE>> map2, Item item, double d) {
        assert (item.mItemType == ItemType.CALL) : "It only makes sense to check Calls for cheapest ancestor";
        for (Map.Entry<Item, Double> entry : map.entrySet()) {
            int n;
            Item item2 = entry.getKey();
            if (!item2.mLetter.equals(item.mLetter) || !Objects.equals(item2.getBackpointer().getTargetState(), item.getBackpointer().getTargetState())) continue;
            double d2 = entry.getValue();
            if (item2.mHierPreStates.size() >= item.mHierPreStates.size() || !item2.isHierStatesPrefixOf(item, n = map2.getOrDefault(item.getHierPreState(), Collections.emptySet()).size()) || !(d >= d2)) continue;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)String.format("    Skip for now (cost %s, but have seen %d-extended prefix with cost %s: %s)", d, n, d2, item2));
            }
            return false;
        }
        return true;
    }

    private List<Item> getUnvaluatedSuccessors(Item item, Map<STATE, Set<STATE>> map, Map<STATE, Set<Item>> map2) {
        Object object2;
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (OutgoingInternalTransition<LETTER, STATE> iOutgoingTransitionlet2 : this.mOperand.internalSuccessors(item.mTargetState)) {
            LETTER LETTER = iOutgoingTransitionlet2.getLetter();
            object2 = iOutgoingTransitionlet2.getSucc();
            if (this.mIsForbiddenState.test(object2)) continue;
            arrayList.add(new Item(object2, item.getHierPreState(), LETTER, item, ItemType.INTERNAL));
        }
        for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(item.mTargetState)) {
            Object LETTER = outgoingCallTransition.getLetter();
            object2 = outgoingCallTransition.getSucc();
            if (this.mIsForbiddenState.test(object2)) continue;
            arrayList.add(new Item(object2, item.mTargetState, LETTER, item, ItemType.CALL));
        }
        Object STATE = item.getHierPreState();
        if (STATE == null || STATE == this.mDummyEmptyStackState) {
            return arrayList;
        }
        int n = arrayList.size();
        for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessorsGivenHier(item.mTargetState, STATE)) {
            Object LETTER = outgoingReturnTransition.getLetter();
            Object STATE2 = outgoingReturnTransition.getSucc();
            if (this.mIsForbiddenState.test(STATE2)) continue;
            arrayList.add(new Item(STATE2, null, LETTER, item, ItemType.RETURN));
        }
        if (n != arrayList.size()) {
            map.computeIfAbsent(STATE, object -> new HashSet()).add(item.mTargetState);
            Set<Item> set = map2.remove(STATE);
            if (set != null) {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)String.format("  Re-adding %d delayed calls", set.size()));
                }
                arrayList.addAll(set);
            }
        }
        return arrayList;
    }

    private double recomputeCost(NestedRun<LETTER, STATE> nestedRun) {
        return nestedRun.getWord().asList().stream().collect(Collectors.summingDouble(this.mHeuristic::getConcreteCost));
    }

    private boolean checkCost(double d, NestedRun<LETTER, STATE> nestedRun) {
        if (d < 0.0) {
            this.mLogger.fatal((Object)"Cost must be positive or zero");
            return false;
        }
        double d2 = this.recomputeCost(nestedRun);
        if (d != d2) {
            this.mLogger.fatal((Object)"Cost is not sum of concrete cost");
            return false;
        }
        return true;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Boolean getResult() {
        if (this.mAcceptingRun == null) {
            return true;
        }
        return false;
    }

    public NestedRun<LETTER, STATE> getNestedRun() {
        return this.mAcceptingRun;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        if (this.mAcceptingRun == null) {
            boolean bl = new IsEmpty<LETTER, STATE>(this.mServices, this.mOperand).getResult();
            if (!bl) {
                this.mLogger.fatal((Object)("IsEmpty found an accepting run and " + this.getClass().getSimpleName() + " did not"));
            }
            return bl;
        }
        boolean bl = new Accepts<LETTER, STATE>(this.mServices, this.mOperand, this.mAcceptingRun.getWord()).getResult();
        if (!bl) {
            this.mLogger.fatal((Object)(this.getClass().getSimpleName() + " found a run, but it is not accepted"));
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Run is " + String.valueOf(this.mAcceptingRun)));
        }
        return bl;
    }

    @Override
    public String exitMessage() {
        if (this.mAcceptingRun == null) {
            return "Finished " + this.getOperationName() + ". No accepting run.";
        }
        return "Finished " + this.getOperationName() + ". Found accepting run of length " + this.mAcceptingRun.getLength();
    }

    public static enum AStarHeuristic {
        ZERO,
        RANDOM_HALF,
        RANDOM_FULL,
        SMT_FEATURE_COMPARISON;

    }

    private class CallTransition {
        private final STATE mTargetState;
        private final STATE mHierPreState;
        private final LETTER mTransition;
        private final int mHash;

        private CallTransition(Item item) {
            this.mTransition = item.mLetter;
            this.mTargetState = item.mTargetState;
            this.mHierPreState = item.getHierPreState();
            this.mHash = HashUtils.hashHsieh((int)31, (Object[])new Object[]{this.mHierPreState, this.mTargetState, this.mTransition});
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CallTransition callTransition = (CallTransition)object;
            if (!this.mHierPreState.equals(callTransition.mHierPreState)) {
                return false;
            }
            if (!this.mTargetState.equals(callTransition.mTargetState)) {
                return false;
            }
            return this.mTransition.equals(callTransition.mTransition);
        }
    }

    private static final class ElementHashedArrayDeque<E>
    extends ArrayDeque<E> {
        private static final long serialVersionUID = 1L;

        public ElementHashedArrayDeque() {
        }

        public ElementHashedArrayDeque(Collection<? extends E> collection) {
            super(collection);
        }

        @Override
        public int hashCode() {
            int n = 1;
            for (Object e : this) {
                n = 31 * n + (e == null ? 0 : e.hashCode());
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ElementHashedArrayDeque)) {
                return false;
            }
            Iterator iterator = this.iterator();
            Iterator iterator2 = ((ElementHashedArrayDeque)object).iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                Object e = iterator.next();
                Object e2 = iterator2.next();
                if (!(e == null ? e2 != null : !e.equals(e2))) continue;
                return false;
            }
            return !iterator.hasNext() && !iterator2.hasNext();
        }
    }

    public static interface IHeuristic<STATE, LETTER> {
        public static final /* synthetic */ int[] $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$automata$nestedword$operations$IsEmptyHeuristic$AStarHeuristic;

        static {
            $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$automata$nestedword$operations$IsEmptyHeuristic$AStarHeuristic = IHeuristic.$SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$automata$nestedword$operations$IsEmptyHeuristic$AStarHeuristic();
        }

        public double getHeuristicValue(STATE var1, STATE var2, LETTER var3);

        public double getConcreteCost(LETTER var1);

        public static <STATE, LETTER> IHeuristic<STATE, LETTER> getHeuristic(AStarHeuristic aStarHeuristic, SMTFeatureExtractionTermClassifier.ScoringMethod scoringMethod, long l) {
            return switch (aStarHeuristic) {
                case AStarHeuristic.RANDOM_FULL -> IHeuristic.getRandomHeuristicFull(l);
                case AStarHeuristic.RANDOM_HALF -> IHeuristic.getRandomHeuristicHalf(l);
                case AStarHeuristic.SMT_FEATURE_COMPARISON -> IHeuristic.getSmtFeatureHeuristic(scoringMethod);
                case AStarHeuristic.ZERO -> IHeuristic.getZeroHeuristic();
                default -> throw new MatchException(null, null);
            };
        }

        public static <STATE, LETTER> IHeuristic<STATE, LETTER> getZeroHeuristic() {
            return new IHeuristic<STATE, LETTER>(){

                @Override
                public final double getHeuristicValue(STATE STATE, STATE STATE2, LETTER LETTER) {
                    return 0.0;
                }

                @Override
                public final double getConcreteCost(LETTER LETTER) {
                    return 1.0;
                }
            };
        }

        public static <STATE, LETTER> IHeuristic<STATE, LETTER> getRandomHeuristicHalf(long l) {
            return new IHeuristic<STATE, LETTER>(l){
                private final Random mRandom;
                private final Map<LETTER, Double> mConcreteCosts;
                {
                    this.mRandom = new Random(l);
                    this.mConcreteCosts = new HashMap();
                }

                @Override
                public final double getHeuristicValue(STATE STATE, STATE STATE2, LETTER LETTER) {
                    return 0.5 * this.mRandom.nextDouble() + 0.5;
                }

                @Override
                public final double getConcreteCost(LETTER LETTER) {
                    return this.mConcreteCosts.computeIfAbsent(LETTER, object -> 0.5 * this.mRandom.nextDouble() + 0.5);
                }
            };
        }

        public static <STATE, LETTER> IHeuristic<STATE, LETTER> getRandomHeuristicFull(long l) {
            return new IHeuristic<STATE, LETTER>(l){
                private final Random mRandom;
                private final Map<LETTER, Double> mConcreteCosts;
                {
                    this.mRandom = new Random(l);
                    this.mConcreteCosts = new HashMap();
                }

                @Override
                public final double getHeuristicValue(STATE STATE, STATE STATE2, LETTER LETTER) {
                    return this.mRandom.nextDouble();
                }

                @Override
                public final double getConcreteCost(LETTER LETTER) {
                    return this.mConcreteCosts.computeIfAbsent(LETTER, object -> 0.1 + this.mRandom.nextDouble());
                }
            };
        }

        public static <STATE, LETTER> SmtFeatureHeuristic<STATE, LETTER> getSmtFeatureHeuristic(SMTFeatureExtractionTermClassifier.ScoringMethod scoringMethod) {
            return new SmtFeatureHeuristic(scoringMethod);
        }
    }

    private static interface IWithBackPointer<STATE> {
        public IWithBackPointer<STATE> getBackpointer();

        public STATE getTargetState();
    }

    public class Item
    implements Comparable<Item>,
    IWithBackPointer<STATE> {
        private final STATE mTargetState;
        private final Deque<STATE> mHierPreStates;
        private final LETTER mLetter;
        private final IWithBackPointer<STATE> mBackPointer;
        private final ItemType mItemType;
        private final int mHashCode;
        private double mCostSoFar;
        private double mEstimatedCostToTargetFromHere;
        private double mEstimatedCostToTarget;

        private Item(STATE STATE) {
            this(STATE, isEmptyHeuristic.mDummyEmptyStackState, null, null, ItemType.INITIAL);
        }

        private Item(STATE STATE, STATE STATE2, LETTER LETTER, Item item, ItemType itemType) {
            this.mTargetState = STATE;
            if (itemType == ItemType.INTERNAL) {
                this.mHierPreStates = item.mHierPreStates;
            } else if (itemType == ItemType.RETURN) {
                this.mHierPreStates = new ElementHashedArrayDeque(item.mHierPreStates);
                this.mHierPreStates.pop();
            } else if (itemType == ItemType.CALL) {
                this.mHierPreStates = new ElementHashedArrayDeque(item.mHierPreStates);
                this.mHierPreStates.push(STATE2);
            } else {
                this.mHierPreStates = new ElementHashedArrayDeque();
                this.mHierPreStates.push(STATE2);
            }
            this.mLetter = LETTER;
            this.mBackPointer = item;
            this.mItemType = itemType;
            this.mCostSoFar = -1.0;
            this.mEstimatedCostToTarget = Double.MAX_VALUE;
            this.mEstimatedCostToTargetFromHere = Double.MAX_VALUE;
            this.mHashCode = this.computeHashCode();
        }

        private Item(Item item, SummaryItem summaryItem) {
            this.mTargetState = summaryItem.mReturnItem.mTargetState;
            this.mHierPreStates = new ElementHashedArrayDeque(item.mHierPreStates);
            this.mHierPreStates.pop();
            this.mLetter = summaryItem.mReturnItem.mLetter;
            this.mBackPointer = new SummaryItem(item, summaryItem);
            this.mItemType = ItemType.RETURN;
            this.mCostSoFar = -1.0;
            this.mEstimatedCostToTarget = Double.MAX_VALUE;
            this.mEstimatedCostToTargetFromHere = Double.MAX_VALUE;
            this.mHashCode = this.computeHashCode();
        }

        void setEstimatedCostToTarget(double d) {
            this.mEstimatedCostToTargetFromHere = d;
            this.mEstimatedCostToTarget = this.mEstimatedCostToTargetFromHere + this.mCostSoFar;
        }

        void setCostSoFar(double d) {
            this.mCostSoFar = d;
            assert (IsEmptyHeuristic.this.checkCost(this.mCostSoFar, this.constructRun())) : "Cost is wrong";
        }

        @Override
        public int compareTo(Item item) {
            return Double.compare(this.mEstimatedCostToTarget, item.mEstimatedCostToTarget);
        }

        public STATE getHierPreState() {
            return this.mHierPreStates.peek();
        }

        @Override
        public STATE getTargetState() {
            return this.mTargetState;
        }

        public boolean isHierStatesPrefixOf(Item item) {
            Iterator iterator = this.mHierPreStates.descendingIterator();
            Iterator iterator2 = item.mHierPreStates.descendingIterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                Object STATE = iterator.next();
                Object STATE2 = iterator2.next();
                if (!(STATE == null ? STATE2 != null : !STATE.equals(STATE2))) continue;
                return false;
            }
            return !iterator.hasNext();
        }

        /*
         * Unable to fully structure code
         */
        public boolean isHierStatesPrefixOf(Item var1_1, int var2_2) {
            var3_3 = this.mHierPreStates.descendingIterator();
            var4_4 = var1_1.mHierPreStates.descendingIterator();
            while (var3_3.hasNext() && var4_4.hasNext()) {
                var5_5 = var3_3.next();
                var6_6 = var4_4.next();
                if (!(var5_5 == null ? var6_6 != null : var5_5.equals(var6_6) == false)) continue;
                return false;
            }
            if (!var3_3.hasNext()) ** GOTO lbl13
            return false;
lbl-1000:
            // 1 sources

            {
                --var2_2;
                var4_4.next();
lbl13:
                // 2 sources

                ** while (var4_4.hasNext() && var2_2 > 0)
            }
lbl14:
            // 1 sources

            return var4_4.hasNext() != false || var2_2 < 0;
        }

        public boolean isAncestorEqual(Item item) {
            Iterator iterator = this.mHierPreStates.iterator();
            Iterator iterator2 = item.mHierPreStates.iterator();
            int n = 0;
            while (iterator.hasNext() && iterator2.hasNext() && n < 2) {
                Object STATE = iterator.next();
                Object STATE2 = iterator2.next();
                if (STATE == null ? STATE2 != null : !STATE.equals(STATE2)) {
                    return false;
                }
                ++n;
            }
            return n == 2;
        }

        public Item findCorrespondingCallItem() {
            if (this.mItemType != ItemType.RETURN) {
                return null;
            }
            IWithBackPointer iWithBackPointer = this.mBackPointer;
            ArrayDeque<Item> arrayDeque = new ArrayDeque<Item>();
            while (iWithBackPointer != null) {
                if (iWithBackPointer.getClass() == this.getClass()) {
                    Item item = (Item)iWithBackPointer;
                    if (item.mItemType == ItemType.RETURN) {
                        arrayDeque.push(item);
                    } else if (item.mItemType == ItemType.CALL) {
                        if (arrayDeque.isEmpty()) {
                            return item;
                        }
                        arrayDeque.pop();
                    }
                }
                iWithBackPointer = iWithBackPointer.getBackpointer();
            }
            return null;
        }

        public NestedRun<LETTER, STATE> constructRun() {
            return this.constructRun(Objects::isNull, false);
        }

        public NestedRun<LETTER, STATE> constructRun(Predicate<IWithBackPointer<STATE>> predicate, boolean bl) {
            ArrayList<Item> arrayList = new ArrayList<Item>();
            IWithBackPointer iWithBackPointer = this;
            do {
                arrayList.add((Item)iWithBackPointer);
            } while (!predicate.test(iWithBackPointer = iWithBackPointer.getBackpointer()));
            if (bl) {
                arrayList.add((Item)iWithBackPointer);
            }
            Collections.reverse(arrayList);
            ArrayList arrayList2 = new ArrayList();
            ArrayList<Item> arrayList3 = new ArrayList<Item>();
            for (IWithBackPointer object2 : arrayList) {
                if (object2.getClass() == this.getClass()) {
                    arrayList3.add((Item)object2);
                    continue;
                }
                if (!(object2 instanceof SummaryItem)) continue;
                arrayList2.add(this.constructRunFromItems(arrayList3));
                arrayList2.add(((SummaryItem)object2).mSubrun);
                arrayList3 = new ArrayList();
            }
            if (!arrayList3.isEmpty()) {
                arrayList2.add(this.constructRunFromItems(arrayList3));
            }
            assert (!arrayList2.isEmpty());
            Iterator iterator = arrayList2.iterator();
            NestedRun nestedRun = null;
            while (iterator.hasNext()) {
                nestedRun = nestedRun == null ? (NestedRun)iterator.next() : nestedRun.concatenate((NestedRun)iterator.next());
            }
            return nestedRun;
        }

        private NestedRun<LETTER, STATE> constructRunFromItems(List<Item> list) {
            if (list.isEmpty()) {
                throw new IllegalArgumentException();
            }
            ArrayList arrayList = new ArrayList();
            Item item = list.get(0);
            arrayList.add(item.mTargetState);
            Object[] objectArray = new Object[list.size() - 1];
            return this.constructRunFromItemsWithoutInitialState(list.subList(1, list.size()), arrayList, objectArray);
        }

        private NestedRun<LETTER, STATE> constructRunFromItemsWithoutInitialState(List<Item> list, ArrayList<STATE> arrayList, LETTER[] LETTERArray) {
            ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
            int[] nArray = new int[LETTERArray.length];
            int n = 0;
            for (Item object2 : list) {
                LETTERArray[n] = object2.mLetter;
                arrayList.add(object2.mTargetState);
                switch (object2.mItemType) {
                    case CALL: {
                        arrayDeque.push(n);
                        nArray[n] = Integer.MAX_VALUE;
                        break;
                    }
                    case INTERNAL: {
                        nArray[n] = -2;
                        break;
                    }
                    case RETURN: {
                        int n2;
                        if (arrayDeque.isEmpty()) {
                            nArray[n] = Integer.MIN_VALUE;
                            break;
                        }
                        nArray[n] = n2 = ((Integer)arrayDeque.pop()).intValue();
                        nArray[n2] = n;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                ++n;
            }
            NestedWord nestedWord = new NestedWord(LETTERArray, nArray);
            return new NestedRun(nestedWord, arrayList);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        private int computeHashCode() {
            int n = 1;
            n = 31 * n + (this.mHierPreStates == null ? 0 : this.mHierPreStates.hashCode());
            n = 31 * n + (this.mTargetState == null ? 0 : this.mTargetState.hashCode());
            n = 31 * n + (this.mLetter == null ? 0 : this.mLetter.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Item item = (Item)object;
            if (this.mHierPreStates == null ? item.mHierPreStates != null : !this.mHierPreStates.equals(item.mHierPreStates)) {
                return false;
            }
            if (this.mTargetState == null ? item.mTargetState != null : !this.mTargetState.equals(item.mTargetState)) {
                return false;
            }
            return !(this.mLetter == null ? item.mLetter != null : !this.mLetter.equals(item.mLetter));
        }

        public String toString() {
            Function<Object, String> function = Objects::toString;
            String string = this.mHierPreStates.stream().map(function).collect(Collectors.joining(","));
            if (this.mCostSoFar == 0.0) {
                return String.format("%8s: {%s} T%s {%s}", new Object[]{this.mItemType, string, this.mLetter == null ? Integer.valueOf(0) : function.apply(this.mLetter), function.apply(this.mTargetState)});
            }
            String string2 = this.mEstimatedCostToTarget == Double.MAX_VALUE ? "MAX" : String.valueOf(this.mEstimatedCostToTarget);
            String string3 = this.mEstimatedCostToTargetFromHere == Double.MAX_VALUE ? "MAX" : String.valueOf(this.mEstimatedCostToTargetFromHere);
            return String.format("%8s: {%s} T%s {%s} (g=%f, h=%s, f=%s, s=%d)", new Object[]{this.mItemType, string, this.mLetter == null ? Integer.valueOf(0) : function.apply(this.mLetter), function.apply(this.mTargetState), this.mCostSoFar, string3, string2, this.mHierPreStates.size()});
        }

        @Override
        public IWithBackPointer<STATE> getBackpointer() {
            return this.mBackPointer;
        }

        public LETTER getLetter() {
            return this.mLetter;
        }
    }

    private static enum ItemType {
        CALL,
        RETURN,
        INTERNAL,
        INITIAL;

    }

    private class ReturnTransition {
        private final STATE mTargetState;
        private final LETTER mTransition;
        private final int mHash;

        private ReturnTransition(Item item) {
            this.mTransition = item.mLetter;
            this.mTargetState = item.mTargetState;
            this.mHash = HashUtils.hashHsieh((int)31, (Object[])new Object[]{this.mTargetState, this.mTransition});
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ReturnTransition returnTransition = (ReturnTransition)object;
            if (!this.mTargetState.equals(returnTransition.mTargetState)) {
                return false;
            }
            return this.mTransition.equals(returnTransition.mTransition);
        }
    }

    private class SummaryItem
    implements IWithBackPointer<STATE> {
        private final double mSummaryCost;
        private final NestedRun<LETTER, STATE> mSubrun;
        private final IWithBackPointer<STATE> mBackPointer;
        private final Item mReturnItem;

        public SummaryItem(Item item, Item item2) {
            this(item.mCostSoFar - item2.mCostSoFar, item.constructRun(iWithBackPointer -> iWithBackPointer == item2, true), item, item2);
        }

        public SummaryItem(Item item, SummaryItem summaryItem) {
            this(summaryItem.mSummaryCost, summaryItem.mSubrun, summaryItem.mReturnItem, item);
        }

        private SummaryItem(double d, NestedRun<LETTER, STATE> nestedRun, Item item, IWithBackPointer<STATE> iWithBackPointer) {
            this.mSummaryCost = d;
            this.mSubrun = nestedRun;
            this.mReturnItem = item;
            this.mBackPointer = iWithBackPointer;
            assert (this.mSubrun != null) : "Summary must have subrun";
            assert (IsEmptyHeuristic.this.checkCost(this.mSummaryCost, this.mSubrun)) : "Summary cost is wrong";
        }

        @Override
        public IWithBackPointer<STATE> getBackpointer() {
            return this.mBackPointer;
        }

        @Override
        public STATE getTargetState() {
            return this.mSubrun.getStateAtPosition(this.mSubrun.getLength());
        }

        public String toString() {
            return String.format(" Summary for {%s} to {%s} (cost=%s)", this.mBackPointer, this.mReturnItem, this.mSummaryCost);
        }

        public int hashCode() {
            return 31 + this.mReturnItem.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SummaryItem summaryItem = (SummaryItem)object;
            return this.mReturnItem.equals(summaryItem.mReturnItem);
        }
    }
}

