/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResultAtLocation;
import de.uni_freiburg.informatik.ultimate.core.lib.results.SyntaxErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnsupportedSyntaxResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.Activator;

public class CTranslationResultReporter {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private boolean mReportUnsoundnessWarning;

    public CTranslationResultReporter(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mReportUnsoundnessWarning = false;
    }

    public void enableUnsoundnessWarning() {
        this.mReportUnsoundnessWarning = true;
    }

    public void warn(ILocation iLocation, String string) {
        if (!this.mReportUnsoundnessWarning) {
            return;
        }
        String string2 = string + " " + String.valueOf(iLocation);
        this.mLogger.warn((Object)("Unsoundness Warning: " + string2));
        GenericResultAtLocation genericResultAtLocation = new GenericResultAtLocation("CACSL2BoogieTranslator", iLocation, "Unsoundness Warning", string2, IResultWithSeverity.Severity.WARNING);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)genericResultAtLocation);
    }

    public void syntaxError(ILocation iLocation, String string) {
        SyntaxErrorResult syntaxErrorResult = new SyntaxErrorResult("CACSL2BoogieTranslator", iLocation, string);
        this.mLogger.warn((Object)string);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)syntaxErrorResult);
        this.mServices.getProgressMonitorService().cancelToolchain();
    }

    public void unsupportedSyntax(ILocation iLocation, String string) {
        UnsupportedSyntaxResult unsupportedSyntaxResult = new UnsupportedSyntaxResult("CACSL2BoogieTranslator", iLocation, string);
        this.mLogger.warn((Object)string);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)unsupportedSyntaxResult);
        this.mServices.getProgressMonitorService().cancelToolchain();
    }
}

