/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.BitabsTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.FloatFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.ISOIEC9899TC3;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;

public class IntegerTranslation
extends ExpressionTranslation {
    private static final String NOT_IMPLEMENTED = "Operation is not yet implemented in non-bitprecise translation.";
    private final BitabsTranslation mBitabsTranslation;

    public IntegerTranslation(TypeSizes typeSizes, TranslationSettings translationSettings, ITypeHandler iTypeHandler, FlatSymbolTable flatSymbolTable) {
        super(typeSizes, translationSettings, iTypeHandler, flatSymbolTable);
        this.mBitabsTranslation = new BitabsTranslation(typeSizes);
    }

    @Override
    public RValue translateIntegerLiteral(ILocation iLocation, String string) {
        return ISOIEC9899TC3.handleIntegerConstant(string, iLocation, false, this.mTypeSizes);
    }

    @Override
    public Expression constructLiteralForIntegerType(ILocation iLocation, CPrimitive cPrimitive, BigInteger bigInteger) {
        return ISOIEC9899TC3.constructLiteralForCIntegerLiteral(iLocation, false, this.mTypeSizes, cPrimitive, bigInteger);
    }

    @Override
    public Expression constructLiteralForFloatingType(ILocation iLocation, CPrimitive cPrimitive, BigDecimal bigDecimal) {
        return ExpressionFactory.createRealLiteral((ILocation)iLocation, (String)bigDecimal.toString());
    }

    @Override
    public Expression constructBinaryComparisonIntegerExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        if (!cPrimitive.equals(cPrimitive2)) {
            throw new IllegalArgumentException("incompatible types " + String.valueOf(cPrimitive) + " and " + String.valueOf(cPrimitive2));
        }
        Pair<Expression, Expression> pair = this.applyWraparoundsIfNecessary(iLocation, expression, cPrimitive, expression2, cPrimitive2);
        return IntegerTranslation.constructBinaryComparison(iLocation, n, (Expression)pair.getFirst(), (Expression)pair.getSecond());
    }

    private static Expression constructBinaryComparison(ILocation iLocation, int n, Expression expression, Expression expression2) {
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)(switch (n) {
            case 28 -> BinaryExpression.Operator.COMPEQ;
            case 11 -> BinaryExpression.Operator.COMPGEQ;
            case 9 -> BinaryExpression.Operator.COMPGT;
            case 10 -> BinaryExpression.Operator.COMPLEQ;
            case 8 -> BinaryExpression.Operator.COMPLT;
            case 29 -> BinaryExpression.Operator.COMPNEQ;
            default -> throw new AssertionError((Object)("Unknown BinaryExpression operator " + n));
        }), (Expression)expression, (Expression)expression2);
    }

    @Override
    public Expression applyWraparound(ILocation iLocation, CPrimitive cPrimitive, Expression expression) {
        if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.INTTYPE) {
            if (this.mTypeSizes.isUnsigned(cPrimitive)) {
                BigInteger bigInteger = this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive).add(BigInteger.ONE);
                return IntegerTranslation.applyEucledeanModulo(iLocation, expression, bigInteger);
            }
            throw new AssertionError((Object)"wraparound only for unsigned types");
        }
        throw new AssertionError((Object)"wraparound only for integer types");
    }

    private static Expression applyEucledeanModulo(ILocation iLocation, Expression expression, BigInteger bigInteger) {
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMOD, (Expression)expression, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)bigInteger.toString()));
    }

    @Override
    protected ExpressionResult handleBinaryBitwiseIntegerExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2, AuxVarInfoBuilder auxVarInfoBuilder) {
        switch (n) {
            case 12: 
            case 25: {
                return this.mBitabsTranslation.abstractAnd(iLocation, expression, expression2, cPrimitive, auxVarInfoBuilder);
            }
            case 14: 
            case 27: {
                return this.mBitabsTranslation.abstractOr(iLocation, expression, expression2, cPrimitive, auxVarInfoBuilder);
            }
            case 13: 
            case 26: {
                return this.mBitabsTranslation.abstractXor(iLocation, expression, expression2, cPrimitive, auxVarInfoBuilder);
            }
            case 6: 
            case 23: {
                return this.mBitabsTranslation.abstractLeftShift(iLocation, expression, cPrimitive, expression2, cPrimitive2, auxVarInfoBuilder);
            }
            case 7: 
            case 24: {
                return this.mBitabsTranslation.abstractRightShift(iLocation, expression, cPrimitive, expression2, cPrimitive2, auxVarInfoBuilder);
            }
        }
        throw new UnsupportedSyntaxException(iLocation, "Unknown or unsupported bitwise expression");
    }

    @Override
    protected Expression constructUnaryIntegerExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive) {
        switch (n) {
            case 6: {
                return this.constructUnaryComplementExpression(iLocation, expression, cPrimitive);
            }
            case 3: {
                return IntegerTranslation.constructUnaryMinusExpression(iLocation, expression, cPrimitive);
            }
        }
        throw new UnsupportedSyntaxException(iLocation, "Unknown or unsupported bitwise expression");
    }

    private Expression constructUnaryComplementExpression(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        String string = this.mTypeSizes.isUnsigned(cPrimitive) ? this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive).toString() : "-1";
        IntegerLiteral integerLiteral = ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)string);
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMINUS, (Expression)integerLiteral, (Expression)expression);
    }

    private static Expression constructUnaryMinusExpression(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.INTTYPE || cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE) {
            return ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.ARITHNEGATIVE, (Expression)expression);
        }
        throw new IllegalArgumentException("Unsupported type for unary minus: " + String.valueOf(cPrimitive));
    }

    @Override
    public Expression constructArithmeticIntegerExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        assert (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.INTTYPE);
        assert (cPrimitive2.getGeneralType() == CPrimitive.CPrimitiveCategory.INTTYPE);
        switch (n) {
            case 1: 
            case 4: 
            case 5: 
            case 18: 
            case 21: 
            case 22: {
                return IntegerTranslation.constructArithmeticExpression(iLocation, n, expression, expression2);
            }
            case 2: 
            case 19: {
                Pair<Expression, Expression> pair = this.applyWraparoundsIfNecessary(iLocation, expression, cPrimitive, expression2, cPrimitive2);
                return this.constructDivExpression(iLocation, (Expression)pair.getFirst(), (Expression)pair.getSecond(), cPrimitive, cPrimitive2);
            }
            case 3: 
            case 20: {
                Pair<Expression, Expression> pair = this.applyWraparoundsIfNecessary(iLocation, expression, cPrimitive, expression2, cPrimitive2);
                return this.constructModExpression(iLocation, (Expression)pair.getFirst(), (Expression)pair.getSecond(), cPrimitive, cPrimitive2);
            }
        }
        throw new UnsupportedSyntaxException(iLocation, "Unknown or unsupported arithmetic expression");
    }

    @Override
    public Pair<Expression, ASTType> constructInfinitePrecisionOperation(ILocation iLocation, int n, Expression expression, Expression expression2, CPrimitive cPrimitive) {
        Pair<Expression, Expression> pair = this.applyWraparoundsIfNecessary(iLocation, expression, cPrimitive, expression2, cPrimitive);
        return new Pair((Object)IntegerTranslation.constructArithmeticExpression(iLocation, n, (Expression)pair.getFirst(), (Expression)pair.getSecond()), (Object)this.mTypeHandler.cType2AstType(iLocation, cPrimitive));
    }

    private Pair<Expression, Expression> applyWraparoundsIfNecessary(ILocation iLocation, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        if (this.mTypeSizes.isUnsigned(cPrimitive)) {
            assert (this.mTypeSizes.isUnsigned(cPrimitive2)) : "incompatible types";
            return new Pair((Object)this.applyWraparound(iLocation, cPrimitive, expression), (Object)this.applyWraparound(iLocation, cPrimitive2, expression2));
        }
        return new Pair((Object)expression, (Object)expression2);
    }

    private Expression constructDivExpression(ILocation iLocation, Expression expression, Expression expression2, CPrimitive cPrimitive, CPrimitive cPrimitive2) {
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(expression, cPrimitive);
        BigInteger bigInteger2 = this.mTypeSizes.extractIntegerValue(expression2, cPrimitive2);
        if (bigInteger != null && bigInteger.signum() == 0 || BigInteger.ONE.equals(bigInteger2)) {
            return expression;
        }
        if (bigInteger != null && bigInteger2 != null) {
            return ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)bigInteger.divide(bigInteger2).toString());
        }
        Expression expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHDIV, (Expression)expression, (Expression)expression2);
        if (this.mTypeSizes.isUnsigned(cPrimitive) || bigInteger != null && bigInteger.signum() > 0) {
            return expression3;
        }
        Expression expression4 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression2, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)"0"));
        IntegerLiteral integerLiteral = ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)"1");
        Expression expression5 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression4, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMINUS, (Expression)expression3, (Expression)integerLiteral), (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHPLUS, (Expression)expression3, (Expression)integerLiteral));
        if (bigInteger != null) {
            return expression5;
        }
        return ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)IntegerTranslation.getLeftSmallerZeroAndThereIsRemainder(iLocation, expression, expression2), (Expression)expression5, (Expression)expression3);
    }

    private Expression constructModExpression(ILocation iLocation, Expression expression, Expression expression2, CPrimitive cPrimitive, CPrimitive cPrimitive2) {
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(expression, cPrimitive);
        if (bigInteger != null && bigInteger.signum() == 0) {
            return expression;
        }
        BigInteger bigInteger2 = this.mTypeSizes.extractIntegerValue(expression2, cPrimitive2);
        if (BigInteger.ONE.equals(bigInteger2)) {
            return ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)"0");
        }
        if (bigInteger != null && bigInteger2 != null) {
            String string;
            if (bigInteger2.signum() == 0) {
                string = "0";
            } else {
                BigInteger bigInteger3 = bigInteger.abs().mod(bigInteger2.abs());
                string = (bigInteger.signum() >= 0 ? bigInteger3 : bigInteger3.negate()).toString();
            }
            return ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)string);
        }
        Expression expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMOD, (Expression)expression, (Expression)expression2);
        if (this.mTypeSizes.isUnsigned(cPrimitive) || bigInteger != null && bigInteger.signum() > 0) {
            return expression3;
        }
        Expression expression4 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression2, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)"0"));
        Expression expression5 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression4, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHPLUS, (Expression)expression3, (Expression)expression2), (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMINUS, (Expression)expression3, (Expression)expression2));
        if (bigInteger != null) {
            return expression5;
        }
        return ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)IntegerTranslation.getLeftSmallerZeroAndThereIsRemainder(iLocation, expression, expression2), (Expression)expression5, (Expression)expression3);
    }

    private static Expression getLeftSmallerZeroAndThereIsRemainder(ILocation iLocation, Expression expression, Expression expression2) {
        Expression expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMOD, (Expression)expression, (Expression)expression2);
        Expression expression4 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPNEQ, (Expression)expression3, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)"0"));
        Expression expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)"0"));
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression5, (Expression)expression4);
    }

    @Override
    protected ExpressionResult convertIntToIntNonBool(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        if (cPrimitive.isIntegerType()) {
            Expression expression = this.convertToIntegerType(iLocation, expressionResult.getLrValue().getValue(), (CPrimitive)expressionResult.getLrValue().getCType().getUnderlyingType(), cPrimitive);
            return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(expression, cPrimitive)).build();
        }
        throw new UnsupportedOperationException("not yet supported: conversion to " + String.valueOf(cPrimitive));
    }

    private Expression convertToIntegerType(ILocation iLocation, Expression expression, CPrimitive cPrimitive, CPrimitive cPrimitive2) {
        assert (cPrimitive2.isIntegerType());
        if (!cPrimitive.isIntegerType()) {
            throw new UnsupportedOperationException("not yet supported: conversion from " + String.valueOf(cPrimitive));
        }
        if (this.mTypeSizes.isUnsigned(cPrimitive2)) {
            if (this.mTypeSizes.isUnsigned(cPrimitive) && this.mTypeSizes.getSize(cPrimitive2.getType()) > this.mTypeSizes.getSize(cPrimitive.getType())) {
                return this.applyWraparound(iLocation, cPrimitive, expression);
            }
            return expression;
        }
        assert (!this.mTypeSizes.isUnsigned(cPrimitive2));
        Expression expression2 = this.mTypeSizes.isUnsigned(cPrimitive) ? this.applyWraparound(iLocation, cPrimitive, expression) : expression;
        if (this.mTypeSizes.getSize(cPrimitive2.getType()) >= this.mTypeSizes.getSize(cPrimitive.getType()) && !this.mTypeSizes.isUnsigned(cPrimitive)) {
            return expression2;
        }
        return this.convertToSmallerSignedType(iLocation, cPrimitive2, expression2);
    }

    private Expression convertToSmallerSignedType(ILocation iLocation, CPrimitive cPrimitive, Expression expression) {
        CPrimitive cPrimitive2 = this.mTypeSizes.getCorrespondingUnsignedType(cPrimitive);
        Expression expression2 = this.applyWraparound(iLocation, cPrimitive2, expression);
        Expression expression3 = this.constructLiteralForIntegerType(iLocation, cPrimitive, this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive2).add(BigInteger.ONE));
        return ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)this.constructSmallerMaxIntExpression(iLocation, cPrimitive, expression2), (Expression)expression2, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMINUS, (Expression)expression2, (Expression)expression3));
    }

    @Override
    public Expression convertInfinitePrecisionExpression(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        return this.mTypeSizes.isUnsigned(cPrimitive) ? this.applyWraparound(iLocation, cPrimitive, expression) : this.convertToSmallerSignedType(iLocation, cPrimitive, expression);
    }

    @Override
    public CPrimitive getCTypeOfPointerComponents() {
        return new CPrimitive(CPrimitive.CPrimitives.LONG);
    }

    @Override
    public Optional<Expression> getTypeConstraint(ILocation iLocation, Expression expression, ICType iCType) {
        if (!this.mSettings.assumeNondeterministicValuesInRange() || !iCType.getUnderlyingType().isIntegerType()) {
            return Optional.empty();
        }
        CPrimitive cPrimitive = (CPrimitive)CEnum.replaceEnumWithInt(iCType.getUnderlyingType());
        if (this.mTypeSizes.isUnsigned(cPrimitive)) {
            return Optional.empty();
        }
        return Optional.of(this.constructInRangeExpression(this.mTypeSizes, iLocation, expression, cPrimitive));
    }

    private Expression constructInRangeExpression(TypeSizes typeSizes, ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        Expression expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, typeSizes.getMinValueOfPrimitiveType(cPrimitive));
        Expression expression3 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, typeSizes.getMaxValueOfPrimitiveType(cPrimitive));
        Expression expression4 = this.constructBinaryComparisonExpression(iLocation, 10, expression2, cPrimitive, expression, cPrimitive);
        Expression expression5 = this.constructBinaryComparisonExpression(iLocation, 10, expression, cPrimitive, expression3, cPrimitive);
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression4, (Expression)expression5);
    }

    @Override
    public Expression extractBits(ILocation iLocation, Expression expression, int n, int n2) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public Expression concatBits(ILocation iLocation, List<Expression> list, int n) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public Expression signExtend(ILocation iLocation, Expression expression, int n, int n2) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public Expression constructBinaryComparisonFloatingPointExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        if (this.mSettings.overapproximateFloatingPointOperations()) {
            String string = "someBinary" + cPrimitive.toString() + "ComparisonOperation";
            String string2 = "~" + string;
            if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string2)) {
                NamedAttribute namedAttribute = new NamedAttribute(iLocation, "overapproximation", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string)});
                Attribute[] attributeArray = new Attribute[]{namedAttribute};
                ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
                PrimitiveType primitiveType = new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, "bool");
                this.mFunctionDeclarations.declareFunction(iLocation, string2, attributeArray, (ASTType)primitiveType, aSTType, aSTType);
            }
            return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string2, (Expression[])new Expression[]{expression, expression2}, (BoogieType)BoogieType.TYPE_BOOL);
        }
        return IntegerTranslation.constructBinaryComparison(iLocation, n, expression, expression2);
    }

    @Override
    protected Expression constructUnaryFloatingPointExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive) {
        if (this.mSettings.overapproximateFloatingPointOperations()) {
            String string = "someUnary" + cPrimitive.toString() + "operation";
            String string2 = "~" + string;
            if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string2)) {
                NamedAttribute namedAttribute = new NamedAttribute(iLocation, "overapproximation", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string)});
                Attribute[] attributeArray = new Attribute[]{namedAttribute};
                ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
                this.mFunctionDeclarations.declareFunction(iLocation, string2, attributeArray, aSTType, aSTType);
            }
            return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string2, (Expression[])new Expression[]{expression}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
        }
        return IntegerTranslation.constructUnaryMinusExpression(iLocation, expression, cPrimitive);
    }

    @Override
    protected Expression constructArithmeticFloatingPointExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        if (this.mSettings.overapproximateFloatingPointOperations()) {
            String string = "someBinaryArithmetic" + cPrimitive.toString() + "operation";
            String string2 = "~" + string;
            if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string2)) {
                NamedAttribute namedAttribute = new NamedAttribute(iLocation, "overapproximation", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string)});
                Attribute[] attributeArray = new Attribute[]{namedAttribute};
                ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
                this.mFunctionDeclarations.declareFunction(iLocation, string2, attributeArray, aSTType, aSTType, aSTType);
            }
            return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string2, (Expression[])new Expression[]{expression, expression2}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
        }
        return IntegerTranslation.constructArithmeticExpression(iLocation, n, expression, expression2);
    }

    private static Expression constructArithmeticExpression(ILocation iLocation, int n, Expression expression, Expression expression2) {
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)(switch (n) {
            case 5, 22 -> BinaryExpression.Operator.ARITHMINUS;
            case 1, 18 -> BinaryExpression.Operator.ARITHMUL;
            case 2, 19 -> BinaryExpression.Operator.ARITHDIV;
            case 3, 20 -> BinaryExpression.Operator.ARITHMOD;
            case 4, 21 -> BinaryExpression.Operator.ARITHPLUS;
            default -> throw new UnsupportedSyntaxException(iLocation, "Unknown or unsupported arithmetic expression");
        }), (Expression)expression, (Expression)expression2);
    }

    private String declareBinaryFloatComparisonOverApprox(ILocation iLocation, CPrimitive cPrimitive) {
        String string = "someBinary" + cPrimitive.toString() + "ComparisonOperation";
        String string2 = "~" + string;
        if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string2)) {
            NamedAttribute namedAttribute = new NamedAttribute(iLocation, "overapproximation", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string)});
            Attribute[] attributeArray = new Attribute[]{namedAttribute};
            ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
            PrimitiveType primitiveType = new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, "bool");
            this.mFunctionDeclarations.declareFunction(iLocation, string2, attributeArray, (ASTType)primitiveType, aSTType, aSTType);
        }
        return string2;
    }

    @Override
    protected Expression constructBinaryEqualityExpressionFloating(ILocation iLocation, int n, Expression expression, ICType iCType, Expression expression2, ICType iCType2) {
        String string = this.declareBinaryFloatComparisonOverApprox(iLocation, (CPrimitive)iCType);
        if (this.mSettings.overapproximateFloatingPointOperations()) {
            return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{expression, expression2}, (BoogieType)BoogieType.TYPE_BOOL);
        }
        return IntegerTranslation.constructEquality(iLocation, n, expression, expression2);
    }

    @Override
    protected Expression constructBinaryEqualityExpressionInteger(ILocation iLocation, int n, Expression expression, ICType iCType, Expression expression2, ICType iCType2) {
        Expression expression3 = expression;
        Expression expression4 = expression2;
        if (iCType instanceof CPrimitive && iCType2 instanceof CPrimitive) {
            Pair<Expression, Expression> pair = this.applyWraparoundsIfNecessary(iLocation, expression, (CPrimitive)iCType, expression2, (CPrimitive)iCType2);
            expression3 = (Expression)pair.getFirst();
            expression4 = (Expression)pair.getSecond();
        }
        return IntegerTranslation.constructEquality(iLocation, n, expression3, expression4);
    }

    private static Expression constructEquality(ILocation iLocation, int n, Expression expression, Expression expression2) {
        if (n == 28) {
            return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression, (Expression)expression2);
        }
        if (n == 29) {
            return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPNEQ, (Expression)expression, (Expression)expression2);
        }
        throw new IllegalArgumentException("operator is neither equals nor not equals");
    }

    @Override
    public ExpressionResult createNanOrInfinity(ILocation iLocation, String string) {
        throw new UnsupportedOperationException("createNanOrInfinity is unsupported in non-bitprecise translation");
    }

    @Override
    public Expression getCurrentRoundingMode() {
        throw new UnsupportedOperationException("getRoundingMode is unsupported in non-bitprecise translation");
    }

    @Override
    public RValue constructOtherUnaryFloatOperation(ILocation iLocation, FloatFunction floatFunction, RValue rValue) {
        throw new UnsupportedOperationException("floating point operation not supported in non-bitprecise translation: " + floatFunction.getFunctionName());
    }

    @Override
    public RValue constructOtherBinaryFloatOperation(ILocation iLocation, FloatFunction floatFunction, RValue rValue, RValue rValue2) {
        throw new UnsupportedOperationException("floating point operation not supported in non-bitprecise translation: " + floatFunction.getFunctionName());
    }

    @Override
    public ExpressionResult convertFloatToFloat(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        RValue rValue = (RValue)expressionResult.getLrValue();
        RValue rValue2 = new RValue(rValue.getValue(), cPrimitive);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue2).build();
    }

    @Override
    public ExpressionResult convertIntToFloat(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        return this.doFloatIntAndIntFloatConversion(iLocation, expressionResult, cPrimitive);
    }

    @Override
    protected ExpressionResult convertFloatToIntNonBool(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        return this.doFloatIntAndIntFloatConversion(iLocation, expressionResult, cPrimitive);
    }

    private ExpressionResult doFloatIntAndIntFloatConversion(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        String string = this.declareConversionFunction(iLocation, (CPrimitive)expressionResult.getLrValue().getCType().getUnderlyingType(), cPrimitive);
        Expression expression = expressionResult.getLrValue().getValue();
        Expression expression2 = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{expression}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
        RValue rValue = new RValue(expression2, cPrimitive, false, false);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
    }

    private String declareConversionFunction(ILocation iLocation, CPrimitive cPrimitive, CPrimitive cPrimitive2) {
        String string = "convert" + cPrimitive.toString() + "To" + cPrimitive2.toString();
        String string2 = "~" + string;
        if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string2)) {
            Attribute[] attributeArray;
            if (cPrimitive2.isFloatingType()) {
                attributeArray = this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), "to_real", null);
            } else if (cPrimitive2.isIntegerType()) {
                attributeArray = this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), "to_int", null);
            } else {
                throw new AssertionError((Object)"unhandled case");
            }
            ASTType[] aSTTypeArray = new ASTType[]{this.mTypeHandler.cType2AstType(iLocation, cPrimitive)};
            ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive2);
            this.mFunctionDeclarations.declareFunction(iLocation, string2, attributeArray, aSTType, aSTTypeArray);
        }
        return string2;
    }

    @Override
    public Expression transformBitvectorToFloat(ILocation iLocation, Expression expression, CPrimitive.CPrimitives cPrimitives) {
        throw new UnsupportedOperationException("conversion from bitvector to float not supported in non-bitprecise translation");
    }

    @Override
    public Expression transformFloatToBitvector(ILocation iLocation, Expression expression, CPrimitive.CPrimitives cPrimitives) {
        throw new UnsupportedOperationException("conversion from float to bitvector not supported in non-bitprecise translation");
    }

    @Override
    public Expression eraseBits(ILocation iLocation, Expression expression, CPrimitive cPrimitive, int n) {
        return IntegerTranslation.applyEucledeanModulo(iLocation, expression, BigInteger.valueOf(2L).pow(n));
    }

    @Override
    public void declareFloatingPointConstructors(ILocation iLocation, CPrimitive cPrimitive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareFloatConstant(ILocation iLocation, String string, CPrimitive cPrimitive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareBinaryBitvectorFunctionsForAllIntegerDatatypes(ILocation iLocation, BitvectorConstant.BvOp[] bvOpArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RValue constructBuiltinFegetround(ILocation iLocation) {
        throw new UnsupportedOperationException("fegetround not supported in non-bitprecise translation");
    }

    @Override
    public ExpressionResult constructBuiltinFesetround(ILocation iLocation, ExpressionResult expressionResult, AuxVarInfoBuilder auxVarInfoBuilder) {
        throw new UnsupportedOperationException("fesetround not supported in non-bitprecise translation");
    }

    @Override
    public Pair<Expression, Expression> constructOverflowCheckForArithmeticExpression(ILocation iLocation, int n, CPrimitive cPrimitive, Expression expression, Expression expression2) {
        assert (cPrimitive.isIntegerType() && !this.mTypeSizes.isUnsigned(cPrimitive)) : "Overflow check only for signed integer types";
        assert (List.of(Integer.valueOf(1), Integer.valueOf(18), Integer.valueOf(4), Integer.valueOf(21), Integer.valueOf(5), Integer.valueOf(22), Integer.valueOf(2), Integer.valueOf(19)).contains(n));
        Expression expression3 = this.constructArithmeticExpression(iLocation, n, expression, cPrimitive, expression2, cPrimitive);
        return this.constructOverflowCheck(iLocation, cPrimitive, expression3);
    }

    @Override
    public Pair<Expression, Expression> constructOverflowCheckForUnaryExpression(ILocation iLocation, int n, CPrimitive cPrimitive, Expression expression) {
        assert (cPrimitive.isIntegerType() && !this.mTypeSizes.isUnsigned(cPrimitive)) : "Overflow check only for signed integer types";
        assert (n == 3);
        Expression expression2 = this.constructUnaryExpression(iLocation, n, expression, cPrimitive);
        return this.constructOverflowCheck(iLocation, cPrimitive, expression2);
    }

    private Pair<Expression, Expression> constructOverflowCheck(ILocation iLocation, CPrimitive cPrimitive, Expression expression) {
        Expression expression2 = this.constructBiggerMinIntExpression(iLocation, cPrimitive, expression);
        Expression expression3 = this.constructSmallerMaxIntExpression(iLocation, cPrimitive, expression);
        return new Pair((Object)expression2, (Object)expression3);
    }

    private Expression constructSmallerMaxIntExpression(ILocation iLocation, CPrimitive cPrimitive, Expression expression) {
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLEQ, (Expression)expression, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive).toString()));
    }

    private Expression constructBiggerMinIntExpression(ILocation iLocation, CPrimitive cPrimitive, Expression expression) {
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)this.mTypeSizes.getMinValueOfPrimitiveType(cPrimitive).toString()));
    }

    @Override
    public Expression checkInRangeInfinitePrecision(ILocation iLocation, Expression expression, ASTType aSTType, CPrimitive cPrimitive) {
        Expression expression2 = this.constructBiggerMinIntExpression(iLocation, cPrimitive, expression);
        Expression expression3 = this.constructSmallerMaxIntExpression(iLocation, cPrimitive, expression);
        return ExpressionFactory.and((ILocation)iLocation, List.of(expression2, expression3));
    }

    @Override
    protected Pair<Expression, Expression> constructOverflowCheckForLeftShift(ILocation iLocation, CPrimitive cPrimitive, Expression expression, Expression expression2, ExpressionResult expressionResult) {
        return this.constructOverflowCheck(iLocation, cPrimitive, expressionResult.getLrValue().getValue());
    }
}

