/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure;

import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IVisualizable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgGraphProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.util.TgfBuilder;
import java.util.Map;
import java.util.Set;

public interface IIcfg<LOC extends IcfgLocation>
extends IElement,
IVisualizable<VisualizationNode> {
    public Map<String, Map<DebugIdentifier, LOC>> getProgramPoints();

    public Map<String, LOC> getProcedureEntryNodes();

    public Map<String, LOC> getProcedureExitNodes();

    public Map<String, Set<LOC>> getProcedureErrorNodes();

    public Set<LOC> getLocationsOfInterest();

    public Set<LOC> getLoopLocations();

    public CfgSmtToolkit getCfgSmtToolkit();

    public Set<LOC> getInitialNodes();

    public String getIdentifier();

    default public VisualizationNode getVisualizationGraph() {
        return IcfgGraphProvider.getVisualizationGraph(this);
    }

    public Class<LOC> getLocationClass();

    default public String graphStructureToString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Map<DebugIdentifier, LOC>> entry : this.getProgramPoints().entrySet()) {
            for (Map.Entry<DebugIdentifier, LOC> entry2 : entry.getValue().entrySet()) {
                IcfgLocation icfgLocation = (IcfgLocation)entry2.getValue();
                for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                    stringBuilder.append("ProgramPoint: ");
                    stringBuilder.append(icfgLocation.toString());
                    stringBuilder.append(" --->  Edge: ");
                    stringBuilder.append(icfgEdge.getClass().getSimpleName());
                    stringBuilder.append(" ");
                    stringBuilder.append(icfgEdge.toString());
                    stringBuilder.append(" --->  ProgramPoint: ");
                    stringBuilder.append(((IcfgLocation)icfgEdge.getTarget()).toString());
                    stringBuilder.append(System.lineSeparator());
                }
            }
        }
        return stringBuilder.toString();
    }

    default public String graphStructureToTgf() {
        TgfBuilder tgfBuilder = new TgfBuilder();
        for (Map.Entry<String, Map<DebugIdentifier, LOC>> entry : this.getProgramPoints().entrySet()) {
            for (Map.Entry<DebugIdentifier, LOC> entry2 : entry.getValue().entrySet()) {
                IcfgLocation icfgLocation = (IcfgLocation)entry2.getValue();
                tgfBuilder.addDisconnectedNode((Object)icfgLocation);
                for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                    tgfBuilder.addEdge((Object)icfgLocation, (Object)icfgEdge, (Object)((IcfgLocation)icfgEdge.getTarget()));
                }
            }
        }
        return tgfBuilder.toString();
    }
}

