/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.TransferrerWithVariableCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.ICopyActionFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.IRefinableAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.VarAbsConstraints;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitSubSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class SpecificVariableAbstraction<L extends IAction>
implements IRefinableAbstraction<NestedWordAutomaton<L, IPredicate>, VarAbsConstraints<L>, L> {
    private static final boolean ABSTRACT_TF_WITH_BRANCH_ENCODERS = false;
    private final ICopyActionFactory<L> mCopyFactory;
    private final ManagedScript mMgdScript;
    private final TransferrerWithVariableCache mTransferrer;
    private final TransFormulaAuxVarEliminator mEliminator;
    private final BitSubSet.Factory<IProgramVar> mFactory;
    private final ILattice<VarAbsConstraints<L>> mHierarchy;

    public SpecificVariableAbstraction(ICopyActionFactory<L> iCopyActionFactory, ManagedScript managedScript, TransferrerWithVariableCache transferrerWithVariableCache, TransFormulaAuxVarEliminator transFormulaAuxVarEliminator, Set<L> set, Set<IProgramVar> set2) {
        this(iCopyActionFactory, managedScript, transferrerWithVariableCache, transFormulaAuxVarEliminator, set, (BitSubSet.Factory<IProgramVar>)new BitSubSet.Factory(set2));
    }

    SpecificVariableAbstraction(ICopyActionFactory<L> iCopyActionFactory, ManagedScript managedScript, TransferrerWithVariableCache transferrerWithVariableCache, TransFormulaAuxVarEliminator transFormulaAuxVarEliminator, Set<L> set, BitSubSet.Factory<IProgramVar> factory) {
        this.mCopyFactory = iCopyActionFactory;
        this.mMgdScript = managedScript;
        this.mTransferrer = transferrerWithVariableCache;
        this.mEliminator = transFormulaAuxVarEliminator;
        this.mFactory = factory;
        this.mHierarchy = new VarAbsConstraints.Lattice<L>(set, this.mFactory);
    }

    public L abstractLetter(L l, VarAbsConstraints<L> varAbsConstraints) {
        BitSubSet<IProgramVar> bitSubSet = this.inVars(l);
        BitSubSet<IProgramVar> bitSubSet2 = this.outVars(l);
        if (l.getTransformula().isInfeasible() == UnmodifiableTransFormula.Infeasibility.INFEASIBLE || this.nothingWillChange(l, bitSubSet, bitSubSet2, varAbsConstraints)) {
            if (this.mTransferrer == null) {
                return l;
            }
            return this.copy(l, arg_0 -> ((TransferrerWithVariableCache)this.mTransferrer).transferTransFormula(arg_0));
        }
        BitSubSet<IProgramVar> bitSubSet3 = this.getTransformVariablesIn(l, bitSubSet, varAbsConstraints);
        BitSubSet<IProgramVar> bitSubSet4 = this.getTransformVariablesOut(l, bitSubSet2, varAbsConstraints);
        return this.copy(l, unmodifiableTransFormula -> this.abstractTransFormula((UnmodifiableTransFormula)unmodifiableTransFormula, bitSubSet3, bitSubSet4));
    }

    private L copy(L l, UnaryOperator<UnmodifiableTransFormula> unaryOperator) {
        UnmodifiableTransFormula unmodifiableTransFormula = (UnmodifiableTransFormula)unaryOperator.apply(l.getTransformula());
        UnmodifiableTransFormula unmodifiableTransFormula2 = null;
        return this.mCopyFactory.copy(l, unmodifiableTransFormula, unmodifiableTransFormula2);
    }

    private BitSubSet<IProgramVar> getTransformVariablesIn(L l, BitSubSet<IProgramVar> bitSubSet, VarAbsConstraints<L> varAbsConstraints) {
        return this.mFactory.difference(bitSubSet, varAbsConstraints.getInConstraints(l));
    }

    private BitSubSet<IProgramVar> getTransformVariablesOut(L l, BitSubSet<IProgramVar> bitSubSet, VarAbsConstraints<L> varAbsConstraints) {
        return this.mFactory.difference(bitSubSet, varAbsConstraints.getOutConstraints(l));
    }

    private boolean nothingWillChange(L l, BitSubSet<IProgramVar> bitSubSet, BitSubSet<IProgramVar> bitSubSet2, VarAbsConstraints<L> varAbsConstraints) {
        return varAbsConstraints.getInConstraints(l).containsAll(bitSubSet) && varAbsConstraints.getOutConstraints(l).containsAll(bitSubSet2);
    }

    private UnmodifiableTransFormula abstractTransFormula(UnmodifiableTransFormula unmodifiableTransFormula, BitSubSet<IProgramVar> bitSubSet, BitSubSet<IProgramVar> bitSubSet2) {
        TermVariable termVariable;
        TermVariable termVariable2;
        if (this.mTransferrer != null) {
            unmodifiableTransFormula = this.mTransferrer.transferTransFormula(unmodifiableTransFormula);
        }
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (IProgramVar iProgramVar : bitSubSet) {
            if (this.mTransferrer != null) {
                iProgramVar = this.mTransferrer.transferProgramVar(iProgramVar);
            }
            termVariable2 = (TermVariable)unmodifiableTransFormula.getInVars().get(iProgramVar);
            if (!bitSubSet2.contains((Object)iProgramVar) && unmodifiableTransFormula.getOutVars().get(iProgramVar) == termVariable2) continue;
            assert (!hashMap.containsKey(termVariable2)) : "Same TermVariable used for different program variables";
            termVariable = this.mMgdScript.constructFreshCopy(termVariable2);
            hashMap.put(termVariable2, termVariable);
            hashSet.add(termVariable);
        }
        for (IProgramVar iProgramVar : bitSubSet2) {
            if (this.mTransferrer != null) {
                iProgramVar = this.mTransferrer.transferProgramVar(iProgramVar);
            }
            termVariable2 = (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVar);
            if (unmodifiableTransFormula.getInVars().get(iProgramVar) == termVariable2) continue;
            assert (!hashMap.containsKey(termVariable2)) : "Same TermVariable used for different program variables";
            termVariable = this.mMgdScript.constructFreshCopy(termVariable2);
            hashMap.put((TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVar), termVariable);
            hashSet.add(termVariable);
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getAuxVars()) {
            termVariable2 = this.mMgdScript.constructFreshCopy((TermVariable)iProgramVar);
            hashMap.put((TermVariable)iProgramVar, termVariable2);
            hashSet.add(termVariable2);
        }
        return this.buildTransFormula(unmodifiableTransFormula, hashMap, hashSet);
    }

    private UnmodifiableTransFormula buildTransFormula(UnmodifiableTransFormula unmodifiableTransFormula, Map<TermVariable, TermVariable> map, Set<TermVariable> set) {
        TermVariable termVariable2;
        Set set2;
        Term term = Substitution.apply((ManagedScript)this.mMgdScript, map, (Term)unmodifiableTransFormula.getFormula());
        Term term2 = set.isEmpty() || this.mEliminator == null ? term : this.mEliminator.eliminate(this.mMgdScript, term, set);
        Set set3 = unmodifiableTransFormula.getNonTheoryConsts();
        if (!set3.isEmpty()) {
            set2 = SmtUtils.extractConstants((Term)term2, (boolean)true);
            set3 = set3.stream().filter(iProgramConst -> set2.contains(iProgramConst.getDefaultConstant())).collect(Collectors.toSet());
        }
        set2 = unmodifiableTransFormula.getBranchEncoders();
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars(), set3.isEmpty(), set3, set2.isEmpty(), (Collection)set2, set.isEmpty());
        for (TermVariable termVariable2 : set) {
            transFormulaBuilder.addAuxVar(termVariable2);
        }
        transFormulaBuilder.setFormula(term2);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        transFormulaBuilder.ensureInternalNormalForm();
        termVariable2 = transFormulaBuilder.finishConstruction(this.mMgdScript);
        assert (termVariable2.getAssignedVars().equals(unmodifiableTransFormula.getAssignedVars())) : "Abstraction should not change assigned variables";
        assert (unmodifiableTransFormula.getInVars().keySet().containsAll(termVariable2.getInVars().keySet())) : "Abstraction should not read more variables";
        assert (TransFormulaUtils.checkImplication((UnmodifiableTransFormula)unmodifiableTransFormula, (UnmodifiableTransFormula)termVariable2, (ManagedScript)this.mMgdScript) != Script.LBool.SAT) : "not an abstraction";
        return termVariable2;
    }

    @Override
    public VarAbsConstraints<L> refine(VarAbsConstraints<L> varAbsConstraints, IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> iRefinementEngineResult) {
        return (VarAbsConstraints)this.mHierarchy.infimum(varAbsConstraints, this.fromAutomaton((NestedWordAutomaton)iRefinementEngineResult.getInfeasibilityProof()));
    }

    private VarAbsConstraints<L> fromAutomaton(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (IPredicate iPredicate : nestedWordAutomaton.getStates()) {
            for (OutgoingInternalTransition outgoingInternalTransition : nestedWordAutomaton.internalSuccessors((Object)iPredicate)) {
                this.addConstraints(hashMap, (IAction)outgoingInternalTransition.getLetter(), iPredicate.getVars());
                this.addConstraints(hashMap2, (IAction)outgoingInternalTransition.getLetter(), ((IPredicate)outgoingInternalTransition.getSucc()).getVars());
            }
        }
        return new VarAbsConstraints(hashMap, hashMap2, (BitSubSet<IProgramVar>)this.mFactory.empty());
    }

    private void addConstraints(Map<L, BitSubSet<IProgramVar>> map, L l, Set<IProgramVar> set) {
        BitSubSet<IProgramVar> bitSubSet = map.get(l);
        BitSubSet bitSubSet2 = bitSubSet == null ? this.mFactory.valueOf(set) : this.mFactory.union(bitSubSet, this.mFactory.valueOf(set));
        map.put(l, (BitSubSet<IProgramVar>)bitSubSet2);
    }

    private BitSubSet<IProgramVar> inVars(L l) {
        return this.mFactory.valueOf(l.getTransformula().getInVars().keySet());
    }

    private BitSubSet<IProgramVar> outVars(L l) {
        return this.mFactory.valueOf(l.getTransformula().getOutVars().keySet());
    }

    public VarAbsConstraints<L> restrict(L l, VarAbsConstraints<L> varAbsConstraints) {
        if (l.getTransformula().isInfeasible() == UnmodifiableTransFormula.Infeasibility.INFEASIBLE) {
            return (VarAbsConstraints)this.mHierarchy.getBottom();
        }
        BitSubSet bitSubSet = this.mFactory.complement(this.inVars(l));
        BitSubSet bitSubSet2 = this.mFactory.union(varAbsConstraints.getInConstraints(l), bitSubSet);
        BitSubSet bitSubSet3 = this.mFactory.complement(this.outVars(l));
        BitSubSet bitSubSet4 = this.mFactory.union(varAbsConstraints.getOutConstraints(l), bitSubSet3);
        return ((VarAbsConstraints)this.mHierarchy.getBottom()).withModifiedConstraints(l, (BitSubSet<IProgramVar>)bitSubSet2, (BitSubSet<IProgramVar>)bitSubSet4);
    }

    public ILattice<VarAbsConstraints<L>> getHierarchy() {
        return this.mHierarchy;
    }

    public static interface TransFormulaAuxVarEliminator {
        public Term eliminate(ManagedScript var1, Term var2, Set<TermVariable> var3);
    }
}

