/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.errorparsers.Fixit;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class FixitManager
implements IResourceChangeListener {
    private static FixitManager instance;
    private Map<IMarker, Fixit> fixitMap = new HashMap<IMarker, Fixit>();
    private Map<IResource, Set<IMarker>> fixitResourceMap = new HashMap<IResource, Set<IMarker>>();

    private FixitManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static FixitManager getInstance() {
        if (instance == null) {
            instance = new FixitManager();
        }
        return instance;
    }

    public void addMarker(IMarker marker, String range, String value) {
        Fixit f = new Fixit(range, value);
        this.fixitMap.put(marker, f);
        IResource r = marker.getResource();
        Set<IMarker> markerSet = this.fixitResourceMap.get(r);
        if (markerSet == null) {
            markerSet = new HashSet<IMarker>();
            this.fixitResourceMap.put(r, markerSet);
        }
        markerSet.add(marker);
    }

    public void deleteMarker(IMarker marker) {
        this.fixitMap.remove(marker);
        IResource r = marker.getResource();
        Set<IMarker> markerSet = this.fixitResourceMap.get(r);
        if (markerSet != null) {
            markerSet.remove(marker);
            if (markerSet.isEmpty()) {
                this.fixitResourceMap.remove(r);
            }
        }
    }

    public void deleteMarkers(IMarker[] markers) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            this.deleteMarker(marker);
            ++n2;
        }
    }

    public boolean hasFixit(IMarker marker) {
        return this.fixitMap.containsKey(marker);
    }

    public Fixit findFixit(IMarker marker) {
        return this.fixitMap.get(marker);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getType() == 1) {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getKind() == 2) {
                            Set<IMarker> markerSet = FixitManager.this.fixitResourceMap.get(delta.getResource());
                            if (markerSet != null) {
                                for (IMarker marker : markerSet) {
                                    FixitManager.this.deleteMarker(marker);
                                }
                                return false;
                            }
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }
}

