/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayEquality;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ArrayEqualityAllowStores {
    ArrayUpdate mArrayUpdate;
    ArrayEquality mArrayEquality;
    boolean mOtherIsNegated;
    Pair<Term, Term> mOther;

    public ArrayEqualityAllowStores(ArrayUpdate arrayUpdate) {
        this.mArrayUpdate = arrayUpdate;
        this.mArrayEquality = null;
        this.mOtherIsNegated = false;
        this.mOther = null;
    }

    public ArrayEqualityAllowStores(ArrayEquality arrayEquality) {
        this.mArrayUpdate = null;
        this.mArrayEquality = arrayEquality;
        this.mOtherIsNegated = false;
        this.mOther = null;
    }

    public ArrayEqualityAllowStores(Term term, Term term2, boolean bl) {
        this.mArrayUpdate = null;
        this.mArrayEquality = null;
        this.mOtherIsNegated = bl;
        this.mOther = new Pair((Object)term, (Object)term2);
    }

    public Term getTerm(Script script) {
        if (this.mArrayUpdate != null) {
            return this.mArrayUpdate.getArrayUpdateTerm();
        }
        if (this.mArrayEquality != null) {
            return this.mArrayEquality.getOriginalTerm();
        }
        assert (this.mOther != null);
        Term term = SmtUtils.binaryEquality((Script)script, (Term)((Term)this.mOther.getFirst()), (Term)((Term)this.mOther.getSecond()));
        if (this.mOtherIsNegated) {
            term = SmtUtils.not((Script)script, (Term)term);
        }
        return term;
    }

    public static List<ArrayEqualityAllowStores> extractArrayEqualityAllowStores(Term term) {
        Set<String> set = Set.of("=", "distinct", "not");
        ArrayList<ArrayEqualityAllowStores> arrayList = new ArrayList<ArrayEqualityAllowStores>();
        for (ApplicationTerm applicationTerm : SmtUtils.extractApplicationTerms(set, (Term)term, (boolean)false)) {
            Term term2;
            Term term3;
            boolean bl;
            boolean bl2 = bl = applicationTerm.getFunction().getName().equals("not") || applicationTerm.getFunction().getName().equals("distinct");
            if (applicationTerm.getFunction().getName().equals("not")) {
                ApplicationTerm applicationTerm2;
                Term term4 = applicationTerm.getParameters()[0];
                if (!(term4 instanceof ApplicationTerm) || !(applicationTerm2 = (ApplicationTerm)term4).getFunction().getName().equals("=")) continue;
                term3 = applicationTerm2.getParameters()[0];
                term2 = applicationTerm2.getParameters()[1];
                if (!term3.getSort().isArraySort()) {
                    continue;
                }
            } else {
                term3 = applicationTerm.getParameters()[0];
                term2 = applicationTerm.getParameters()[1];
                if (!term3.getSort().isArraySort()) continue;
            }
            try {
                arrayList.add(new ArrayEqualityAllowStores(new ArrayUpdate((Term)applicationTerm, bl, false)));
            }
            catch (ArrayUpdate.ArrayUpdateException arrayUpdateException) {
                try {
                    arrayList.add(new ArrayEqualityAllowStores(new ArrayEquality((Term)applicationTerm, true, true)));
                }
                catch (ArrayEquality.ArrayEqualityException arrayEqualityException) {
                    arrayList.add(new ArrayEqualityAllowStores(term3, term2, bl));
                }
            }
        }
        return arrayList;
    }

    public Term getLhsArray() {
        if (this.mArrayUpdate != null) {
            return this.mArrayUpdate.getNewArray();
        }
        if (this.mArrayEquality != null) {
            return this.mArrayEquality.getLhs();
        }
        if (this.mOther != null) {
            throw new UnsupportedOperationException("implement this, when it occurs..");
        }
        throw new AssertionError();
    }

    public Term getRhsArray() {
        if (this.mArrayUpdate != null) {
            return this.mArrayUpdate.getOldArray();
        }
        if (this.mArrayEquality != null) {
            return this.mArrayEquality.getRhs();
        }
        if (this.mOther != null) {
            throw new UnsupportedOperationException("implement this, when it occurs..");
        }
        throw new AssertionError();
    }
}

