/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.BooleanVarAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.BitVectorInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.BoolSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.DataTypeInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FiniteSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FunctionValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ModelEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ModelFormatter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.NumericSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Model
implements de.uni_freiburg.informatik.ultimate.logic.Model {
    private final HashMap<Sort, SortInterpretation> mSorts = new HashMap();
    private final HashMap<FunctionSymbol, FunctionValue> mFuncVals = new HashMap();
    private final Theory mTheory;
    private final ModelEvaluator mEval;
    private int mModelValueCounter;

    /*
     * WARNING - void declaration
     */
    public Model(Clausifier clausifier, Theory theory) {
        void var5_8;
        Object object;
        Object object2;
        Object object3;
        Object object5;
        this.mTheory = theory;
        this.mSorts.put(theory.getBooleanSort(), new BoolSortInterpretation());
        if (theory.getLogic().hasIntegers() || theory.getLogic().hasReals() || theory.getLogic().isBitVector()) {
            object5 = new NumericSortInterpretation();
            if (theory.getLogic().hasIntegers() || theory.getLogic().isBitVector()) {
                this.mSorts.put(theory.getNumericSort(), (SortInterpretation)object5);
            }
            if (theory.getLogic().hasReals()) {
                this.mSorts.put(theory.getRealSort(), (SortInterpretation)object5);
            }
        }
        object5 = new FunctionValue((Term)theory.mTrue);
        FunctionValue functionValue = new FunctionValue((Term)theory.mFalse);
        for (BooleanVarAtom object42 : clausifier.getBooleanVars()) {
            object3 = (ApplicationTerm)object42.getSMTFormula(theory);
            object2 = object42.getDecideStatus() == null ? (object42.getPreferredStatus() == object42 ? object5 : functionValue) : (object42.getDecideStatus() == object42 ? object5 : functionValue);
            this.mFuncVals.put(object3.getFunction(), (FunctionValue)object2);
        }
        Object var5_7 = null;
        Object object6 = null;
        object3 = null;
        object2 = null;
        ITheory[] iTheoryArray = clausifier.getEngine().getAttachedTheories();
        int n = iTheoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iTheoryArray[n2];
            if (object instanceof CClosure) {
                CClosure cClosure = (CClosure)object;
            } else if (object instanceof LinArSolve) {
                object6 = (LinArSolve)object;
            } else if (object instanceof ArrayTheory) {
                object3 = (ArrayTheory)object;
            } else if (object instanceof DataTypeTheory) {
                object2 = (DataTypeTheory)object;
            } else if (object instanceof QuantifierTheory) {
                if (!((QuantifierTheory)object).getQuantClauses().isEmpty()) {
                    throw new UnsupportedOperationException("Modelproduction for quantifier theory not implemented.");
                }
            } else {
                if (object instanceof EprTheory) {
                    throw new UnsupportedOperationException("Modelproduction for EPR theory not implemented.");
                }
                throw new InternalError("Unknown theory: " + String.valueOf(object));
            }
            ++n2;
        }
        object = new SharedTermEvaluator(clausifier);
        if (object6 != null) {
            ((LinArSolve)object6).fillInModel(this, theory, (SharedTermEvaluator)object);
        }
        if (var5_8 != null) {
            var5_8.fillInModel(this, theory, (SharedTermEvaluator)object, (ArrayTheory)object3, (DataTypeTheory)object2);
        }
        for (FunctionSymbol functionSymbol : theory.getDeclaredFunctions().values()) {
            if (functionSymbol.getDefinition() != null || functionSymbol.isIntern() || this.mFuncVals.containsKey(functionSymbol)) continue;
            this.map(functionSymbol, this.getSomeValue(functionSymbol.getReturnSort()));
        }
        this.mEval = new ModelEvaluator(this);
        this.mModelValueCounter = 0;
    }

    public boolean checkTypeValues(LogProxy logProxy) {
        boolean bl = true;
        for (Map.Entry<FunctionSymbol, FunctionValue> entry : this.mFuncVals.entrySet()) {
            FunctionSymbol functionSymbol = entry.getKey();
            FunctionValue functionValue = entry.getValue();
            if (!functionSymbol.getReturnSort().getName().equals("Int")) continue;
            if (!NumericSortInterpretation.toRational(functionValue.getDefault()).isIntegral()) {
                if (functionSymbol.getParameterSorts().length == 0) {
                    logProxy.fatal("Non-integral value for integer variable " + String.valueOf(functionSymbol));
                } else {
                    logProxy.fatal("Non-integral default value for function " + String.valueOf(functionSymbol));
                }
                bl = false;
            }
            for (Map.Entry<FunctionValue.Index, Term> entry2 : functionValue.values().entrySet()) {
                if (NumericSortInterpretation.toRational(entry2.getValue()).isIntegral()) continue;
                logProxy.fatal("Non-integral value for function " + String.valueOf(functionSymbol) + " at index " + String.valueOf(entry2.getKey()));
                bl = false;
            }
        }
        return bl;
    }

    public int getFreshModelValue() {
        return this.mModelValueCounter++;
    }

    public Term getModelValue(int n, Sort sort) {
        return this.provideSortInterpretation(sort).getModelValue(n, sort);
    }

    public Term getSomeValue(Sort sort) {
        return this.getModelValue(0, sort);
    }

    public Term getSecondValue(Sort sort) {
        return this.getModelValue(1, sort);
    }

    public Term extendFresh(Sort sort) {
        return this.provideSortInterpretation(sort).extendFresh(sort);
    }

    public Set<FunctionSymbol> getDefinedFunctions() {
        return Collections.unmodifiableSet(this.mFuncVals.keySet());
    }

    Term generateCondition(FunctionValue.Index index, TermVariable[] termVariableArray) {
        Term[] termArray = index.toArray();
        assert (termVariableArray.length == termArray.length);
        Term[] termArray2 = new Term[termVariableArray.length];
        int n = 0;
        while (n < termVariableArray.length) {
            termArray2[n] = this.mTheory.equals(new Term[]{termVariableArray[n], termArray[n]});
            ++n;
        }
        return this.mTheory.and(termArray2);
    }

    private static boolean isDivision(FunctionSymbol functionSymbol) {
        String string = functionSymbol.getName();
        return functionSymbol.isIntern() && (string == "/" || string == "div" || string == "mod");
    }

    public Term getFunctionDefinition(FunctionSymbol functionSymbol, TermVariable[] termVariableArray) {
        Term term;
        Term term2;
        FunctionValue functionValue = this.mFuncVals.get(functionSymbol);
        if (functionValue == null) {
            throw new IllegalArgumentException("No model for " + String.valueOf(functionSymbol));
        }
        if (functionSymbol.getParameterSorts().length != termVariableArray.length) {
            throw new IllegalArgumentException("Wrong number of variables");
        }
        Term term3 = term2 = functionValue.getDefault();
        for (Map.Entry<FunctionValue.Index, Term> sort2 : functionValue.values().entrySet()) {
            if (sort2.getValue() == term2) continue;
            term = this.generateCondition(sort2.getKey(), termVariableArray);
            term3 = this.mTheory.ifthenelse(term, sort2.getValue(), term3);
        }
        if (functionSymbol.isSelector()) {
            DataType.Constructor constructor;
            assert (termVariableArray.length == 1);
            Sort sort = functionSymbol.getParameterSorts()[0];
            DataType dataType = (DataType)sort.getSortSymbol();
            term = null;
            DataType.Constructor[] constructorArray = dataType.getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                constructor = constructorArray[n2];
                if (Arrays.asList(constructor.getSelectors()).contains(functionSymbol.getName())) {
                    term = constructor;
                }
                ++n2;
            }
            constructor = this.mTheory.term("is", new String[]{term.getName()}, null, new Term[]{termVariableArray[0]});
            term3 = this.mTheory.ifthenelse((Term)constructor, this.mTheory.term(functionSymbol, new Term[]{termVariableArray[0]}), term3);
        }
        if (Model.isDivision(functionSymbol)) {
            Term term4 = this.mTheory.term("=", new Term[]{termVariableArray[1], Rational.ZERO.toTerm(termVariableArray[1].getSort())});
            term3 = this.mTheory.ifthenelse(this.mTheory.term("not", new Term[]{term4}), this.mTheory.term(functionSymbol, new Term[]{termVariableArray[0], termVariableArray[1]}), term3);
        }
        return term3;
    }

    public Term getFunctionDefinition(String string, TermVariable[] termVariableArray) {
        Sort[] sortArray = new Sort[termVariableArray.length];
        int n = 0;
        while (n < termVariableArray.length) {
            sortArray[n] = termVariableArray[n].getSort();
            ++n;
        }
        FunctionSymbol functionSymbol = this.mTheory.getFunction(string, sortArray);
        if (functionSymbol == null) {
            throw new IllegalArgumentException("Function " + string + " not defined.");
        }
        return this.getFunctionDefinition(functionSymbol, termVariableArray);
    }

    public FunctionValue map(FunctionSymbol functionSymbol, Term term) {
        FunctionValue functionValue = this.mFuncVals.get(functionSymbol);
        if (functionValue == null) {
            functionValue = new FunctionValue(term);
            this.mFuncVals.put(functionSymbol, functionValue);
        }
        assert (functionValue.getDefault() == term);
        return functionValue;
    }

    public FunctionValue map(FunctionSymbol functionSymbol, Term[] termArray, Term term) {
        assert (functionSymbol.getParameterSorts().length == termArray.length);
        FunctionValue functionValue = this.mFuncVals.get(functionSymbol);
        if (functionValue == null) {
            functionValue = new FunctionValue(term);
            this.mFuncVals.put(functionSymbol, functionValue);
        }
        functionValue.put(term, termArray);
        return functionValue;
    }

    Term getUndefined(Sort sort) {
        FunctionSymbol functionSymbol = this.mTheory.getFunctionWithResult("@undefined", null, sort, new Sort[0]);
        return this.mTheory.term(functionSymbol, new Term[0]);
    }

    public Term evaluate(Term term) {
        return this.mEval.evaluate(term);
    }

    public Map<Term, Term> evaluate(Term[] termArray) {
        LinkedHashMap<Term, Term> linkedHashMap = new LinkedHashMap<Term, Term>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            linkedHashMap.put(term, this.evaluate(term));
            ++n2;
        }
        return linkedHashMap;
    }

    public String toString() {
        ModelFormatter modelFormatter = new ModelFormatter(this.mTheory);
        for (Map.Entry<FunctionSymbol, FunctionValue> entry : this.mFuncVals.entrySet()) {
            FunctionSymbol functionSymbol = entry.getKey();
            if (functionSymbol.isIntern() && functionSymbol.getDefinition() != null) continue;
            Sort[] sortArray = functionSymbol.getParameterSorts();
            TermVariable[] termVariableArray = new TermVariable[sortArray.length];
            int n = 0;
            while (n < termVariableArray.length) {
                termVariableArray[n] = this.mTheory.createTermVariable("@p" + n, sortArray[n]);
                ++n;
            }
            modelFormatter.appendValue(functionSymbol, termVariableArray, this.getFunctionDefinition(functionSymbol, termVariableArray));
        }
        return modelFormatter.finish();
    }

    Theory getTheory() {
        return this.mTheory;
    }

    public SortInterpretation provideSortInterpretation(Sort sort) {
        SortInterpretation sortInterpretation = this.mSorts.get(sort);
        if (sortInterpretation == null) {
            sortInterpretation = sort.isArraySort() ? new ArraySortInterpretation(this, this.provideSortInterpretation(sort.getArguments()[0]), this.provideSortInterpretation(sort.getArguments()[1])) : (sort.getSortSymbol().isDatatype() ? new DataTypeInterpretation(this, sort) : (sort.isBitVecSort() ? new BitVectorInterpretation() : new FiniteSortInterpretation(this)));
            this.mSorts.put(sort, sortInterpretation);
        }
        return sortInterpretation;
    }

    public FunctionValue getFunctionValue(FunctionSymbol functionSymbol) {
        return this.mFuncVals.get(functionSymbol);
    }
}

