/*
 * Decompiled with CFR 0.152.
 */
package ap.terfor.conjunctions;

import ap.terfor.ComputationLogger;
import ap.terfor.ComputationLogger$;
import ap.terfor.ConstantTerm;
import ap.terfor.Formula;
import ap.terfor.Term;
import ap.terfor.TermOrder;
import ap.terfor.TermOrder$;
import ap.terfor.VariableTerm;
import ap.terfor.arithconj.ArithConj;
import ap.terfor.arithconj.ArithConj$;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.conjunctions.NegatedConjunctions;
import ap.terfor.conjunctions.NegatedConjunctions$;
import ap.terfor.conjunctions.Quantifier;
import ap.terfor.conjunctions.Quantifier$ALL$;
import ap.terfor.conjunctions.Quantifier$EX$;
import ap.terfor.equations.EquationConj;
import ap.terfor.equations.NegEquationConj;
import ap.terfor.inequalities.InEqConj;
import ap.terfor.preds.Atom;
import ap.terfor.preds.PredConj;
import ap.terfor.preds.PredConj$;
import ap.terfor.substitutions.ConstantSubst$;
import ap.terfor.substitutions.IdentitySubst;
import ap.terfor.substitutions.Substitution;
import ap.terfor.substitutions.VariableShiftSubst;
import ap.terfor.substitutions.VariableShiftSubst$;
import ap.util.Debug$;
import ap.util.Debug$AC_PROP_CONNECTIVES$;
import ap.util.PlainRange$;
import ap.util.Seqs$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class Conjunction$ {
    public static Conjunction$ MODULE$;
    private final Debug$AC_PROP_CONNECTIVES$ ap$terfor$conjunctions$Conjunction$$AC;
    private final Ordering<Quantifier> quanOrdering;
    private final Conjunction TRUE;
    private final Conjunction FALSE;

    static {
        new Conjunction$();
    }

    public Debug$AC_PROP_CONNECTIVES$ ap$terfor$conjunctions$Conjunction$$AC() {
        return this.ap$terfor$conjunctions$Conjunction$$AC;
    }

    public Conjunction apply(Seq<Quantifier> quans, Iterator<Formula> formulas, ComputationLogger logger, TermOrder order) {
        Tuple3<ArithConj, PredConj, NegatedConjunctions> tuple3 = this.segregateFormulas(formulas, logger, order);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ArithConj arithConj = (ArithConj)tuple3._1();
        PredConj predConj = (PredConj)tuple3._2();
        NegatedConjunctions negatedConjs = (NegatedConjunctions)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)arithConj, (Object)predConj, (Object)negatedConjs);
        ArithConj arithConj2 = (ArithConj)tuple32._1();
        PredConj predConj2 = (PredConj)tuple32._2();
        NegatedConjunctions negatedConjs2 = (NegatedConjunctions)tuple32._3();
        Debug$.MODULE$.assertInt(this.ap$terfor$conjunctions$Conjunction$$AC(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !negatedConjs2.containsLiteral() && !negatedConjs2.containsNegatedConjunction());
        return this.createHelp(quans, arithConj2, predConj2, negatedConjs2, order);
    }

    public Conjunction apply(Seq<Quantifier> quans, Iterator<Formula> formulas, TermOrder order) {
        return this.apply(quans, formulas, ComputationLogger$.MODULE$.NonLogger(), order);
    }

    private Tuple3<ArithConj, PredConj, NegatedConjunctions> segregateFormulas(Iterator<Formula> formulas, ComputationLogger logger, TermOrder order) {
        ArrayBuffer arithFors = new ArrayBuffer();
        ArrayBuffer predConjs = new ArrayBuffer();
        ArrayBuffer negConjs = new ArrayBuffer();
        while (formulas.hasNext()) {
            Formula f = (Formula)formulas.next();
            if (f.isFalse()) {
                return new Tuple3((Object)ArithConj$.MODULE$.FALSE(), (Object)PredConj$.MODULE$.TRUE(), (Object)NegatedConjunctions$.MODULE$.TRUE());
            }
            Conjunction$.addFormula$1(f, arithFors, predConjs, order, negConjs);
        }
        return new Tuple3((Object)ArithConj$.MODULE$.conj((Iterator<Formula>)arithFors.iterator(), logger, order), (Object)PredConj$.MODULE$.conj((Iterator<PredConj>)predConjs.iterator(), logger, order), (Object)NegatedConjunctions$.MODULE$.apply((Iterable<Conjunction>)negConjs, order));
    }

    public Conjunction apply(Seq<Quantifier> quans, Iterable<Formula> formulas, TermOrder order) {
        return this.apply(quans, (Iterator<Formula>)formulas.iterator(), order);
    }

    public Conjunction conj(Iterator<Formula> formulas, TermOrder order) {
        return this.apply((Seq<Quantifier>)Nil$.MODULE$, formulas, order);
    }

    public Conjunction conj(Iterable<Formula> formulas, TermOrder order) {
        return this.apply((Seq<Quantifier>)Nil$.MODULE$, (Iterator<Formula>)formulas.iterator(), order);
    }

    public Conjunction conj(Formula f, TermOrder order) {
        return this.apply((Seq<Quantifier>)Nil$.MODULE$, (Iterator<Formula>)package$.MODULE$.Iterator().single((Object)f), order);
    }

    public Conjunction disjFor(Iterator<Formula> formulas, TermOrder order) {
        return this.conj((Iterator<Formula>)formulas.map((Function1 & Serializable & scala.Serializable)f -> MODULE$.conj((Formula)f, order).negate()), order).negate();
    }

    public Conjunction disj(Iterator<Conjunction> formulas, TermOrder order) {
        return this.conj((Iterator<Formula>)formulas.map((Function1 & Serializable & scala.Serializable)f -> f.negate()), order).negate();
    }

    public Conjunction disjFor(Iterable<Formula> formulas, TermOrder order) {
        return this.disjFor((Iterator<Formula>)formulas.iterator(), order);
    }

    public Conjunction disj(Iterable<Conjunction> formulas, TermOrder order) {
        return this.disj((Iterator<Conjunction>)formulas.iterator(), order);
    }

    public Conjunction implies(Formula for1, Formula for2, TermOrder order) {
        return this.disj((Iterable<Conjunction>)Predef$.MODULE$.wrapRefArray((Object[])new Conjunction[]{this.negate(for1, order), this.conj(for2, order)}), order);
    }

    public Conjunction eqv(Formula for1, Formula for2, TermOrder order) {
        return this.conj((Iterable<Formula>)Predef$.MODULE$.wrapRefArray((Object[])new Conjunction[]{this.implies(for1, for2, order), this.implies(for2, for1, order)}), order);
    }

    public Conjunction quantify(Seq<Quantifier> quans, Formula f, TermOrder order) {
        return this.apply(quans, (Iterator<Formula>)package$.MODULE$.Iterator().single((Object)f), order);
    }

    public Conjunction quantify(Quantifier quan, Seq<ConstantTerm> constants, Formula f, TermOrder order) {
        Formula shiftedF = f.variables().isEmpty() ? f : VariableShiftSubst$.MODULE$.apply(0, constants.size(), order).apply(f);
        Substitution constantSubst = ConstantSubst$.MODULE$.apply((Map<ConstantTerm, Term>)((MapLike)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)constants.iterator().zipWithIndex().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Conjunction$.$anonfun$quantify$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                ConstantTerm c = (ConstantTerm)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c), (Object)new VariableTerm(i));
            }
            throw new MatchError((Object)tuple2);
        })), order);
        Seq quans = (Seq)PlainRange$.MODULE$.apply(constants.size()).map((Function1 & Serializable & scala.Serializable)_ -> quan, Seq$.MODULE$.canBuildFrom());
        return this.quantify((Seq<Quantifier>)quans, constantSubst.apply(shiftedF), order);
    }

    public Conjunction negate(Formula f, TermOrder order) {
        return this.apply((Seq<Quantifier>)Nil$.MODULE$, (Iterator<Formula>)package$.MODULE$.Iterator().single((Object)f), order).negate();
    }

    public Conjunction apply(Seq<Quantifier> quans, ArithConj arithConj, PredConj predConj, NegatedConjunctions negatedConjs, TermOrder order) {
        if (arithConj.isFalse() || predConj.isFalse()) {
            return this.FALSE();
        }
        if (negatedConjs.containsLiteral() || negatedConjs.containsNegatedConjunction()) {
            return this.apply(quans, (Iterable<Formula>)Predef$.MODULE$.wrapRefArray((Object[])new Formula[]{arithConj, predConj, negatedConjs}), order);
        }
        return this.createHelp(quans, arithConj, predConj, negatedConjs, order);
    }

    private Conjunction createHelp(Seq<Quantifier> quans, ArithConj arithConj, PredConj predConj, NegatedConjunctions negatedConjs, TermOrder order) {
        if (arithConj.isTrue() && predConj.isTrue() && negatedConjs.isNegatedQuantifiedConjunction()) {
            Conjunction negC = negatedConjs.apply(0);
            return this.apply((Seq<Quantifier>)((Seq)((TraversableLike)negC.quans().map((Function1 & Serializable & scala.Serializable)q -> q.dual(), Seq$.MODULE$.canBuildFrom())).$plus$plus(quans, Seq$.MODULE$.canBuildFrom())), ArithConj$.MODULE$.TRUE(), PredConj$.MODULE$.TRUE(), NegatedConjunctions$.MODULE$.apply(this.createFromNormalised((Seq<Quantifier>)Nil$.MODULE$, negC.arithConj(), negC.predConj(), negC.negatedConjs(), order), order), order);
        }
        return this.createFromNormalised(quans, arithConj, predConj, negatedConjs, order);
    }

    public Conjunction createFromNormalised(Seq<Quantifier> quans, ArithConj arithConj, PredConj predConj, NegatedConjunctions negatedConjs, TermOrder order) {
        if (arithConj.isFalse() || predConj.isFalse() || negatedConjs.isFalse()) {
            return this.FALSE();
        }
        if (arithConj.isTrue() && predConj.isTrue() && negatedConjs.isTrue()) {
            return this.TRUE();
        }
        if (quans.isEmpty()) {
            return new Conjunction((Seq<Quantifier>)Nil$.MODULE$, arithConj, predConj, negatedConjs, order);
        }
        HashSet occurringVars = new HashSet();
        occurringVars.$plus$plus$eq(arithConj.variables());
        occurringVars.$plus$plus$eq(predConj.variables());
        occurringVars.$plus$plus$eq(negatedConjs.variables());
        Tuple2<Seq<Quantifier>, Substitution> tuple2 = this.eliminateUnusedQuans((Set<VariableTerm>)occurringVars, quans, order);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq resultingQuans = (Seq)tuple2._1();
        Substitution resultingSubst = (Substitution)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)resultingQuans, (Object)resultingSubst);
        Seq resultingQuans2 = (Seq)tuple22._1();
        Substitution resultingSubst2 = (Substitution)tuple22._2();
        return new Conjunction((Seq<Quantifier>)resultingQuans2, resultingSubst2.apply(arithConj), resultingSubst2.apply(predConj), resultingSubst2.apply(negatedConjs), order);
    }

    private Tuple2<Seq<Quantifier>, Substitution> eliminateUnusedQuans(Set<VariableTerm> occurringVars, Seq<Quantifier> quans, TermOrder order) {
        if (RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), quans.size()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> occurringVars.contains((Object)new VariableTerm(x$4)))) {
            return new Tuple2(quans, (Object)new IdentitySubst(order));
        }
        ArrayBuffer resultingQuans = new ArrayBuffer();
        int[] variableShifts = new int[quans.size()];
        IntRef usedVars = IntRef.create((int)0);
        quans.iterator().zipWithIndex().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Conjunction$.$anonfun$eliminateUnusedQuans$2(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 != null) {
                Quantifier q = (Quantifier)tuple2._1();
                int i = tuple2._2$mcI$sp();
                variableShifts$1[i] = usedVars$1.elem - i;
                if (occurringVars.contains((Object)new VariableTerm(i))) {
                    ++usedVars$1.elem;
                    return resultingQuans.$plus$eq((Object)q);
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        VariableShiftSubst resultingSubst = VariableShiftSubst$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(variableShifts), usedVars.elem - quans.size(), order);
        return new Tuple2((Object)resultingQuans, (Object)resultingSubst);
    }

    public scala.collection.immutable.Set<Quantifier> collectQuantifiers(Formula f, Function1<Conjunction, scala.collection.immutable.Set<Quantifier>> divCollector) {
        scala.collection.immutable.Set set;
        block7: {
            Object object;
            block6: {
                Formula formula;
                block5: {
                    object = new Object();
                    formula = f;
                    if (!(formula instanceof Conjunction)) break block5;
                    Conjunction conjunction = (Conjunction)formula;
                    set = conjunction.isQuantifiedDivisibility() || conjunction.isQuantifiedNonDivisibility() ? (scala.collection.immutable.Set)divCollector.apply((Object)conjunction) : (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus(conjunction.quans()).$plus$plus(this.collectQuantifiers(conjunction.negatedConjs(), divCollector));
                }
                if (!(formula instanceof NegatedConjunctions)) break block6;
                NegatedConjunctions negatedConjunctions = (NegatedConjunctions)formula;
                ObjectRef res = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
                negatedConjunctions.foreach((Function1 & Serializable & scala.Serializable)conj -> {
                    Conjunction$.$anonfun$collectQuantifiers$1(res, divCollector, object, conj);
                    return BoxedUnit.UNIT;
                });
                set = (scala.collection.immutable.Set)res.elem;
            }
            try {
                set = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    set = (scala.collection.immutable.Set)ex.value();
                    break block7;
                }
                throw ex;
            }
        }
        return set;
    }

    public scala.collection.immutable.Set<Quantifier> collectQuantifiers(Formula f) {
        return this.collectQuantifiers(f, (Function1<Conjunction, scala.collection.immutable.Set<Quantifier>>)(Function1 & Serializable & scala.Serializable)conj -> (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)conj.quans().drop(1)));
    }

    public int compare(Conjunction c1, Conjunction c2, TermOrder order) {
        return Seqs$.MODULE$.lexCombineInts(this.compare(c1.quans(), c2.quans()), (Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> order.compare(c1.arithConj(), c2.arithConj()), (Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.compare(c1.predConj(), c2.predConj(), order), (Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.compare(c1.negatedConjs(), c2.negatedConjs(), order));
    }

    public Ordering<Conjunction> conjOrdering(TermOrder order) {
        return new Ordering<Conjunction>(order){
            private final TermOrder order$4;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Conjunction> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Conjunction> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(Conjunction c1, Conjunction c2) {
                return Conjunction$.MODULE$.compare(c1, c2, this.order$4);
            }
            {
                this.order$4 = order$4;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }

    public Ordering<Conjunction> reverseConjOrdering(TermOrder order) {
        return new Ordering<Conjunction>(order){
            private final TermOrder order$5;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Conjunction> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Conjunction> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(Conjunction c1, Conjunction c2) {
                return Conjunction$.MODULE$.compare(c2, c1, this.order$5);
            }
            {
                this.order$5 = order$5;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }

    private Ordering<Quantifier> quanOrdering() {
        return this.quanOrdering;
    }

    private int compare(Seq<Quantifier> quans1, Seq<Quantifier> quans2) {
        return Seqs$.MODULE$.lexCompare(quans1.iterator(), quans2.iterator(), this.quanOrdering());
    }

    private int compare(PredConj c1, PredConj c2, TermOrder order) {
        Ordering<Atom> ord = order.atomOrdering();
        return Seqs$.MODULE$.lexCombineInts(Seqs$.MODULE$.lexCompare(c1.positiveLits().iterator(), c2.positiveLits().iterator(), ord), (Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Seqs$.MODULE$.lexCompare(c1.negativeLits().iterator(), c2.negativeLits().iterator(), ord));
    }

    private int compare(NegatedConjunctions c1, NegatedConjunctions c2, TermOrder order) {
        Ordering<Conjunction> co = this.conjOrdering(order);
        return Seqs$.MODULE$.lexCompare(c1.iterator(), c2.iterator(), co);
    }

    public Conjunction TRUE() {
        return this.TRUE;
    }

    public Conjunction FALSE() {
        return this.FALSE;
    }

    private static final void addNegatedConjunctions$1(NegatedConjunctions negCs, ArrayBuffer arithFors$1, ArrayBuffer predConjs$1, ArrayBuffer negConjs$1, TermOrder order$1) {
        negCs.foreach((Function1 & Serializable & scala.Serializable)negC -> {
            if (negC.isLiteral()) {
                ArithConj negAC = negC.arithConj();
                PredConj negPC = negC.predConj();
                Debug$.MODULE$.assertInt(MODULE$.ap$terfor$conjunctions$Conjunction$$AC(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> negAC.isLiteral() != negPC.isLiteral() && negC.negatedConjs().isEmpty());
                if (negAC.isLiteral()) {
                    return arithFors$1.$plus$eq((Object)negAC.negate());
                }
                return predConjs$1.$plus$eq((Object)negPC.negate());
            }
            if (negC.isNegatedConjunction()) {
                Conjunction$.addFormula$1(negC.negatedConjs().apply(0), arithFors$1, predConjs$1, order$1, negConjs$1);
                return BoxedUnit.UNIT;
            }
            return negConjs$1.$plus$eq(negC);
        });
    }

    private static final void addFormula$1(Formula f, ArrayBuffer arithFors$1, ArrayBuffer predConjs$1, TermOrder order$1, ArrayBuffer negConjs$1) {
        if (!f.isTrue()) {
            Formula formula = f;
            if (formula instanceof EquationConj ? true : (formula instanceof NegEquationConj ? true : (formula instanceof InEqConj ? true : formula instanceof ArithConj))) {
                arithFors$1.$plus$eq((Object)f);
                return;
            }
            if (formula instanceof PredConj) {
                PredConj predConj = (PredConj)formula;
                predConjs$1.$plus$eq((Object)predConj);
                return;
            }
            if (formula instanceof Atom) {
                Atom atom = (Atom)formula;
                predConjs$1.$plus$eq((Object)PredConj$.MODULE$.apply((Iterable<Atom>)new .colon.colon((Object)atom, (List)Nil$.MODULE$), (Iterable<Atom>)Nil$.MODULE$, order$1));
                return;
            }
            if (formula instanceof Conjunction) {
                Conjunction conjunction = (Conjunction)formula;
                if (conjunction.quans().isEmpty()) {
                    arithFors$1.$plus$eq((Object)conjunction.arithConj());
                    predConjs$1.$plus$eq((Object)conjunction.predConj());
                    Conjunction$.addNegatedConjunctions$1(conjunction.negatedConjs(), arithFors$1, predConjs$1, negConjs$1, order$1);
                    return;
                }
                Conjunction$.addNegatedConjunctions$1(NegatedConjunctions$.MODULE$.apply(conjunction.negate(), order$1), arithFors$1, predConjs$1, negConjs$1, order$1);
                return;
            }
            if (formula instanceof NegatedConjunctions) {
                NegatedConjunctions negatedConjunctions = (NegatedConjunctions)formula;
                Conjunction$.addNegatedConjunctions$1(negatedConjunctions, arithFors$1, predConjs$1, negConjs$1, order$1);
                return;
            }
            throw new MatchError((Object)formula);
        }
    }

    public static final /* synthetic */ boolean $anonfun$quantify$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$eliminateUnusedQuans$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$collectQuantifiers$1(ObjectRef res$1, Function1 divCollector$1, Object nonLocalReturnKey1$1, Conjunction conj) {
        res$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)res$1.elem).$plus$plus((GenTraversableOnce)MODULE$.collectQuantifiers(conj, (Function1<Conjunction, scala.collection.immutable.Set<Quantifier>>)divCollector$1).map((Function1 & Serializable & scala.Serializable)q -> q.dual(), Set$.MODULE$.canBuildFrom()));
        if (((scala.collection.immutable.Set)res$1.elem).size() == 2) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)((scala.collection.immutable.Set)res$1.elem));
        }
    }

    private Conjunction$() {
        MODULE$ = this;
        this.ap$terfor$conjunctions$Conjunction$$AC = Debug$AC_PROP_CONNECTIVES$.MODULE$;
        this.quanOrdering = new Ordering<Quantifier>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Quantifier> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Quantifier> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(Quantifier a, Quantifier b) {
                Tuple2 tuple2 = new Tuple2((Object)a, (Object)b);
                if (tuple2 != null) {
                    Quantifier quantifier = (Quantifier)tuple2._1();
                    Quantifier quantifier2 = (Quantifier)tuple2._2();
                    if (Quantifier$ALL$.MODULE$.equals(quantifier) && Quantifier$EX$.MODULE$.equals(quantifier2)) {
                        return -1;
                    }
                }
                if (tuple2 != null) {
                    Quantifier quantifier = (Quantifier)tuple2._1();
                    Quantifier quantifier3 = (Quantifier)tuple2._2();
                    if (Quantifier$EX$.MODULE$.equals(quantifier) && Quantifier$ALL$.MODULE$.equals(quantifier3)) {
                        return 1;
                    }
                }
                return 0;
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
        this.TRUE = new Conjunction((Seq<Quantifier>)Nil$.MODULE$, ArithConj$.MODULE$.TRUE(), PredConj$.MODULE$.TRUE(), NegatedConjunctions$.MODULE$.TRUE(), TermOrder$.MODULE$.EMPTY());
        this.FALSE = new Conjunction((Seq<Quantifier>)Nil$.MODULE$, ArithConj$.MODULE$.FALSE(), PredConj$.MODULE$.TRUE(), NegatedConjunctions$.MODULE$.TRUE(), TermOrder$.MODULE$.EMPTY());
    }
}

