/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryNumericRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.IBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.ExplicitLhsPolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermOperations;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SolveForSubjectUtils;
import de.uni_freiburg.informatik.ultimate.logic.INonSolverScript;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class PolynomialRelation
implements IBinaryRelation,
ITermProvider {
    protected static final String NO_AFFINE_REPRESENTATION_WHERE_DESIRED_VARIABLE_IS_ON_LEFT_HAND_SIDE = "No affine representation where desired variable is on left hand side";
    protected static final boolean TEMPORARY_POLYNOMIAL_TERM_TEST = false;
    protected final RelationSymbol mRelationSymbol;
    protected final TrivialityStatus mTrivialityStatus;
    protected final AbstractGeneralizedAffineTerm<?> mPolynomialTerm;

    private PolynomialRelation(AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm, RelationSymbol relationSymbol) {
        if (relationSymbol.isConvexInequality() && SmtSortUtils.isBitvecSort(abstractGeneralizedAffineTerm.getSort())) {
            throw new AssertionError((Object)"Unsupported inequality/sort combination");
        }
        this.mRelationSymbol = relationSymbol;
        if (!SmtSortUtils.isIntSort(abstractGeneralizedAffineTerm.getSort())) {
            this.mPolynomialTerm = Objects.requireNonNull(abstractGeneralizedAffineTerm);
            this.mTrivialityStatus = PolynomialRelation.computeTrivialityStatus(this.mPolynomialTerm, this.mRelationSymbol);
        } else {
            Rational rational = abstractGeneralizedAffineTerm.computeGcdOfCoefficients().abs();
            assert (rational.isIntegral());
            assert (!rational.isNegative());
            if (rational.equals((Object)Rational.ZERO) || rational.equals((Object)Rational.ONE)) {
                this.mPolynomialTerm = Objects.requireNonNull(abstractGeneralizedAffineTerm);
                this.mTrivialityStatus = PolynomialRelation.computeTrivialityStatus(this.mPolynomialTerm, this.mRelationSymbol);
            } else {
                IPolynomialTerm iPolynomialTerm = abstractGeneralizedAffineTerm.divInvertible(rational);
                if (iPolynomialTerm != null) {
                    this.mPolynomialTerm = (AbstractGeneralizedAffineTerm)Objects.requireNonNull(iPolynomialTerm);
                    this.mTrivialityStatus = PolynomialRelation.computeTrivialityStatus(iPolynomialTerm, this.mRelationSymbol);
                } else {
                    switch (this.mRelationSymbol) {
                        case EQ: 
                        case DISTINCT: {
                            this.mPolynomialTerm = AffineTerm.constructConstant(abstractGeneralizedAffineTerm.getSort(), BigInteger.ONE);
                            this.mTrivialityStatus = PolynomialRelation.computeTrivialityStatus(this.mPolynomialTerm, this.mRelationSymbol);
                            break;
                        }
                        case LEQ: 
                        case GEQ: 
                        case LESS: 
                        case GREATER: {
                            IPolynomialTerm iPolynomialTerm2 = abstractGeneralizedAffineTerm.add(abstractGeneralizedAffineTerm.getConstant().negate());
                            IPolynomialTerm iPolynomialTerm3 = ((AbstractGeneralizedAffineTerm)iPolynomialTerm2).divInvertible(rational);
                            assert (iPolynomialTerm3 != null) : "Division problem";
                            Rational rational2 = abstractGeneralizedAffineTerm.getConstant().div(rational);
                            Rational rational3 = PolynomialRelation.getEquivalencePreservingRoundingMethod(this.mRelationSymbol).apply(rational2);
                            this.mPolynomialTerm = ((AbstractGeneralizedAffineTerm)iPolynomialTerm3).add(rational3);
                            this.mTrivialityStatus = PolynomialRelation.computeTrivialityStatus(this.mPolynomialTerm, this.mRelationSymbol);
                            break;
                        }
                        case BVULE: 
                        case BVULT: 
                        case BVUGE: 
                        case BVUGT: 
                        case BVSLE: 
                        case BVSLT: 
                        case BVSGE: 
                        case BVSGT: {
                            throw new AssertionError();
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown value " + String.valueOf((Object)this.mRelationSymbol)));
                        }
                    }
                }
            }
        }
    }

    private static Function<Rational, Rational> getEquivalencePreservingRoundingMethod(RelationSymbol relationSymbol) {
        switch (relationSymbol) {
            case GEQ: 
            case LESS: {
                return Rational::floor;
            }
            case LEQ: 
            case GREATER: {
                return Rational::ceil;
            }
            case EQ: 
            case DISTINCT: 
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new IllegalArgumentException();
            }
        }
        throw new AssertionError((Object)("Unknown value " + String.valueOf((Object)relationSymbol)));
    }

    public static PolynomialRelation of(AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm, RelationSymbol relationSymbol) {
        return new PolynomialRelation(abstractGeneralizedAffineTerm, relationSymbol);
    }

    public static PolynomialRelation of(Script script, Term term) {
        return PolynomialRelation.of(script, term, TransformInequality.NO_TRANFORMATION);
    }

    public static PolynomialRelation of(Script script, Term term, TransformInequality transformInequality) {
        BinaryNumericRelation binaryNumericRelation = BinaryNumericRelation.convert(term);
        if (binaryNumericRelation == null) {
            return null;
        }
        Term term2 = binaryNumericRelation.getLhs();
        Term term3 = binaryNumericRelation.getRhs();
        AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm = PolynomialRelation.transformToPolynomialTerm(script, term2);
        AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm2 = PolynomialRelation.transformToPolynomialTerm(script, term3);
        if (abstractGeneralizedAffineTerm.isErrorTerm() || abstractGeneralizedAffineTerm2.isErrorTerm()) {
            return null;
        }
        if (binaryNumericRelation.getRelationSymbol().isConvexInequality() && SmtSortUtils.isBitvecSort(term2.getSort())) {
            return null;
        }
        RelationSymbol relationSymbol = binaryNumericRelation.getRelationSymbol();
        return PolynomialRelation.of(transformInequality, relationSymbol, abstractGeneralizedAffineTerm, abstractGeneralizedAffineTerm2);
    }

    public static PolynomialRelation of(Script script, RelationSymbol relationSymbol, Term term, Term term2) {
        IPolynomialTerm iPolynomialTerm = PolynomialTermTransformer.convert(script, term);
        IPolynomialTerm iPolynomialTerm2 = PolynomialTermTransformer.convert(script, term2);
        if (iPolynomialTerm == null || iPolynomialTerm2 == null) {
            throw new AssertionError((Object)"lhs or rhs not suitable for polynomial");
        }
        return PolynomialRelation.of(TransformInequality.NO_TRANFORMATION, relationSymbol, (AbstractGeneralizedAffineTerm)iPolynomialTerm, (AbstractGeneralizedAffineTerm)iPolynomialTerm2);
    }

    public static PolynomialRelation of(TransformInequality transformInequality, RelationSymbol relationSymbol, AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm, AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm2) {
        AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm3;
        RelationSymbol relationSymbol2;
        if (abstractGeneralizedAffineTerm.getSort() != abstractGeneralizedAffineTerm2.getSort()) {
            throw new AssertionError((Object)"Inconsistent sorts");
        }
        if (!SmtSortUtils.isNumericSort(abstractGeneralizedAffineTerm.getSort()) && !SmtSortUtils.isBitvecSort(abstractGeneralizedAffineTerm.getSort())) {
            throw new AssertionError((Object)"Unsupported sorts");
        }
        if (relationSymbol.isConvexInequality() && SmtSortUtils.isBitvecSort(abstractGeneralizedAffineTerm.getSort())) {
            throw new AssertionError((Object)"Unsupported inequality/sort combination");
        }
        AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm4 = PolynomialTerm.sum(abstractGeneralizedAffineTerm, PolynomialTerm.mul(abstractGeneralizedAffineTerm2, Rational.MONE));
        if (transformInequality != TransformInequality.NO_TRANFORMATION && SmtSortUtils.isIntSort(abstractGeneralizedAffineTerm4.getSort())) {
            Rational rational;
            if (transformInequality == TransformInequality.STRICT2NONSTRICT) {
                relationSymbol2 = relationSymbol.getCorrespondingNonStrictRelationSymbol();
                rational = relationSymbol.getOffsetForStrictToNonstrictTransformation();
            } else if (transformInequality == TransformInequality.NONSTRICT2STRICT) {
                relationSymbol2 = relationSymbol.getCorrespondingStrictRelationSymbol();
                rational = relationSymbol.getOffsetForNonstrictToStrictTransformation();
            } else {
                throw new AssertionError((Object)"unknown case");
            }
            abstractGeneralizedAffineTerm3 = rational.equals((Object)Rational.ZERO) ? abstractGeneralizedAffineTerm4 : PolynomialTerm.sum(abstractGeneralizedAffineTerm4, PolynomialRelation.constructConstant(abstractGeneralizedAffineTerm4.getSort(), rational));
        } else {
            abstractGeneralizedAffineTerm3 = abstractGeneralizedAffineTerm4;
            relationSymbol2 = relationSymbol;
        }
        return new PolynomialRelation(abstractGeneralizedAffineTerm3, relationSymbol2);
    }

    private static AffineTerm constructConstant(Sort sort, Rational rational) {
        return AffineTerm.constructConstant(sort, rational);
    }

    private static TrivialityStatus computeTrivialityStatus(AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm, RelationSymbol relationSymbol) {
        if (!abstractGeneralizedAffineTerm.isConstant()) {
            return PolynomialRelation.checkMinMaxValues(abstractGeneralizedAffineTerm, relationSymbol);
        }
        return switch (relationSymbol) {
            case RelationSymbol.DISTINCT -> PolynomialRelation.computeTrivialityStatus(abstractGeneralizedAffineTerm, (Integer n) -> n != 0);
            case RelationSymbol.EQ -> PolynomialRelation.computeTrivialityStatus(abstractGeneralizedAffineTerm, (Integer n) -> n == 0);
            case RelationSymbol.LESS -> PolynomialRelation.computeTrivialityStatus(abstractGeneralizedAffineTerm, (Integer n) -> n < 0);
            case RelationSymbol.GREATER -> PolynomialRelation.computeTrivialityStatus(abstractGeneralizedAffineTerm, (Integer n) -> n > 0);
            case RelationSymbol.GEQ -> PolynomialRelation.computeTrivialityStatus(abstractGeneralizedAffineTerm, (Integer n) -> n >= 0);
            case RelationSymbol.LEQ -> PolynomialRelation.computeTrivialityStatus(abstractGeneralizedAffineTerm, (Integer n) -> n <= 0);
            case RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> TrivialityStatus.NONTRIVIAL;
            default -> throw new MatchException(null, null);
        };
    }

    private static TrivialityStatus checkMinMaxValues(AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm, RelationSymbol relationSymbol) {
        TrivialityStatus trivialityStatus;
        Pair<Rational, Rational> pair = abstractGeneralizedAffineTerm.computeMinMax();
        if (pair == null) {
            trivialityStatus = TrivialityStatus.NONTRIVIAL;
        } else {
            Rational rational = (Rational)pair.getFirst();
            Rational rational2 = (Rational)pair.getSecond();
            switch (relationSymbol) {
                case DISTINCT: {
                    if (rational.compareTo(Rational.ZERO) > 0 || rational2.compareTo(Rational.ZERO) < 0) {
                        trivialityStatus = TrivialityStatus.EQUIVALENT_TO_TRUE;
                        break;
                    }
                    trivialityStatus = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case EQ: {
                    if (rational.compareTo(Rational.ZERO) > 0 || rational2.compareTo(Rational.ZERO) < 0) {
                        trivialityStatus = TrivialityStatus.EQUIVALENT_TO_FALSE;
                        break;
                    }
                    trivialityStatus = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case LESS: {
                    if (rational2.compareTo(Rational.ZERO) < 0) {
                        trivialityStatus = TrivialityStatus.EQUIVALENT_TO_TRUE;
                        break;
                    }
                    if (rational.compareTo(Rational.ZERO) >= 0) {
                        trivialityStatus = TrivialityStatus.EQUIVALENT_TO_FALSE;
                        break;
                    }
                    trivialityStatus = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case GREATER: {
                    if (rational.compareTo(Rational.ZERO) > 0) {
                        trivialityStatus = TrivialityStatus.EQUIVALENT_TO_TRUE;
                        break;
                    }
                    if (rational2.compareTo(Rational.ZERO) <= 0) {
                        trivialityStatus = TrivialityStatus.EQUIVALENT_TO_FALSE;
                        break;
                    }
                    trivialityStatus = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case GEQ: {
                    if (rational.compareTo(Rational.ZERO) >= 0) {
                        trivialityStatus = TrivialityStatus.EQUIVALENT_TO_TRUE;
                        break;
                    }
                    if (rational2.compareTo(Rational.ZERO) < 0) {
                        trivialityStatus = TrivialityStatus.EQUIVALENT_TO_FALSE;
                        break;
                    }
                    trivialityStatus = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case LEQ: {
                    if (rational2.compareTo(Rational.ZERO) <= 0) {
                        trivialityStatus = TrivialityStatus.EQUIVALENT_TO_TRUE;
                        break;
                    }
                    if (rational.compareTo(Rational.ZERO) > 0) {
                        trivialityStatus = TrivialityStatus.EQUIVALENT_TO_FALSE;
                        break;
                    }
                    trivialityStatus = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case BVULE: 
                case BVULT: 
                case BVUGE: 
                case BVUGT: 
                case BVSLE: 
                case BVSLT: 
                case BVSGE: 
                case BVSGT: {
                    TrivialityStatus trivialityStatus2 = TrivialityStatus.NONTRIVIAL;
                }
                default: {
                    throw new UnsupportedOperationException("unknown relation symbol: " + String.valueOf((Object)relationSymbol));
                }
            }
        }
        return trivialityStatus;
    }

    private static TrivialityStatus computeTrivialityStatus(AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm, Predicate<Integer> predicate) {
        if (predicate.test(abstractGeneralizedAffineTerm.getConstant().signum())) {
            return TrivialityStatus.EQUIVALENT_TO_TRUE;
        }
        return TrivialityStatus.EQUIVALENT_TO_FALSE;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public AbstractGeneralizedAffineTerm<?> getPolynomialTerm() {
        return this.mPolynomialTerm;
    }

    @Override
    public Term toTerm(Script script) {
        Term term;
        if (this.mTrivialityStatus == TrivialityStatus.EQUIVALENT_TO_TRUE) {
            return script.term("true", new Term[0]);
        }
        if (this.mTrivialityStatus == TrivialityStatus.EQUIVALENT_TO_FALSE) {
            return script.term("false", new Term[0]);
        }
        assert (this.mTrivialityStatus == TrivialityStatus.NONTRIVIAL);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (Map.Entry<Term, Rational> term22 : this.mPolynomialTerm.getAbstractVariableAsTerm2Coefficient(script).entrySet()) {
            term = term22.getKey();
            if (SmtSortUtils.isBitvecSort(this.mPolynomialTerm.getSort())) {
                if (PolynomialRelation.isNegativeAsSignedInt(term22.getValue(), this.mPolynomialTerm.getSort())) {
                    Rational rational = PolynomialTermUtils.bringBitvectorValueInRange(term22.getValue().mul(Rational.MONE), this.mPolynomialTerm.getSort());
                    arrayList2.add(SmtUtils.mul(script, rational, term));
                    continue;
                }
                arrayList.add(SmtUtils.mul(script, term22.getValue(), term));
                continue;
            }
            if (term22.getValue().isNegative()) {
                arrayList2.add(SmtUtils.mul(script, term22.getValue().abs(), term));
                continue;
            }
            arrayList.add(SmtUtils.mul(script, term22.getValue(), term));
        }
        if (this.mPolynomialTerm.getConstant() != Rational.ZERO) {
            if (SmtSortUtils.isBitvecSort(this.mPolynomialTerm.getSort())) {
                if (PolynomialRelation.isNegativeAsSignedInt(this.mPolynomialTerm.getConstant(), this.mPolynomialTerm.getSort())) {
                    Rational rational = PolynomialTermUtils.bringBitvectorValueInRange(this.mPolynomialTerm.getConstant().mul(Rational.MONE), this.mPolynomialTerm.getSort());
                    arrayList2.add(SmtUtils.rational2Term(script, rational, this.mPolynomialTerm.getSort()));
                } else {
                    arrayList.add(SmtUtils.rational2Term(script, this.mPolynomialTerm.getConstant(), this.mPolynomialTerm.getSort()));
                }
            } else if (this.mPolynomialTerm.getConstant().isNegative()) {
                arrayList2.add(SmtUtils.rational2Term(script, this.mPolynomialTerm.getConstant().abs(), this.mPolynomialTerm.getSort()));
            } else {
                arrayList.add(SmtUtils.rational2Term(script, this.mPolynomialTerm.getConstant(), this.mPolynomialTerm.getSort()));
            }
        }
        Term term2 = SmtUtils.sum(script, this.mPolynomialTerm.getSort(), arrayList.toArray(new Term[arrayList.size()]));
        Term term3 = SmtUtils.sum(script, this.mPolynomialTerm.getSort(), arrayList2.toArray(new Term[arrayList2.size()]));
        term = BinaryRelation.constructLessNormalForm(script, this.mRelationSymbol, term2, term3);
        return term;
    }

    private static boolean isNegativeAsSignedInt(Rational rational, Sort sort) {
        if (!rational.isIntegral()) {
            throw new AssertionError();
        }
        if (!SmtSortUtils.isBitvecSort(sort)) {
            throw new AssertionError();
        }
        BitvectorConstant bitvectorConstant = BitvectorUtils.constructBitvectorConstant(rational.numerator(), sort);
        return bitvectorConstant.toSignedInt().compareTo(BigInteger.ZERO) < 0;
    }

    @Override
    public SolvedBinaryRelation solveForSubject(Script script, Term term) {
        ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, term, this);
        if (explicitLhsPolynomialRelation == null) {
            return null;
        }
        if (!explicitLhsPolynomialRelation.getLhsMonomial().isLinear()) {
            return null;
        }
        ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation2 = explicitLhsPolynomialRelation.divInvertible(explicitLhsPolynomialRelation.getLhsCoefficient());
        if (explicitLhsPolynomialRelation2 == null) {
            return null;
        }
        assert (term.equals(explicitLhsPolynomialRelation2.getLhsMonomial().getSingleVariable()));
        SolvedBinaryRelation solvedBinaryRelation = new SolvedBinaryRelation(term, explicitLhsPolynomialRelation2.getRhs().toTerm(script), explicitLhsPolynomialRelation2.getRelationSymbol(), new MultiCaseSolvedBinaryRelation.IntricateOperation[0]);
        Term term2 = solvedBinaryRelation.toTerm(script);
        assert (script instanceof INonSolverScript || SmtUtils.checkEquivalence(this.toTerm(script), term2, script) != Script.LBool.SAT) : "solveForSubject unsound";
        return solvedBinaryRelation;
    }

    public MultiCaseSolvedBinaryRelation solveForSubject(ManagedScript managedScript, Term term, MultiCaseSolvedBinaryRelation.Xnf xnf, Set<TermVariable> set, boolean bl) {
        return SolveForSubjectUtils.solveForSubject(managedScript, term, xnf, this, set, bl);
    }

    public boolean isAffine() {
        return this.mPolynomialTerm.isAffine();
    }

    public boolean isVariable(Term term) {
        return this.mPolynomialTerm.isVariable(term);
    }

    public PolynomialRelation negate() {
        return new PolynomialRelation(this.mPolynomialTerm, this.mRelationSymbol.negate());
    }

    public PolynomialRelation mul(Script script, Rational rational) {
        RelationSymbol relationSymbol = ExplicitLhsPolynomialRelation.swapOfRelationSymbolRequired(rational, this.mPolynomialTerm.getSort()) ? this.mRelationSymbol.swapParameters() : this.mRelationSymbol;
        return new PolynomialRelation((AbstractGeneralizedAffineTerm)PolynomialTermOperations.mul(this.mPolynomialTerm, rational), relationSymbol);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mPolynomialTerm == null ? 0 : this.mPolynomialTerm.hashCode());
        n = 31 * n + (this.mRelationSymbol == null ? 0 : this.mRelationSymbol.ordinal());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PolynomialRelation polynomialRelation = (PolynomialRelation)object;
        if (this.mPolynomialTerm == null ? polynomialRelation.mPolynomialTerm != null : !this.mPolynomialTerm.equals(polynomialRelation.mPolynomialTerm)) {
            return false;
        }
        return this.mRelationSymbol == polynomialRelation.mRelationSymbol;
    }

    public String toString() {
        String string = SmtSortUtils.isBitvecSort(this.getPolynomialTerm().getSort()) ? BitvectorUtils.constructBitvectorConstant(BigInteger.ZERO, this.getPolynomialTerm().getSort()).toString() : Rational.ZERO.toTerm(this.mPolynomialTerm.getSort()).toString();
        return String.format("(%s, %s, %s)", this.mRelationSymbol.toString(), this.mPolynomialTerm.toString(), string);
    }

    private static AbstractGeneralizedAffineTerm<?> transformToPolynomialTerm(Script script, Term term) {
        return (AbstractGeneralizedAffineTerm)PolynomialTermTransformer.convert(script, term);
    }

    public SolvedBinaryRelation isSimpleEquality(Script script) {
        Rational rational;
        if (this.mRelationSymbol != RelationSymbol.EQ) {
            return null;
        }
        if (!this.isAffine()) {
            return null;
        }
        Map map = ((AffineTerm)this.mPolynomialTerm).getAbstractVariable2Coefficient();
        Iterator iterator = map.entrySet().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Map.Entry entry = iterator.next();
        if (iterator.hasNext()) {
            return null;
        }
        if (SmtSortUtils.isRealSort(this.mPolynomialTerm.getSort())) {
            rational = this.mPolynomialTerm.getConstant().negate().div(entry.getValue());
        } else {
            assert (SmtSortUtils.isIntSort(this.mPolynomialTerm.getSort()) || SmtSortUtils.isBitvecSort(this.mPolynomialTerm.getSort()));
            if (entry.getValue().equals((Object)Rational.ONE)) {
                rational = this.mPolynomialTerm.getConstant().negate();
            } else if (entry.getValue().equals((Object)Rational.MONE) || SmtSortUtils.isBitvecSort(this.mPolynomialTerm.getSort()) && SmtUtils.isBvMinusOneButNotOne(entry.getValue(), this.mPolynomialTerm.getSort())) {
                rational = this.mPolynomialTerm.getConstant();
            } else {
                return null;
            }
        }
        return new SolvedBinaryRelation((Term)entry.getKey(), SmtUtils.rational2Term(script, rational, this.mPolynomialTerm.getSort()), this.mRelationSymbol, new MultiCaseSolvedBinaryRelation.IntricateOperation[0]);
    }

    public PolynomialRelation tryToConvertToEquivalentNonStrictRelation() {
        if (SmtSortUtils.isIntSort(this.mPolynomialTerm.getSort()) && this.mRelationSymbol.isStrictRelation()) {
            Rational rational = this.mRelationSymbol.getOffsetForStrictToNonstrictTransformation();
            return new PolynomialRelation((AbstractGeneralizedAffineTerm<?>)this.mPolynomialTerm.add(rational), this.mRelationSymbol.getCorrespondingNonStrictRelationSymbol());
        }
        return this;
    }

    public static enum TransformInequality {
        NO_TRANFORMATION,
        STRICT2NONSTRICT,
        NONSTRICT2STRICT;


        public static TransformInequality determineTransformationForTir(int n) {
            TransformInequality transformInequality;
            if (n == 0) {
                transformInequality = STRICT2NONSTRICT;
            } else if (n == 1) {
                transformInequality = NONSTRICT2STRICT;
            } else {
                throw new AssertionError((Object)"Unknown quantifier");
            }
            return transformInequality;
        }
    }

    public static enum TrivialityStatus {
        EQUIVALENT_TO_TRUE,
        EQUIVALENT_TO_FALSE,
        NONTRIVIAL;

    }
}

