/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.ltl2aut.never2nwa;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.DummyStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieExpressionTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.annotation.LTLPropertyCheck;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.ltl2aut.Activator;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.AstNode;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.BinaryOperator;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.BinaryType;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.BoolLiteral;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.ComperativeOperator;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.ComperativeType;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.IntLiteral;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.LabeledBlock;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.Name;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.Not;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.OptionStatement;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.SkipStatement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import de.uni_freiburg.informatik.ultimate.util.simplifier.NormalFormTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Never2Automaton {
    private final IUltimateServiceProvider mServices;
    private final AstNode mNeverClaim;
    private final ILogger mLogger;
    private final Map<String, LTLPropertyCheck.CheckableExpression> mIRS;
    private final CodeBlockFactory mCodeblockFactory;
    private final NestedWordAutomaton<CodeBlock, String> mAutomaton;
    private final boolean mUseSBE;
    private final boolean mRewriteAssumeDuringSBE;

    public Never2Automaton(AstNode astNode, BoogieSymbolTable boogieSymbolTable, Map<String, LTLPropertyCheck.CheckableExpression> map, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, CodeBlockFactory codeBlockFactory) throws Exception {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mNeverClaim = astNode;
        this.mIRS = map;
        this.mCodeblockFactory = codeBlockFactory;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mUseSBE = iPreferenceProvider.getBoolean("Use small block encoding");
        this.mRewriteAssumeDuringSBE = iPreferenceProvider.getBoolean("Rewrite not equals during small block encoding");
        this.mAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(this.mServices), new VpAlphabet(this.collectAlphabet()), (IEmptyStackStateFactory)new DummyStateFactory());
        this.collectStates(this.mNeverClaim, null);
        this.mLogger.debug((Object)String.format("Resulting automaton is:\n%s", this.mAutomaton));
    }

    public INestedWordAutomaton<CodeBlock, String> getAutomaton() {
        return this.mAutomaton;
    }

    private void collectStates(AstNode astNode, String string) throws Exception {
        block6: {
            block7: {
                block5: {
                    if (!(astNode instanceof LabeledBlock)) break block5;
                    String string2 = ((Name)((LabeledBlock)astNode).getValue()).getIdent();
                    this.addState(string2);
                    for (AstNode astNode2 : astNode.getOutgoingNodes()) {
                        this.collectStates(astNode2, string2);
                    }
                    break block6;
                }
                if (astNode instanceof BoolLiteral) break block6;
                if (!(astNode instanceof SkipStatement)) break block7;
                this.addTransition(string, this.getAssumeTrue(), string);
                break block6;
            }
            if (astNode instanceof Name) break block6;
            if (astNode instanceof OptionStatement) {
                String string3 = ((Name)((Object)((AstNode)((Object)astNode.getOutgoingNodes().get(0))).getOutgoingNodes().get(0))).getIdent();
                this.addState(string3);
                for (CodeBlock codeBlock : this.getAssume(((OptionStatement)astNode).getCondition())) {
                    this.addTransition(string, codeBlock, string3);
                }
            } else {
                for (AstNode astNode3 : astNode.getOutgoingNodes()) {
                    this.collectStates(astNode3, string);
                }
            }
        }
    }

    public Set<CodeBlock> collectAlphabet() throws Exception {
        HashSet<CodeBlock> hashSet = new HashSet<CodeBlock>();
        this.visitAstForSymbols(this.mNeverClaim, hashSet);
        return hashSet;
    }

    private void visitAstForSymbols(AstNode astNode, Set<CodeBlock> set) throws Exception {
        if (!(astNode instanceof BoolLiteral)) {
            if (astNode instanceof SkipStatement) {
                set.add(this.getAssumeTrue());
            } else if (!(astNode instanceof Name)) {
                if (astNode instanceof OptionStatement) {
                    set.addAll(this.getAssume(((OptionStatement)astNode).getCondition()));
                } else {
                    for (AstNode astNode2 : astNode.getOutgoingNodes()) {
                        this.visitAstForSymbols(astNode2, set);
                    }
                }
            }
        }
    }

    private CodeBlock getAssumeTrue() {
        ILocation iLocation = null;
        StatementSequence statementSequence = this.mCodeblockFactory.constructStatementSequence(null, null, (Statement)new AssumeStatement(iLocation, (Expression)new BooleanLiteral(iLocation, true)));
        return statementSequence;
    }

    private List<CodeBlock> getAssume(AstNode astNode) throws Exception {
        Name name;
        if (astNode instanceof Name) {
            name = (Name)astNode;
            LTLPropertyCheck.CheckableExpression checkableExpression = this.mIRS.get(name.getIdent().toUpperCase());
            if (checkableExpression != null) {
                return this.getAssumeFromCheckableExpression(checkableExpression);
            }
            this.mLogger.warn((Object)("Root condition is a name, but no mapping in IRS found: " + name.getIdent()));
        }
        name = this.toBoogieAst(astNode);
        return this.getAssumeFromCheckableExpression((LTLPropertyCheck.CheckableExpression)name);
    }

    private List<CodeBlock> getAssumeFromCheckableExpression(LTLPropertyCheck.CheckableExpression checkableExpression) {
        ArrayList<CodeBlock> arrayList = new ArrayList<CodeBlock>();
        ArrayList arrayList2 = new ArrayList();
        if (checkableExpression.getStatements() != null) {
            arrayList2.addAll(checkableExpression.getStatements());
        }
        ILocation iLocation = checkableExpression.getExpression().getLocation();
        for (Expression expression : this.simplify(checkableExpression.getExpression())) {
            ArrayList<AssumeStatement> arrayList3 = new ArrayList<AssumeStatement>(arrayList2);
            arrayList3.add(new AssumeStatement(iLocation, expression));
            arrayList.add((CodeBlock)this.mCodeblockFactory.constructStatementSequence(null, null, arrayList3));
        }
        return arrayList;
    }

    private Collection<Expression> simplify(Expression expression) {
        if (this.mUseSBE) {
            NormalFormTransformer normalFormTransformer = new NormalFormTransformer((INormalFormable)new BoogieExpressionTransformer());
            if (this.mRewriteAssumeDuringSBE) {
                expression = (Expression)normalFormTransformer.rewriteNotEquals((Object)expression);
            }
            return normalFormTransformer.toDnfDisjuncts((Object)expression);
        }
        return Collections.singleton(expression);
    }

    public LTLPropertyCheck.CheckableExpression toBoogieAst(AstNode astNode) throws Exception {
        if (astNode instanceof BinaryOperator) {
            BinaryOperator binaryOperator = (BinaryOperator)astNode;
            BinaryExpression.Operator operator = switch (binaryOperator.getType()) {
                case BinaryType.and -> BinaryExpression.Operator.LOGICAND;
                case BinaryType.minus -> BinaryExpression.Operator.ARITHMINUS;
                case BinaryType.or -> BinaryExpression.Operator.LOGICOR;
                case BinaryType.plus -> BinaryExpression.Operator.ARITHPLUS;
                case BinaryType.times -> BinaryExpression.Operator.ARITHMUL;
                case BinaryType.divide -> BinaryExpression.Operator.ARITHDIV;
                default -> throw new Exception("Binary Operator unknown");
            };
            LTLPropertyCheck.CheckableExpression checkableExpression = this.toBoogieAst((AstNode)((Object)astNode.getOutgoingNodes().get(0)));
            LTLPropertyCheck.CheckableExpression checkableExpression2 = this.toBoogieAst((AstNode)((Object)astNode.getOutgoingNodes().get(1)));
            LTLPropertyCheck.CheckableExpression checkableExpression3 = new LTLPropertyCheck.CheckableExpression((Expression)new BinaryExpression(null, operator, checkableExpression.getExpression(), checkableExpression2.getExpression()), Never2Automaton.mergeStatements(checkableExpression, checkableExpression2));
            if (astNode.getOutgoingNodes().size() > 2) {
                int n = 2;
                while (n < astNode.getOutgoingNodes().size()) {
                    checkableExpression2 = this.toBoogieAst((AstNode)((Object)astNode.getOutgoingNodes().get(n)));
                    checkableExpression3 = new LTLPropertyCheck.CheckableExpression((Expression)new BinaryExpression(null, operator, checkableExpression3.getExpression(), checkableExpression2.getExpression()), Never2Automaton.mergeStatements(checkableExpression3, checkableExpression2));
                    ++n;
                }
            }
            return checkableExpression3;
        }
        if (astNode instanceof BoolLiteral) {
            return new LTLPropertyCheck.CheckableExpression((Expression)new BooleanLiteral(null, (IBoogieType)BoogieType.TYPE_BOOL, ((BoolLiteral)astNode).getValue()), null);
        }
        if (astNode instanceof ComperativeOperator) {
            BinaryExpression.Operator operator = switch (((ComperativeOperator)astNode).getType()) {
                case ComperativeType.equals -> BinaryExpression.Operator.COMPEQ;
                case ComperativeType.geq -> BinaryExpression.Operator.COMPGEQ;
                case ComperativeType.greater -> BinaryExpression.Operator.COMPGT;
                default -> throw new Exception("Binary Operator unknown");
            };
            LTLPropertyCheck.CheckableExpression checkableExpression = this.toBoogieAst((AstNode)((Object)astNode.getOutgoingNodes().get(0)));
            LTLPropertyCheck.CheckableExpression checkableExpression4 = this.toBoogieAst((AstNode)((Object)astNode.getOutgoingNodes().get(1)));
            LTLPropertyCheck.CheckableExpression checkableExpression5 = new LTLPropertyCheck.CheckableExpression((Expression)new BinaryExpression(null, operator, checkableExpression.getExpression(), checkableExpression4.getExpression()), Never2Automaton.mergeStatements(checkableExpression, checkableExpression4));
            return checkableExpression5;
        }
        if (astNode instanceof IntLiteral) {
            return new LTLPropertyCheck.CheckableExpression((Expression)new IntegerLiteral(null, Integer.toString(((IntLiteral)astNode).getValue())), null);
        }
        if (astNode instanceof Name) {
            Name name = (Name)astNode;
            LTLPropertyCheck.CheckableExpression checkableExpression = this.mIRS.get(name.getIdent().toUpperCase());
            if (checkableExpression != null) {
                return checkableExpression;
            }
        } else {
            if (astNode instanceof Not) {
                LTLPropertyCheck.CheckableExpression checkableExpression = this.toBoogieAst((AstNode)((Object)astNode.getOutgoingNodes().get(0)));
                return new LTLPropertyCheck.CheckableExpression((Expression)new UnaryExpression(null, UnaryExpression.Operator.LOGICNEG, checkableExpression.getExpression()), checkableExpression.getStatements());
            }
            if (astNode instanceof Name) {
                Name name = (Name)astNode;
                if ("true".equalsIgnoreCase(name.getIdent())) {
                    return new LTLPropertyCheck.CheckableExpression((Expression)new BooleanLiteral(null, true), null);
                }
                if ("false".equalsIgnoreCase(name.getIdent())) {
                    return new LTLPropertyCheck.CheckableExpression((Expression)new BooleanLiteral(null, false), null);
                }
            }
        }
        throw new Exception(String.format("Type %s should not occur as part of a atomic Proposition in LTL", ((Object)((Object)astNode)).getClass().toString()));
    }

    private static List<Statement> mergeStatements(LTLPropertyCheck.CheckableExpression ... checkableExpressionArray) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        LTLPropertyCheck.CheckableExpression[] checkableExpressionArray2 = checkableExpressionArray;
        int n = checkableExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            LTLPropertyCheck.CheckableExpression checkableExpression = checkableExpressionArray2[n2];
            if (checkableExpression.getStatements() != null) {
                arrayList.addAll(checkableExpression.getStatements());
            }
            ++n2;
        }
        return arrayList;
    }

    private void addTransition(String string, CodeBlock codeBlock, String string2) {
        this.mAutomaton.getVpAlphabet().getInternalAlphabet().add(codeBlock);
        this.mAutomaton.addInternalTransition((Object)string, (Object)codeBlock, (Object)string2);
    }

    private void addState(String string) {
        if (!this.mAutomaton.getStates().contains(string)) {
            this.mAutomaton.addState(string.endsWith("init"), string.startsWith("accept"), (Object)string);
        }
    }
}

