/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies;

import de.uni_freiburg.informatik.ultimate.core.model.IAnalysis;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.RCFGLoopDetectorObserver;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.preferences.IRSDependenciesPreferenceInitializer;
import java.util.LinkedList;
import java.util.List;

public class IrsDependencies
implements IAnalysis {
    private ILogger mLogger;
    private final List<IObserver> mObservers = new LinkedList<IObserver>();
    private IUltimateServiceProvider mServices;

    public ModelType getOutputDefinition() {
        return null;
    }

    public boolean isGuiRequired() {
        return false;
    }

    public ITool.ModelQuery getModelQuery() {
        return ITool.ModelQuery.ALL;
    }

    public List<String> getDesiredToolIds() {
        return null;
    }

    public void setInputDefinition(ModelType modelType) {
        this.mLogger.info((Object)("Receiving input definition " + modelType.toString()));
        this.mObservers.clear();
        IRSDependenciesPreferenceInitializer.Mode mode = (IRSDependenciesPreferenceInitializer.Mode)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("Mode", IRSDependenciesPreferenceInitializer.Mode.class);
        switch (mode) {
            case Default: {
                this.setInputDefinitionModeDefault(modelType);
                break;
            }
            default: {
                String string = "Unknown mode: " + String.valueOf((Object)mode);
                this.mLogger.fatal((Object)string);
                throw new IllegalArgumentException(string);
            }
        }
    }

    private void setInputDefinitionModeDefault(ModelType modelType) {
        String string;
        switch (string = modelType.getCreator()) {
            case "de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder": {
                this.mLogger.info((Object)"Preparing to process RCFG...");
                this.mObservers.add((IObserver)new RCFGLoopDetectorObserver(this.mServices));
                break;
            }
            default: {
                this.mLogger.warn((Object)("Ignoring input definition " + string));
            }
        }
    }

    public List<IObserver> getObservers() {
        return this.mObservers;
    }

    public void init() {
    }

    public String getPluginName() {
        return "IRS Dependencies";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public IPreferenceInitializer getPreferences() {
        return new IRSDependenciesPreferenceInitializer();
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public void finish() {
    }
}

