/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph;

import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISemanticReducerFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HCHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HCPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HCPredicateFactory;
import de.uni_freiburg.informatik.ultimate.util.CombinatoricsUtils;
import de.uni_freiburg.informatik.ultimate.util.scc.DefaultStronglyConnectedComponentFactory;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HCStateFactory
implements IMergeStateFactory<IPredicate>,
IIntersectionStateFactory<IPredicate>,
ISinkStateFactory<IPredicate>,
ISemanticReducerFactory<IPredicate, HornClause> {
    private final HCPredicate mSinkState;
    private final ManagedScript mMgdScript;
    private final SimplifyDDA mSimplifier;
    private final HCPredicateFactory mPredicateFactory;
    private final PredicateUnifier mPredicateUnifier;
    private final HCHoareTripleChecker mHoareTripleChecker;
    private int mSer;
    private final ILogger mLogger;
    private final boolean mDummySemanticReduction;
    private final IUltimateServiceProvider mServices;

    public HCStateFactory(ManagedScript managedScript, HCPredicateFactory hCPredicateFactory, IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, PredicateUnifier predicateUnifier, HCHoareTripleChecker hCHoareTripleChecker) {
        this(managedScript, hCPredicateFactory, iUltimateServiceProvider, iLogger, predicateUnifier, hCHoareTripleChecker, false);
    }

    public HCStateFactory(ManagedScript managedScript, HCPredicateFactory hCPredicateFactory, IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, PredicateUnifier predicateUnifier, HCHoareTripleChecker hCHoareTripleChecker, boolean bl) {
        this.mMgdScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mSinkState = hCPredicateFactory.getDontCareLocationPredicate();
        this.mSimplifier = new SimplifyDDA(this.mMgdScript.getScript());
        this.mPredicateFactory = hCPredicateFactory;
        this.mPredicateUnifier = predicateUnifier;
        this.mHoareTripleChecker = hCHoareTripleChecker;
        this.mDummySemanticReduction = bl;
        this.mSer = 0;
    }

    protected int constructFreshSerialNumber() {
        return ++this.mSer;
    }

    public IPredicate createSinkStateContent() {
        return this.mSinkState;
    }

    public IPredicate intersection(IPredicate iPredicate, IPredicate iPredicate2) {
        HashSet<HcPredicateSymbol> hashSet = new HashSet<HcPredicateSymbol>(((HCPredicate)iPredicate).getHcPredicateSymbols());
        IPredicate iPredicate3 = this.mPredicateFactory.and(new IPredicate[]{iPredicate, iPredicate2});
        if (this.mPredicateFactory.isDontCare(iPredicate3)) {
            return this.mPredicateFactory.newPredicate(hashSet, iPredicate3.getFormula(), Collections.emptyList(), Collections.emptyList());
        }
        Term term = new CommuhashNormalForm(this.mServices, this.mMgdScript.getScript()).transform(iPredicate3.getFormula());
        Set set = TermVarsFuns.findNonTheoryApplicationTerms((Term)term);
        List<FunctionSymbol> list = set.stream().map(ApplicationTerm::getFunction).collect(Collectors.toList());
        return this.mPredicateFactory.newPredicate(hashSet, term, Arrays.asList(iPredicate.getFormula().getFreeVars()), list);
    }

    public IPredicate merge(Collection<IPredicate> collection) {
        HashSet<HcPredicateSymbol> hashSet = new HashSet<HcPredicateSymbol>();
        collection.stream().filter((? super T iPredicate) -> iPredicate instanceof HCPredicate).forEach(iPredicate -> {
            boolean bl = hashSet.addAll(((HCPredicate)((Object)iPredicate)).getHcPredicateSymbols());
        });
        IPredicate iPredicate2 = this.mPredicateFactory.or(SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, collection);
        Term term = iPredicate2.getFormula();
        if (hashSet.isEmpty()) {
            return this.mPredicateFactory.newPredicate(term);
        }
        if (this.mPredicateFactory.isDontCare(term)) {
            return this.mPredicateFactory.newPredicate(hashSet, term, Collections.emptyList(), Collections.emptyList());
        }
        Set set = TermVarsFuns.findNonTheoryApplicationTerms((Term)term);
        List<FunctionSymbol> list = set.stream().map(ApplicationTerm::getFunction).collect(Collectors.toList());
        return this.mPredicateFactory.newPredicate(hashSet, term, Arrays.asList(term.getFreeVars()), list);
    }

    public IPredicate createEmptyStackState() {
        return this.createSinkStateContent();
    }

    private Term implicationStatement(IPredicate iPredicate, IPredicate iPredicate2) {
        return SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{iPredicate.getClosedFormula(), SmtUtils.not((Script)this.mMgdScript.getScript(), (Term)iPredicate2.getClosedFormula())});
    }

    private boolean implies(IPredicate iPredicate, IPredicate iPredicate2) {
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.push((Object)this, 1);
        Term term = this.implicationStatement(iPredicate, iPredicate2);
        this.mMgdScript.assertTerm((Object)this, term);
        Script.LBool lBool = this.mMgdScript.checkSat((Object)this);
        this.mMgdScript.pop((Object)this, 1);
        this.mMgdScript.unlock((Object)this);
        return lBool == Script.LBool.SAT;
    }

    private boolean implies2(IPredicate iPredicate, IPredicate iPredicate2) {
        return this.mPredicateUnifier.getCoverageRelation().getCoveredPredicates(iPredicate2).contains(iPredicate);
    }

    private Map<IPredicate, Set<IPredicate>> constructBaseGraph(Iterable<IPredicate> iterable) {
        IPredicate[] iPredicateArray = CombinatoricsUtils.iterateAll(iterable.iterator()).toArray(new IPredicate[0]);
        HashMap<IPredicate, Set<IPredicate>> hashMap = new HashMap<IPredicate, Set<IPredicate>>();
        int n = 0;
        while (n < iPredicateArray.length) {
            if (!hashMap.containsKey(iPredicateArray[n])) {
                hashMap.put(iPredicateArray[n], new HashSet());
            }
            int n2 = 0;
            while (n2 < iPredicateArray.length) {
                if (n != n2 && this.implies(iPredicateArray[n], iPredicateArray[n2])) {
                    ((Set)hashMap.get(iPredicateArray[n])).add(iPredicateArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    public SccComputation<IPredicate, StronglyConnectedComponent<IPredicate>> getImplicationGraph(Iterable<IPredicate> iterable) {
        return this.getImplicationGraph(this.constructBaseGraph(iterable));
    }

    public SccComputation<IPredicate, StronglyConnectedComponent<IPredicate>> getImplicationGraph(Map<IPredicate, Set<IPredicate>> map) {
        SccComputation.ISuccessorProvider iSuccessorProvider = iPredicate -> ((Set)map.get(iPredicate)).iterator();
        SccComputation sccComputation = new SccComputation(this.mLogger, iSuccessorProvider, (SccComputation.IStronglyConnectedComponentFactory)new DefaultStronglyConnectedComponentFactory(), map.size(), map.keySet());
        return sccComputation;
    }

    public Iterable<IPredicate> filterUnconditonally(Iterable<IPredicate> iterable) {
        SccComputation<IPredicate, StronglyConnectedComponent<IPredicate>> sccComputation = this.getImplicationGraph(iterable);
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (StronglyConnectedComponent stronglyConnectedComponent : sccComputation.getLeafComponents()) {
            hashSet.add((IPredicate)stronglyConnectedComponent.getRootNode());
        }
        return hashSet;
    }

    public Iterable<IPredicate> filter(Iterable<IPredicate> iterable) {
        if (this.mDummySemanticReduction) {
            return iterable;
        }
        return this.filterUnconditonally(iterable);
    }

    public Iterable<IPredicate> getOptimalDestination(Iterable<IPredicate> iterable, List<IPredicate> list, HornClause hornClause, Iterable<IPredicate> iterable2) {
        if (list.stream().anyMatch(arg_0 -> ((HCPredicateFactory)this.mPredicateFactory).isDontCare(arg_0))) {
            return Collections.singleton(this.mPredicateFactory.getDontCareLocationPredicate());
        }
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (IPredicate iPredicate : iterable) {
            if (this.mHoareTripleChecker.check(list, hornClause, iPredicate) != IncrementalPlicationChecker.Validity.VALID) continue;
            hashSet.add(iPredicate);
        }
        return this.filterUnconditonally(hashSet);
    }
}

