/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import java.util.LinkedHashMap;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTSimpleDeclaration;

public class FunctionTableBuilder
extends ASTVisitor {
    private final LinkedHashMap<String, IASTNode> mFunctionTable;
    private final FlatSymbolTable mSymTab;

    public FunctionTableBuilder(FlatSymbolTable flatSymbolTable) {
        this.shouldVisitDeclarations = true;
        this.mFunctionTable = new LinkedHashMap();
        this.mSymTab = flatSymbolTable;
    }

    public int visit(IASTDeclaration iASTDeclaration) {
        if (!(iASTDeclaration.getParent() instanceof IASTTranslationUnit)) {
            return super.visit(iASTDeclaration);
        }
        if (!iASTDeclaration.isPartOfTranslationUnitFile()) {
            return super.visit(iASTDeclaration);
        }
        if (iASTDeclaration instanceof CASTSimpleDeclaration) {
            CASTSimpleDeclaration cASTSimpleDeclaration = (CASTSimpleDeclaration)iASTDeclaration;
            IASTDeclarator[] iASTDeclaratorArray = cASTSimpleDeclaration.getDeclarators();
            int n = iASTDeclaratorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator iASTDeclarator = iASTDeclaratorArray[n2];
                String string = iASTDeclarator.getName().toString();
                String string2 = this.mSymTab.applyMultiparseRenaming(iASTDeclaration.getContainingFilename(), string);
                if (iASTDeclarator instanceof IASTFunctionDeclarator && !this.mFunctionTable.containsKey(string2)) {
                    this.mFunctionTable.put(string2, (IASTNode)iASTDeclarator);
                }
                ++n2;
            }
        } else if (iASTDeclaration instanceof IASTFunctionDefinition) {
            IASTFunctionDeclarator iASTFunctionDeclarator = ((IASTFunctionDefinition)iASTDeclaration).getDeclarator();
            while (iASTFunctionDeclarator.getNestedDeclarator() != null) {
                iASTFunctionDeclarator = iASTFunctionDeclarator.getNestedDeclarator();
            }
            String string = iASTFunctionDeclarator.getName().toString();
            String string3 = this.mSymTab.applyMultiparseRenaming(iASTDeclaration.getContainingFilename(), string);
            this.mFunctionTable.put(string3, (IASTNode)iASTDeclaration);
        }
        return super.visit(iASTDeclaration);
    }

    LinkedHashMap<String, IASTNode> getFunctionTable() {
        return this.mFunctionTable;
    }
}

