/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST;

import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.RelationalOperatorAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;

public class RelationalExpressionAST
extends AtsASTNode {
    private static final long serialVersionUID = -5806173754091876977L;
    private RelationalOperatorAST moperator;

    public RelationalOperatorAST getOperator() {
        return this.moperator;
    }

    public void setOperator(RelationalOperatorAST relationalOperatorAST) {
        this.moperator = relationalOperatorAST;
    }

    public RelationalExpressionAST(ILocation iLocation) {
        super(iLocation);
        this.mReturnType = Boolean.class;
        this.mExpectingType = Integer.class;
    }

    public String toString() {
        return "RelationalExpression [Operator: " + this.operatorToString(this.moperator) + "]";
    }

    private String operatorToString(RelationalOperatorAST relationalOperatorAST) {
        switch (relationalOperatorAST) {
            case LESSTHAN: {
                return " < ";
            }
            case LESS_EQ_THAN: {
                return " <= ";
            }
            case GREATERTHAN: {
                return " > ";
            }
            case GREATER_EQ_THAN: {
                return " >= ";
            }
            case EQ: {
                return " == ";
            }
            case NOT_EQ: {
                return " != ";
            }
        }
        return "";
    }

    public String getOperatorAsString() {
        return this.operatorToString(this.moperator);
    }

    @Override
    public String getAsString() {
        if (this.mChildren.size() == 2) {
            return ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString() + this.operatorToString(this.moperator) + ((AtsASTNode)((Object)this.mChildren.get(1))).getAsString();
        }
        return "";
    }
}

