/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import java.util.NoSuchElementException;

public class BidiMap<E> {
    private Entry<E>[] mIntTable;
    private Entry<E>[] mValTable;
    private int mSize = 0;
    private int mThreshold;
    private float mLoadFactor;
    private Entry<E> mLastEntry;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_SIZE = 8;
    public static final int MAXIMUM_CAPACITY = 0x40000000;

    private static int roundUpToPowerOf2(int n) {
        int n2;
        n2 = n >= 0x40000000 ? 0x40000000 : ((n2 = Integer.highestOneBit(n)) != 0 ? (Integer.bitCount(n) > 1 ? n2 << 1 : n2) : 1);
        return n2;
    }

    public BidiMap() {
        this(8, 0.75f);
    }

    public BidiMap(int n) {
        this(n, 0.75f);
    }

    public BidiMap(int n, float f) {
        this.mLoadFactor = f;
        this.init(BidiMap.roundUpToPowerOf2(n));
    }

    private void init(int n) {
        this.mIntTable = new Entry[n];
        this.mValTable = new Entry[n];
        this.mThreshold = (int)((float)n * this.mLoadFactor);
    }

    private final int hash(E e) {
        int n = 0;
        n ^= e.hashCode();
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private final int intBucketIdx(int n) {
        return n & this.mIntTable.length - 1;
    }

    private final int valBucketIdx(int n) {
        return n & this.mValTable.length - 1;
    }

    public boolean add(int n, E e) {
        int n2 = this.hash(e);
        Entry<E> entry = new Entry<E>(n, e, n2);
        if (this.canInsert(entry)) {
            this.mLastEntry = null;
            if (++this.mSize >= this.mThreshold) {
                this.grow();
            }
            this.insertInt(entry);
            this.insertVal(entry);
            return true;
        }
        this.mLastEntry = null;
        return false;
    }

    private void grow() {
        Entry<E> entry;
        Entry<E> entry2;
        int n = this.mIntTable.length << 1;
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        this.mThreshold = (int)((float)n * this.mLoadFactor);
        Entry<E>[] entryArray = this.mIntTable;
        Entry<E>[] entryArray2 = this.mValTable;
        this.mIntTable = new Entry[n];
        this.mValTable = new Entry[n];
        int n2 = 0;
        while (n2 < entryArray.length) {
            entry2 = entryArray[n2];
            while (entry2 != null) {
                entry = entry2;
                entry2 = entry2.mNextIdx;
                this.insertInt(entry);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < entryArray2.length) {
            entry2 = entryArray2[n2];
            while (entry2 != null) {
                entry = entry2;
                entry2 = entry2.mNextVal;
                this.insertVal(entry);
            }
            ++n2;
        }
    }

    private Entry<E> getEntryByIdx(int n) {
        int n2 = this.intBucketIdx(n);
        Entry<E> entry = this.mIntTable[n2];
        while (entry != null) {
            if (entry.mIdx == n) {
                this.mLastEntry = entry;
                return this.mLastEntry;
            }
            entry = entry.mNextIdx;
        }
        return null;
    }

    private Entry<E> getEntryByVal(E e) {
        int n = this.hash(e);
        int n2 = this.valBucketIdx(n);
        Entry<E> entry = this.mValTable[n2];
        while (entry != null) {
            if (entry.mHash == n && entry.mVal.equals(e)) {
                this.mLastEntry = entry;
                return this.mLastEntry;
            }
            entry = entry.mNextVal;
        }
        return null;
    }

    private boolean canInsert(Entry<E> entry) {
        return this.getEntryByIdx(entry.mIdx) == null && this.getEntryByVal(entry.mVal) == null;
    }

    private void insertInt(Entry<E> entry) {
        int n = this.intBucketIdx(entry.mIdx);
        entry.mNextIdx = this.mIntTable[n];
        this.mIntTable[n] = entry;
    }

    private void insertVal(Entry<E> entry) {
        int n = this.valBucketIdx(entry.mHash);
        entry.mNextVal = this.mValTable[n];
        this.mValTable[n] = entry;
    }

    public E get(int n) {
        if (this.mLastEntry != null && this.mLastEntry.mIdx == n) {
            return this.mLastEntry.getValue();
        }
        Entry<E> entry = this.getEntryByIdx(n);
        return entry == null ? null : (E)entry.getValue();
    }

    public int get(E e) {
        int n;
        if (this.mLastEntry != null && this.mLastEntry.mHash == (n = this.hash(e)) && this.mLastEntry.mVal.equals(e)) {
            return this.mLastEntry.getIdx();
        }
        Entry<E> entry = this.getEntryByVal(e);
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getIdx();
    }

    public boolean containsIdx(int n) {
        return this.getEntryByIdx(n) != null;
    }

    public boolean containsVal(E e) {
        return this.getEntryByVal(e) != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        Entry<E>[] entryArray = this.mIntTable;
        int n = this.mIntTable.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<E> entry;
            Entry<E> entry2 = entry = entryArray[n2];
            while (entry2 != null) {
                stringBuilder.append(entry2);
                entry2 = entry2.mNextIdx;
            }
            ++n2;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public int size() {
        return this.mSize;
    }

    private static class Entry<E> {
        final int mIdx;
        final E mVal;
        final int mHash;
        Entry<E> mNextIdx;
        Entry<E> mNextVal;

        public Entry(int n, E e, int n2) {
            this.mIdx = n;
            this.mVal = e;
            this.mHash = n2;
            this.mNextIdx = null;
            this.mNextVal = null;
        }

        public int getIdx() {
            return this.mIdx;
        }

        public E getValue() {
            return this.mVal;
        }

        public String toString() {
            return "[" + this.mIdx + "," + String.valueOf(this.mVal) + "]";
        }
    }
}

