/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.Interval;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;

public final class TermToInterval {
    private TermToInterval() {
    }

    public static Interval evaluate(Term term, Map<Term, Interval> map) {
        if (!term.getSort().isNumericSort()) {
            throw new IllegalArgumentException("Tried to use intervals for non-numeric sort: " + String.valueOf(term));
        }
        if (term instanceof ApplicationTerm) {
            return TermToInterval.evaluate((ApplicationTerm)term, map);
        }
        if (term instanceof LetTerm) {
            return TermToInterval.evaluate((LetTerm)term, map);
        }
        if (term instanceof AnnotatedTerm) {
            return TermToInterval.evaluate((AnnotatedTerm)term, map);
        }
        if (term instanceof QuantifiedFormula) {
            return TermToInterval.evaluate((QuantifiedFormula)term, map);
        }
        if (term instanceof ConstantTerm) {
            return TermToInterval.evaluate((ConstantTerm)term, map);
        }
        if (term instanceof TermVariable) {
            return TermToInterval.evaluate((TermVariable)term, map);
        }
        throw new UnsupportedOperationException("Could not process term of unknown type: " + String.valueOf(term));
    }

    private static Interval evaluate(ConstantTerm constantTerm, Map<Term, Interval> map) {
        Object object = constantTerm.getValue();
        if (object instanceof Rational) {
            return Interval.point((Rational)object);
        }
        if (object instanceof BigInteger) {
            return Interval.point(SmtUtils.toRational((BigInteger)((BigInteger)object)));
        }
        if (object instanceof BigDecimal) {
            return Interval.point(SmtUtils.toRational((BigDecimal)((BigDecimal)object)));
        }
        return Interval.TOP;
    }

    private static Interval evaluate(TermVariable termVariable, Map<Term, Interval> map) {
        return map.getOrDefault(termVariable, Interval.TOP);
    }

    private static Interval evaluate(AnnotatedTerm annotatedTerm, Map<Term, Interval> map) {
        return TermToInterval.evaluate(annotatedTerm.getSubterm(), map);
    }

    private static Interval evaluate(LetTerm letTerm, Map<Term, Interval> map) {
        HashMap<Term, Interval> hashMap = new HashMap<Term, Interval>(map);
        TermVariable[] termVariableArray = letTerm.getVariables();
        Term[] termArray = letTerm.getValues();
        assert (termVariableArray.length == termArray.length) : "Number of variables and values does not match: " + String.valueOf(letTerm);
        int n = 0;
        while (n < termVariableArray.length) {
            hashMap.put((Term)termVariableArray[n], TermToInterval.evaluate(termArray[n], map));
            ++n;
        }
        return TermToInterval.evaluate(letTerm.getSubTerm(), hashMap);
    }

    private static Interval evaluate(QuantifiedFormula quantifiedFormula, Map<Term, Interval> map) {
        throw new UnsupportedOperationException("Bool cannot be expressed as an interval.");
    }

    private static Interval evaluate(ApplicationTerm applicationTerm, Map<Term, Interval> map) {
        int n = applicationTerm.getParameters().length;
        if (n < 1) {
            return Interval.TOP;
        }
        if (n == 1) {
            return TermToInterval.handleUnaryFunction(applicationTerm, map);
        }
        return TermToInterval.handleGEq2AryFunction(applicationTerm, map);
    }

    private static Interval handleUnaryFunction(ApplicationTerm applicationTerm, Map<Term, Interval> map) {
        assert (applicationTerm.getParameters().length == 1) : "Expected unary function but found " + String.valueOf(applicationTerm);
        if (TermToInterval.isFunction("-", applicationTerm)) {
            Term term = applicationTerm.getParameters()[0];
            return TermToInterval.evaluate(term, map).negate();
        }
        return Interval.TOP;
    }

    private static Interval handleGEq2AryFunction(ApplicationTerm applicationTerm, Map<Term, Interval> map) {
        if (TermToInterval.isFunction("ite", applicationTerm)) {
            return TermToInterval.handleIfThenElseFunction(applicationTerm, map);
        }
        return TermToInterval.handleLeftAssociativeFunction(applicationTerm, map);
    }

    private static Interval handleIfThenElseFunction(ApplicationTerm applicationTerm, Map<Term, Interval> map) {
        Term[] termArray = applicationTerm.getParameters();
        assert (TermToInterval.isFunction("ite", applicationTerm)) : "Expected ite term but found " + String.valueOf(applicationTerm);
        assert (termArray.length == 3) : "Expected 3 parameters for ite term but found " + String.valueOf(applicationTerm);
        Interval interval = TermToInterval.evaluate(termArray[1], map);
        Interval interval2 = TermToInterval.evaluate(termArray[2], map);
        return interval.join(interval2);
    }

    private static boolean isFunction(String string, ApplicationTerm applicationTerm) {
        return string.equals(applicationTerm.getFunction().getName());
    }

    private static Interval handleLeftAssociativeFunction(ApplicationTerm applicationTerm, Map<Term, Interval> map) {
        BinaryOperator<Interval> binaryOperator = TermToInterval.intervalOpForSmtFunc(applicationTerm.getFunction().getName());
        if (binaryOperator == null) {
            return Interval.TOP;
        }
        Term[] termArray = applicationTerm.getParameters();
        assert (termArray.length >= 2) : "Expected n-ary function with n >= 2 but found " + String.valueOf(applicationTerm);
        Interval interval = TermToInterval.evaluate(termArray[0], map);
        int n = 1;
        while (n < termArray.length) {
            interval = (Interval)binaryOperator.apply(interval, TermToInterval.evaluate(termArray[n], map));
            ++n;
        }
        return interval;
    }

    private static BinaryOperator<Interval> intervalOpForSmtFunc(String string) {
        switch (string) {
            case "+": {
                return Interval::add;
            }
            case "-": {
                return Interval::subtract;
            }
            case "*": {
                return Interval::multiply;
            }
            case "/": {
                return Interval::divide;
            }
        }
        return null;
    }
}

