/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;

public final class CPrimitive
implements ICType {
    private final CPrimitives mType;
    private final boolean mIsAtomic;
    private final CPrimitiveCategory mGeneralType;

    private CPrimitive(CPrimitives cPrimitives, boolean bl) {
        this.mType = cPrimitives;
        this.mGeneralType = CPrimitive.getGeneralType(cPrimitives);
        this.mIsAtomic = bl;
    }

    public CPrimitive(CPrimitives cPrimitives) {
        this(cPrimitives, false);
    }

    public static CPrimitive constructAtomicType(CPrimitives cPrimitives) {
        return new CPrimitive(cPrimitives, true);
    }

    public CPrimitive(IASTDeclSpecifier iASTDeclSpecifier) {
        if (!(iASTDeclSpecifier instanceof IASTSimpleDeclSpecifier)) {
            throw new IllegalArgumentException("Unknown C Declaration!");
        }
        this.mType = CPrimitive.getType(iASTDeclSpecifier);
        this.mGeneralType = CPrimitive.getGeneralType(this.mType);
        this.mIsAtomic = CTranslationUtil.hasAttribute(iASTDeclSpecifier, "atomic");
    }

    private static CPrimitives getType(IASTDeclSpecifier iASTDeclSpecifier) {
        IASTSimpleDeclSpecifier iASTSimpleDeclSpecifier = (IASTSimpleDeclSpecifier)iASTDeclSpecifier;
        switch (iASTSimpleDeclSpecifier.getType()) {
            case 6: {
                return CPrimitives.BOOL;
            }
            case 2: {
                if (iASTSimpleDeclSpecifier.isSigned()) {
                    return CPrimitives.SCHAR;
                }
                if (iASTSimpleDeclSpecifier.isUnsigned()) {
                    return CPrimitives.UCHAR;
                }
                return CPrimitives.CHAR;
            }
            case 5: {
                if (iASTSimpleDeclSpecifier.isComplex()) {
                    return iASTSimpleDeclSpecifier.isLong() ? CPrimitives.COMPLEX_LONGDOUBLE : CPrimitives.COMPLEX_DOUBLE;
                }
                if (iASTSimpleDeclSpecifier.isLong()) {
                    return CPrimitives.LONGDOUBLE;
                }
                return CPrimitives.DOUBLE;
            }
            case 4: {
                return iASTSimpleDeclSpecifier.isComplex() ? CPrimitives.COMPLEX_FLOAT : CPrimitives.FLOAT;
            }
            case 3: {
                if (iASTSimpleDeclSpecifier.isUnsigned()) {
                    if (iASTSimpleDeclSpecifier.isLong()) {
                        return CPrimitives.ULONG;
                    }
                    if (iASTSimpleDeclSpecifier.isLongLong()) {
                        return CPrimitives.ULONGLONG;
                    }
                    if (iASTSimpleDeclSpecifier.isShort()) {
                        return CPrimitives.USHORT;
                    }
                    return CPrimitives.UINT;
                }
                if (iASTSimpleDeclSpecifier.isLong()) {
                    return CPrimitives.LONG;
                }
                if (iASTSimpleDeclSpecifier.isLongLong()) {
                    return CPrimitives.LONGLONG;
                }
                if (iASTSimpleDeclSpecifier.isShort()) {
                    return CPrimitives.SHORT;
                }
                return CPrimitives.INT;
            }
            case 0: {
                if (iASTSimpleDeclSpecifier.isUnsigned()) {
                    if (iASTSimpleDeclSpecifier.isLong()) {
                        return CPrimitives.ULONG;
                    }
                    if (iASTSimpleDeclSpecifier.isLongLong()) {
                        return CPrimitives.ULONGLONG;
                    }
                    if (iASTSimpleDeclSpecifier.isShort()) {
                        return CPrimitives.USHORT;
                    }
                    return CPrimitives.UINT;
                }
                if (iASTSimpleDeclSpecifier.isLong()) {
                    return CPrimitives.LONG;
                }
                if (iASTSimpleDeclSpecifier.isLongLong()) {
                    return CPrimitives.LONGLONG;
                }
                if (iASTSimpleDeclSpecifier.isShort()) {
                    return CPrimitives.SHORT;
                }
                return CPrimitives.INT;
            }
            case 13: {
                return iASTSimpleDeclSpecifier.isUnsigned() ? CPrimitives.UINT128 : CPrimitives.INT128;
            }
            case 14: {
                if (iASTSimpleDeclSpecifier.isComplex()) {
                    throw new UnsupportedOperationException("Complex 128bit floats are not supported yet.");
                }
                return CPrimitives.FLOAT128;
            }
            case 1: {
                return CPrimitives.VOID;
            }
        }
        throw new IllegalArgumentException("Unknown C Declaration!");
    }

    private static CPrimitiveCategory getGeneralType(CPrimitives cPrimitives) throws AssertionError {
        return switch (cPrimitives) {
            case CPrimitives.FLOAT, CPrimitives.FLOAT128, CPrimitives.COMPLEX_FLOAT, CPrimitives.DOUBLE, CPrimitives.COMPLEX_DOUBLE, CPrimitives.LONGDOUBLE, CPrimitives.COMPLEX_LONGDOUBLE -> CPrimitiveCategory.FLOATTYPE;
            case CPrimitives.CHAR, CPrimitives.SCHAR, CPrimitives.UCHAR, CPrimitives.SHORT, CPrimitives.USHORT, CPrimitives.INT, CPrimitives.UINT, CPrimitives.LONG, CPrimitives.ULONG, CPrimitives.LONGLONG, CPrimitives.ULONGLONG, CPrimitives.INT128, CPrimitives.UINT128, CPrimitives.BOOL -> CPrimitiveCategory.INTTYPE;
            case CPrimitives.VOID -> CPrimitiveCategory.VOID;
            default -> throw new MatchException(null, null);
        };
    }

    public CPrimitives getType() {
        return this.mType;
    }

    public CPrimitiveCategory getGeneralType() {
        return this.mGeneralType;
    }

    @Override
    public String toString() {
        return this.mType.toString();
    }

    @Override
    public boolean isIncomplete() {
        return this.mType == CPrimitives.VOID;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.mGeneralType, this.mIsAtomic, this.mType});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CPrimitive cPrimitive = (CPrimitive)object;
        return this.mGeneralType == cPrimitive.mGeneralType && this.mIsAtomic == cPrimitive.mIsAtomic && this.mType == cPrimitive.mType;
    }

    @Override
    public boolean isAtomic() {
        return this.mIsAtomic;
    }

    @Override
    public boolean isIntegerType() {
        return this.mGeneralType == CPrimitiveCategory.INTTYPE;
    }

    @Override
    public boolean isRealFloatingType() {
        return List.of(CPrimitives.FLOAT, CPrimitives.DOUBLE, CPrimitives.LONGDOUBLE).contains((Object)this.mType);
    }

    @Override
    public boolean isComplexType() {
        return List.of(CPrimitives.COMPLEX_FLOAT, CPrimitives.COMPLEX_DOUBLE, CPrimitives.COMPLEX_LONGDOUBLE).contains((Object)this.mType);
    }

    @Override
    public boolean isFloatingType() {
        return this.mGeneralType == CPrimitiveCategory.FLOATTYPE;
    }

    @Override
    public boolean isVoidType() {
        return this.mType == CPrimitives.VOID;
    }

    public static enum CPrimitiveCategory {
        INTTYPE,
        FLOATTYPE,
        VOID;

    }

    public static enum CPrimitives {
        CHAR(CPrimitiveCategory.INTTYPE, "char"),
        SCHAR(CPrimitiveCategory.INTTYPE, "signed char"),
        UCHAR(CPrimitiveCategory.INTTYPE, "unsigned char"),
        SHORT(CPrimitiveCategory.INTTYPE, "short"),
        USHORT(CPrimitiveCategory.INTTYPE, "unsigned short"),
        INT(CPrimitiveCategory.INTTYPE, "int"),
        UINT(CPrimitiveCategory.INTTYPE, "unsigned"),
        LONG(CPrimitiveCategory.INTTYPE, "long"),
        ULONG(CPrimitiveCategory.INTTYPE, "unsigned long"),
        LONGLONG(CPrimitiveCategory.INTTYPE, "long long"),
        ULONGLONG(CPrimitiveCategory.INTTYPE, "unsigned long long"),
        INT128(CPrimitiveCategory.INTTYPE, "__int128"),
        UINT128(CPrimitiveCategory.INTTYPE, "unsigned __int128"),
        BOOL(CPrimitiveCategory.INTTYPE, "_Bool"),
        FLOAT(CPrimitiveCategory.FLOATTYPE, "float"),
        FLOAT128(CPrimitiveCategory.FLOATTYPE, "__float128"),
        COMPLEX_FLOAT(CPrimitiveCategory.FLOATTYPE, "_Complex float"),
        DOUBLE(CPrimitiveCategory.FLOATTYPE, "double"),
        COMPLEX_DOUBLE(CPrimitiveCategory.FLOATTYPE, "_Complex double"),
        LONGDOUBLE(CPrimitiveCategory.FLOATTYPE, "long double"),
        COMPLEX_LONGDOUBLE(CPrimitiveCategory.FLOATTYPE, "_Complex long double"),
        VOID(CPrimitiveCategory.VOID, "void");

        private final CPrimitiveCategory mPrimitiveCategory;
        private final String mTypeName;

        private CPrimitives(CPrimitiveCategory cPrimitiveCategory, String string2) {
            this.mPrimitiveCategory = cPrimitiveCategory;
            this.mTypeName = string2;
        }

        public boolean isIntegertype() {
            return this.mPrimitiveCategory == CPrimitiveCategory.INTTYPE;
        }

        public boolean isFloatingtype() {
            return this.mPrimitiveCategory == CPrimitiveCategory.FLOATTYPE;
        }

        public CPrimitiveCategory getPrimitiveCategory() {
            return this.mPrimitiveCategory;
        }

        public String getTypeName() {
            return this.mTypeName;
        }
    }
}

