/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit.BaseExplicitValueValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit.ExplicitValueBottom;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit.ExplicitValueTop;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;

public class ExplicitValueValue
extends BaseExplicitValueValue {
    private final Rational mValue;

    public ExplicitValueValue(Rational rational) {
        assert (rational != null);
        this.mValue = rational;
    }

    @Override
    public BaseExplicitValueValue copy() {
        return this;
    }

    @Override
    public boolean isBottom() {
        return false;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public BaseExplicitValueValue intersect(BaseExplicitValueValue baseExplicitValueValue) {
        return this.commutativeOp(baseExplicitValueValue, baseExplicitValueValue::intersect, explicitValueValue -> {
            if (explicitValueValue.mValue.equals((Object)this.mValue)) {
                return this;
            }
            return ExplicitValueBottom.DEFAULT;
        });
    }

    @Override
    public BaseExplicitValueValue merge(BaseExplicitValueValue baseExplicitValueValue) {
        return this.commutativeOp(baseExplicitValueValue, baseExplicitValueValue::merge, explicitValueValue -> {
            if (explicitValueValue.mValue.equals((Object)this.mValue)) {
                return this;
            }
            return ExplicitValueTop.DEFAULT;
        });
    }

    @Override
    public Collection<BaseExplicitValueValue> complement() {
        return Collections.singleton(ExplicitValueTop.DEFAULT);
    }

    @Override
    public Collection<BaseExplicitValueValue> complementInteger() {
        return Collections.singleton(ExplicitValueTop.DEFAULT);
    }

    @Override
    public boolean isAbstractionEqual(BaseExplicitValueValue baseExplicitValueValue) {
        return this.commutativeOp(baseExplicitValueValue, baseExplicitValueValue::isAbstractionEqual, explicitValueValue -> explicitValueValue.mValue.equals((Object)this.mValue));
    }

    @Override
    public boolean isContainedIn(BaseExplicitValueValue baseExplicitValueValue) {
        if (baseExplicitValueValue.isTop()) {
            return true;
        }
        if (baseExplicitValueValue.isBottom()) {
            return false;
        }
        return this.isAbstractionEqual(baseExplicitValueValue);
    }

    @Override
    public BaseExplicitValueValue add(BaseExplicitValueValue baseExplicitValueValue) {
        return this.commutativeOp(baseExplicitValueValue, baseExplicitValueValue::add, explicitValueValue -> new ExplicitValueValue(this.mValue.add(explicitValueValue.mValue)));
    }

    @Override
    public BaseExplicitValueValue subtract(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonical(baseExplicitValueValue, explicitValueValue -> new ExplicitValueValue(this.mValue.sub(explicitValueValue.mValue)));
    }

    @Override
    public BaseExplicitValueValue multiply(BaseExplicitValueValue baseExplicitValueValue) {
        return this.commutativeOp(baseExplicitValueValue, baseExplicitValueValue::multiply, explicitValueValue -> new ExplicitValueValue(this.mValue.mul(explicitValueValue.mValue)));
    }

    @Override
    public BaseExplicitValueValue negate() {
        return new ExplicitValueValue(this.mValue.negate());
    }

    @Override
    public BaseExplicitValueValue divideInteger(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonical(baseExplicitValueValue, explicitValueValue -> new ExplicitValueValue(AbsIntUtil.euclideanDivision(this.mValue, explicitValueValue.mValue)));
    }

    @Override
    public BaseExplicitValueValue divideReal(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonical(baseExplicitValueValue, explicitValueValue -> new ExplicitValueValue(this.mValue.div(explicitValueValue.mValue)));
    }

    @Override
    public BaseExplicitValueValue modulo(BaseExplicitValueValue baseExplicitValueValue) {
        if (baseExplicitValueValue.isTop()) {
            return baseExplicitValueValue;
        }
        if (baseExplicitValueValue.isBottom()) {
            return baseExplicitValueValue;
        }
        ExplicitValueValue explicitValueValue = (ExplicitValueValue)baseExplicitValueValue;
        return new ExplicitValueValue(AbsIntUtil.euclideanModulo(this.mValue, explicitValueValue.mValue));
    }

    @Override
    public BaseExplicitValueValue greaterThan(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonical(baseExplicitValueValue, this::greaterThan);
    }

    @Override
    public BaseExplicitValueValue greaterThan(ExplicitValueValue explicitValueValue2) {
        return ExplicitValueValue.nonCommutativeOpCanonical(explicitValueValue2, explicitValueValue -> this.mValue.compareTo(explicitValueValue.mValue) > 0 ? this : ExplicitValueBottom.DEFAULT);
    }

    @Override
    public BooleanValue isEqual(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonicalBoolean(baseExplicitValueValue, explicitValueValue -> this.mValue.equals((Object)explicitValueValue.mValue) ? BooleanValue.TRUE : BooleanValue.FALSE);
    }

    @Override
    public BooleanValue isNotEqual(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonicalBoolean(baseExplicitValueValue, explicitValueValue -> this.mValue.equals((Object)explicitValueValue.mValue) ? BooleanValue.FALSE : BooleanValue.TRUE);
    }

    @Override
    public BooleanValue isGreaterThan(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonicalBoolean(baseExplicitValueValue, explicitValueValue -> this.mValue.compareTo(explicitValueValue.mValue) > 0 ? BooleanValue.TRUE : BooleanValue.FALSE);
    }

    @Override
    public BaseExplicitValueValue greaterOrEqual(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonical(baseExplicitValueValue, explicitValueValue -> this.mValue.compareTo(explicitValueValue.mValue) >= 0 ? this : ExplicitValueBottom.DEFAULT);
    }

    @Override
    public BooleanValue isGreaterOrEqual(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonicalBoolean(baseExplicitValueValue, explicitValueValue -> this.mValue.compareTo(explicitValueValue.mValue) >= 0 ? BooleanValue.TRUE : BooleanValue.FALSE);
    }

    @Override
    public BaseExplicitValueValue lessThan(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonical(baseExplicitValueValue, explicitValueValue -> this.mValue.compareTo(explicitValueValue.mValue) < 0 ? this : ExplicitValueBottom.DEFAULT);
    }

    @Override
    public BooleanValue isLessThan(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonicalBoolean(baseExplicitValueValue, explicitValueValue -> this.mValue.compareTo(explicitValueValue.mValue) < 0 ? BooleanValue.TRUE : BooleanValue.FALSE);
    }

    @Override
    public BaseExplicitValueValue lessOrEqual(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonical(baseExplicitValueValue, explicitValueValue -> this.mValue.compareTo(explicitValueValue.mValue) <= 0 ? this : ExplicitValueBottom.DEFAULT);
    }

    @Override
    public BooleanValue isLessOrEqual(BaseExplicitValueValue baseExplicitValueValue) {
        return ExplicitValueValue.nonCommutativeOpCanonicalBoolean(baseExplicitValueValue, explicitValueValue -> this.mValue.compareTo(explicitValueValue.mValue) <= 0 ? BooleanValue.TRUE : BooleanValue.FALSE);
    }

    @Override
    public BaseExplicitValueValue inverseModulo(BaseExplicitValueValue baseExplicitValueValue, BaseExplicitValueValue baseExplicitValueValue2, boolean bl) {
        return baseExplicitValueValue2;
    }

    @Override
    public BaseExplicitValueValue inverseEquality(BaseExplicitValueValue baseExplicitValueValue, BaseExplicitValueValue baseExplicitValueValue2) {
        return baseExplicitValueValue2;
    }

    @Override
    public BaseExplicitValueValue inverseLessOrEqual(BaseExplicitValueValue baseExplicitValueValue, boolean bl) {
        return baseExplicitValueValue;
    }

    @Override
    public BaseExplicitValueValue inverseLessThan(BaseExplicitValueValue baseExplicitValueValue, boolean bl) {
        return baseExplicitValueValue;
    }

    @Override
    public BaseExplicitValueValue inverseGreaterOrEqual(BaseExplicitValueValue baseExplicitValueValue, boolean bl) {
        return baseExplicitValueValue;
    }

    @Override
    public BaseExplicitValueValue inverseGreaterThan(BaseExplicitValueValue baseExplicitValueValue, boolean bl) {
        return baseExplicitValueValue;
    }

    @Override
    public BaseExplicitValueValue inverseNotEqual(BaseExplicitValueValue baseExplicitValueValue, BaseExplicitValueValue baseExplicitValueValue2) {
        return baseExplicitValueValue;
    }

    @Override
    public Term getTerm(Script script, Sort sort, Term term) {
        return script.term("=", new Term[]{term, SmtUtils.rational2Term((Script)script, (Rational)this.mValue, (Sort)sort)});
    }

    private <T> T commutativeOp(BaseExplicitValueValue baseExplicitValueValue, Function<BaseExplicitValueValue, T> function, Function<ExplicitValueValue, T> function2) {
        if (baseExplicitValueValue instanceof ExplicitValueValue) {
            ExplicitValueValue explicitValueValue = (ExplicitValueValue)baseExplicitValueValue;
            return function2.apply(explicitValueValue);
        }
        return function.apply(this);
    }

    private static <T> T nonCommutativeOp(BaseExplicitValueValue baseExplicitValueValue, Function<BaseExplicitValueValue, T> function, Function<BaseExplicitValueValue, T> function2, Function<ExplicitValueValue, T> function3) {
        if (baseExplicitValueValue.isTop()) {
            return function2.apply(baseExplicitValueValue);
        }
        if (baseExplicitValueValue.isBottom()) {
            return function.apply(baseExplicitValueValue);
        }
        ExplicitValueValue explicitValueValue = (ExplicitValueValue)baseExplicitValueValue;
        return function3.apply(explicitValueValue);
    }

    private static BaseExplicitValueValue nonCommutativeOpCanonical(BaseExplicitValueValue baseExplicitValueValue, Function<ExplicitValueValue, BaseExplicitValueValue> function) {
        if (baseExplicitValueValue.isTop()) {
            return ExplicitValueTop.DEFAULT;
        }
        if (baseExplicitValueValue.isBottom()) {
            return ExplicitValueBottom.DEFAULT;
        }
        ExplicitValueValue explicitValueValue = (ExplicitValueValue)baseExplicitValueValue;
        return function.apply(explicitValueValue);
    }

    private static BooleanValue nonCommutativeOpCanonicalBoolean(BaseExplicitValueValue baseExplicitValueValue, Function<ExplicitValueValue, BooleanValue> function) {
        if (baseExplicitValueValue.isTop()) {
            return BooleanValue.TOP;
        }
        if (baseExplicitValueValue.isBottom()) {
            return BooleanValue.BOTTOM;
        }
        ExplicitValueValue explicitValueValue = (ExplicitValueValue)baseExplicitValueValue;
        return function.apply(explicitValueValue);
    }

    public String toString() {
        return this.mValue.toString();
    }
}

