/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex;

import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Concatenation;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.EmptySet;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Epsilon;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegexVisitor;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Literal;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Star;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Union;

public class RegexToTgf<L>
implements IRegexVisitor<L, RegexToTgf<L>, Void> {
    protected int mNextNodeId;
    protected final StringBuilder mNodeList = new StringBuilder();
    protected final StringBuilder mEdgeList = new StringBuilder();

    protected int addNode(String string) {
        this.mNodeList.append(this.mNextNodeId).append(' ').append(string).append('\n');
        return this.mNextNodeId++;
    }

    protected void addLeftEdge(int n, int n2) {
        this.addEdge(n, n2, "0");
    }

    protected void addRightEdge(int n, int n2) {
        this.addEdge(n, n2, "1");
    }

    protected void addEdge(int n, int n2, String string) {
        this.mEdgeList.append(n).append(' ').append(n2).append(' ').append(string).append('\n');
    }

    @Override
    public RegexToTgf<L> visit(Union<L> union, Void void_) {
        int n = this.addNode("\u222a");
        this.addLeftEdge(n, this.mNextNodeId);
        union.getFirst().accept(this);
        this.addRightEdge(n, this.mNextNodeId);
        union.getSecond().accept(this);
        return this;
    }

    @Override
    public RegexToTgf<L> visit(Concatenation<L> concatenation, Void void_) {
        int n = this.addNode("\u00b7");
        this.addLeftEdge(n, this.mNextNodeId);
        concatenation.getFirst().accept(this);
        this.addRightEdge(n, this.mNextNodeId);
        concatenation.getSecond().accept(this);
        return this;
    }

    @Override
    public RegexToTgf<L> visit(Star<L> star, Void void_) {
        int n = this.addNode("*");
        this.addLeftEdge(n, this.mNextNodeId);
        star.getInner().accept(this);
        return this;
    }

    @Override
    public RegexToTgf<L> visit(Literal<L> literal, Void void_) {
        this.addNode(literal.getLetter().toString());
        return this;
    }

    @Override
    public RegexToTgf<L> visit(Epsilon<L> epsilon, Void void_) {
        this.addNode("\u03b5");
        return this;
    }

    @Override
    public RegexToTgf<L> visit(EmptySet<L> emptySet, Void void_) {
        this.addNode("\u2205");
        return this;
    }

    public String toString() {
        return String.valueOf(this.mNodeList) + "#\n" + String.valueOf(this.mEdgeList);
    }
}

