/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression;

public class LTLPrettyPrinter
extends ACSLVisitor {
    private static final String GET_STRING = "getString(";
    private static final String NOT_IMPLEMENTED = ") not implemented";
    private static final String STRING_AND = "&";
    private static final String STRING_MINUS = "-";
    private static final String STRING_TIMES = "*";
    private static final String STRING_PLUS = "+";
    private static final char BLANK = ' ';
    private static final char PARENTHESIS_CLOSE = ')';
    private static final char PARENTHESIS_OPEN = '(';
    protected StringBuilder mBuilder;

    public String print(ACSLNode aCSLNode) {
        this.mBuilder = new StringBuilder();
        aCSLNode.accept(this);
        return this.mBuilder.toString();
    }

    @Override
    public boolean visit(BinaryExpression binaryExpression) {
        this.mBuilder.append('(');
        binaryExpression.getLeft().accept(this);
        this.mBuilder.append(' ').append(LTLPrettyPrinter.getString(binaryExpression.getOperator())).append(' ');
        binaryExpression.getRight().accept(this);
        this.mBuilder.append(')');
        return false;
    }

    @Override
    public boolean visit(UnaryExpression unaryExpression) {
        this.mBuilder.append(LTLPrettyPrinter.getString(unaryExpression.getOperator())).append('(');
        unaryExpression.getExpr().accept(this);
        this.mBuilder.append(')');
        return false;
    }

    @Override
    public boolean visit(BooleanLiteral booleanLiteral) {
        this.mBuilder.append(booleanLiteral.getValue());
        return super.visit(booleanLiteral);
    }

    @Override
    public boolean visit(IdentifierExpression identifierExpression) {
        this.mBuilder.append(identifierExpression.getIdentifier());
        return super.visit(identifierExpression);
    }

    @Override
    public boolean visit(IntegerLiteral integerLiteral) {
        this.mBuilder.append(integerLiteral.getValue());
        return super.visit(integerLiteral);
    }

    @Override
    public boolean visit(RealLiteral realLiteral) {
        this.mBuilder.append(realLiteral.getValue());
        return super.visit(realLiteral);
    }

    private static String getString(UnaryExpression.Operator operator) {
        return switch (operator) {
            case UnaryExpression.Operator.ADDROF -> STRING_AND;
            case UnaryExpression.Operator.LOGICNEG -> "!";
            case UnaryExpression.Operator.LTLFINALLY -> "F";
            case UnaryExpression.Operator.LTLGLOBALLY -> "G";
            case UnaryExpression.Operator.LTLNEXT -> "X";
            case UnaryExpression.Operator.MINUS -> STRING_MINUS;
            case UnaryExpression.Operator.PLUS -> STRING_PLUS;
            case UnaryExpression.Operator.POINTER -> STRING_TIMES;
            case UnaryExpression.Operator.LOGICCOMPLEMENT -> throw new UnsupportedOperationException(GET_STRING + String.valueOf((Object)operator) + NOT_IMPLEMENTED);
            default -> throw new MatchException(null, null);
        };
    }

    private static String getString(BinaryExpression.Operator operator) {
        return switch (operator) {
            case BinaryExpression.Operator.ARITHDIV -> "/";
            case BinaryExpression.Operator.ARITHMINUS -> STRING_MINUS;
            case BinaryExpression.Operator.ARITHMOD -> "%";
            case BinaryExpression.Operator.ARITHMUL -> STRING_TIMES;
            case BinaryExpression.Operator.ARITHPLUS -> STRING_PLUS;
            case BinaryExpression.Operator.BITAND -> STRING_AND;
            case BinaryExpression.Operator.BITIFF -> "<-->";
            case BinaryExpression.Operator.BITIMPLIES -> "-->";
            case BinaryExpression.Operator.BITOR -> "|";
            case BinaryExpression.Operator.COMPEQ -> "==";
            case BinaryExpression.Operator.COMPGEQ -> ">=";
            case BinaryExpression.Operator.COMPGT -> ">";
            case BinaryExpression.Operator.COMPLEQ -> "<=";
            case BinaryExpression.Operator.COMPLT -> "<";
            case BinaryExpression.Operator.COMPNEQ -> "!=";
            case BinaryExpression.Operator.LOGICAND -> "&&";
            case BinaryExpression.Operator.LOGICIFF -> "<==>";
            case BinaryExpression.Operator.LOGICIMPLIES -> "==>";
            case BinaryExpression.Operator.LOGICOR -> "||";
            case BinaryExpression.Operator.LTLUNTIL -> "U";
            case BinaryExpression.Operator.LTLRELEASE -> "R";
            case BinaryExpression.Operator.LTLWEAKUNTIL -> "WU";
            case BinaryExpression.Operator.LOGICXOR, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.BITXOR, BinaryExpression.Operator.BITSHIFTLEFT, BinaryExpression.Operator.BITSHIFTRIGHT -> throw new UnsupportedOperationException(GET_STRING + String.valueOf((Object)operator) + NOT_IMPLEMENTED);
            default -> throw new MatchException(null, null);
        };
    }
}

