/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprEqualityPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseDpllLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.UnitPropagationData;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackDecisionLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackEntry;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackGroundLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.DecideStackPropagatedLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.GroundPropagationInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EprDecideStack {
    private final EprTheory mEprTheory;
    private final ArrayList<DecideStackEntry> mStack = new ArrayList();
    private final ScopedArrayList<EprClause> mClauses = new ScopedArrayList();
    private final ScopedHashSet<EprPredicate> mAllEprPredicates = new ScopedHashSet();
    private final ScopedArrayList<EprEqualityPredicate> mEprEqualities = new ScopedArrayList();

    public EprDecideStack(EprTheory eprTheory) {
        this.mEprTheory = eprTheory;
    }

    public void pushEntry(DecideStackEntry decideStackEntry) {
        this.mStack.add(decideStackEntry);
        decideStackEntry.push(this);
    }

    public int findLiteralOnStack(Literal literal) {
        int n = this.mStack.size();
        while (n > 0) {
            DecideStackEntry decideStackEntry;
            if (!((decideStackEntry = this.mStack.get(--n)) instanceof DecideStackGroundLiteral) || ((DecideStackGroundLiteral)decideStackEntry).getLiteral() != literal) continue;
            return n;
        }
        return this.mStack.size();
    }

    public void backtrackToLiteral(Literal literal) {
        int n = this.findLiteralOnStack(literal);
        int n2 = this.mStack.size() - 1;
        while (n2 >= n) {
            this.mStack.remove(n2).pop(this);
            --n2;
        }
    }

    void explainConflict(Map<EprPredicate, HashSet<DawgState<ApplicationTerm, EprTheory.TriBool>>> map, List<Literal> list) {
    }

    void resolveConflictOrUnit(EprClause eprClause, ClauseLiteral clauseLiteral, DawgState<ApplicationTerm, Boolean> dawgState, Set<Literal> set, Map<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> map) {
        List<DawgLetter<ApplicationTerm>> list = DawgFactory.getOneWord(dawgState);
        ApplicationTerm[] applicationTermArray = new ApplicationTerm[list.size()];
        int n = 0;
        while (n < list.size()) {
            applicationTermArray[n] = list.get(n).isComplemented() ? null : list.get(n).getLetters().iterator().next();
            ++n;
        }
        for (ClauseLiteral clauseLiteral2 : eprClause.getLiterals()) {
            if (clauseLiteral2 instanceof ClauseDpllLiteral) {
                set.add(((ClauseDpllLiteral)clauseLiteral2).getLiteral());
                continue;
            }
            if (clauseLiteral2 == clauseLiteral) continue;
            ClauseEprLiteral clauseEprLiteral = (ClauseEprLiteral)clauseLiteral2;
            ApplicationTerm[] applicationTermArray2 = clauseEprLiteral.getInstantiatedArguments(applicationTermArray);
            Pair<EprPredicate, Boolean> pair = new Pair<EprPredicate, Boolean>(clauseEprLiteral.getEprPredicate(), clauseEprLiteral.getPolarity());
            Set<List<ApplicationTerm>> set2 = map.get(pair);
            if (set2 == null) {
                set2 = new HashSet<List<ApplicationTerm>>();
                map.put(pair, set2);
            }
            set2.add(Arrays.asList(applicationTermArray2));
        }
    }

    Clause explain(Set<Literal> set, Map<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> map, int n) {
        while (!map.isEmpty()) {
            Object object;
            Object object2;
            Pair<Object, Boolean> pair;
            Set<List<ApplicationTerm>> set2;
            Object object3;
            DecideStackEntry decideStackEntry;
            if ((decideStackEntry = this.mStack.get(--n)) instanceof DecideStackGroundLiteral) {
                object3 = ((DecideStackGroundLiteral)decideStackEntry).getLiteral();
                if (!(((Literal)object3).getAtom() instanceof EprGroundPredicateAtom) || (set2 = map.get(pair = new Pair<Object, Boolean>(object2 = ((EprPredicateAtom)(object = (EprGroundPredicateAtom)((Literal)object3).getAtom())).getEprPredicate(), object != object3))) == null || !set2.remove(((EprGroundPredicateAtom)object).getArgumentsAsWord())) continue;
                set.add(((Literal)object3).negate());
                if (!set2.isEmpty()) continue;
                map.remove(pair);
                continue;
            }
            if (decideStackEntry instanceof DecideStackPropagatedLiteral) {
                Collection<Object> collection;
                object3 = (DecideStackPropagatedLiteral)decideStackEntry;
                object = ((DecideStackLiteral)object3).getOldDawg();
                object2 = ((DecideStackPropagatedLiteral)object3).getReasonClauseLit();
                pair = new Pair<EprPredicate, Boolean>(((ClauseEprLiteral)object2).getEprPredicate(), !((ClauseLiteral)object2).getPolarity());
                set2 = map.remove(pair);
                if (set2 == null) continue;
                Iterator<List<ApplicationTerm>> iterator = set2.iterator();
                while (iterator.hasNext()) {
                    collection = iterator.next();
                    if (((DawgState)object).getValue(collection) != EprTheory.TriBool.UNKNOWN) continue;
                    assert (((DecideStackLiteral)object3).getDawg().getValue((List<ApplicationTerm>)collection) == (((ClauseLiteral)object2).getPolarity() ? EprTheory.TriBool.TRUE : EprTheory.TriBool.FALSE));
                    iterator.remove();
                    DawgState<Object, Boolean> dawgState = this.mEprTheory.getDawgFactory().createSingletonSet(((ClauseEprLiteral)object2).getEprPredicate().getTermVariablesForArguments(), (List<ApplicationTerm>)collection);
                    DawgState<ApplicationTerm, Boolean> dawgState2 = ((ClauseEprLiteral)object2).litDawg2clauseDawg(dawgState);
                    dawgState2 = this.mEprTheory.getDawgFactory().createIntersection(((DecideStackPropagatedLiteral)object3).getClauseDawg(), dawgState2);
                    this.resolveConflictOrUnit(((ClauseLiteral)object2).getClause(), (ClauseLiteral)object2, dawgState2, set, map);
                }
                collection = map.get(pair);
                if (collection != null) {
                    collection.addAll(set2);
                    continue;
                }
                if (set2.isEmpty()) continue;
                map.put(pair, set2);
                continue;
            }
            throw new AssertionError();
        }
        return new Clause(set.toArray(new Literal[set.size()]));
    }

    Clause explainUnitLiteralOrConflict(EprClause eprClause, ClauseEprLiteral clauseEprLiteral, DawgState<ApplicationTerm, Boolean> dawgState) {
        HashSet<Literal> hashSet = new HashSet<Literal>();
        HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> hashMap = new HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>>();
        this.resolveConflictOrUnit(eprClause, clauseEprLiteral, dawgState, hashSet, hashMap);
        return this.explain(hashSet, hashMap, this.mStack.size());
    }

    Clause explainIrreflexivity(EprEqualityPredicate eprEqualityPredicate, DawgState<ApplicationTerm, Boolean> dawgState) {
        HashSet<Literal> hashSet = new HashSet<Literal>();
        HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> hashMap = new HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>>();
        List<DawgLetter<ApplicationTerm>> list = DawgFactory.getOneWord(dawgState);
        ApplicationTerm[] applicationTermArray = new ApplicationTerm[list.size()];
        int n = 0;
        while (n < list.size()) {
            applicationTermArray[n] = list.get(n).isComplemented() ? null : list.get(n).getLetters().iterator().next();
            ++n;
        }
        HashSet<List<ApplicationTerm>> hashSet2 = new HashSet<List<ApplicationTerm>>();
        hashSet2.add(Arrays.asList(applicationTermArray));
        hashMap.put(new Pair<EprEqualityPredicate, Boolean>(eprEqualityPredicate, Boolean.TRUE), hashSet2);
        return this.explain(hashSet, hashMap, this.mStack.size());
    }

    public Clause explainGroundUnit(Literal literal) {
        EprGroundPredicateAtom eprGroundPredicateAtom = (EprGroundPredicateAtom)literal.getAtom();
        HashSet<Literal> hashSet = new HashSet<Literal>();
        HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> hashMap = new HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>>();
        hashSet.add(literal);
        HashSet<List<ApplicationTerm>> hashSet2 = new HashSet<List<ApplicationTerm>>();
        hashSet2.add(eprGroundPredicateAtom.getArgumentsAsWord());
        hashMap.put(new Pair<EprPredicate, Boolean>(eprGroundPredicateAtom.getEprPredicate(), literal != eprGroundPredicateAtom), hashSet2);
        return this.explain(hashSet, hashMap, this.findLiteralOnStack(literal));
    }

    public Clause explainGroundUnit(Literal literal, GroundPropagationInfo groundPropagationInfo) {
        if (groundPropagationInfo == null) {
            return this.explainGroundUnit(literal);
        }
        HashSet<Literal> hashSet = new HashSet<Literal>();
        HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>> hashMap = new HashMap<Pair<EprPredicate, Boolean>, Set<List<ApplicationTerm>>>();
        ClauseDpllLiteral clauseDpllLiteral = groundPropagationInfo.getReasonClauseLit();
        this.resolveConflictOrUnit(clauseDpllLiteral.getClause(), clauseDpllLiteral, groundPropagationInfo.getClauseDawg(), hashSet, hashMap);
        return this.explain(hashSet, hashMap, groundPropagationInfo.getStackDepth());
    }

    public Clause setGroundEquality(CCEquality cCEquality, boolean bl) {
        return null;
    }

    public Clause setEprGroundLiteral(Literal literal) {
        EprGroundPredicateAtom eprGroundPredicateAtom = (EprGroundPredicateAtom)literal.getAtom();
        EprPredicate eprPredicate = eprGroundPredicateAtom.getEprPredicate();
        if (eprPredicate.getDawg().getValue(eprGroundPredicateAtom.getArgumentsAsWord()) == (literal == eprGroundPredicateAtom ? EprTheory.TriBool.FALSE : EprTheory.TriBool.TRUE)) {
            return this.explainGroundUnit(literal.negate());
        }
        DecideStackGroundLiteral decideStackGroundLiteral = new DecideStackGroundLiteral(literal);
        this.pushEntry(decideStackGroundLiteral);
        return null;
    }

    public Clause doPropagations() {
        boolean bl = true;
        boolean bl2 = false;
        while (bl) {
            Object object;
            bl = false;
            for (EprEqualityPredicate eprEqualityPredicate : this.mEprEqualities) {
                object = eprEqualityPredicate.getIrreflexivity();
                if (DawgFactory.isEmpty(object)) continue;
                return this.explainIrreflexivity(eprEqualityPredicate, (DawgState<ApplicationTerm, Boolean>)object);
            }
            for (EprClause eprClause : this.mClauses) {
                if (eprClause.isConflict()) {
                    object = eprClause.getConflictPoints();
                    return this.explainUnitLiteralOrConflict(eprClause, null, (DawgState<ApplicationTerm, Boolean>)object);
                }
                if (!eprClause.isUnit()) continue;
                object = eprClause.getUnitPropagationData();
                for (DecideStackEntry decideStackEntry : ((UnitPropagationData)object).getQuantifiedPropagations()) {
                    this.mEprTheory.getLogger().debug("EPR Propagating: %s", decideStackEntry);
                    this.pushEntry(decideStackEntry);
                    bl = true;
                }
                for (GroundPropagationInfo groundPropagationInfo : ((UnitPropagationData)object).getGroundPropagations()) {
                    groundPropagationInfo.setStackDepth(this.mStack.size());
                    this.mEprTheory.addGroundLiteralToPropagate(groundPropagationInfo.getReasonClauseLit().getLiteral(), groundPropagationInfo);
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            return null;
        }
        for (EprPredicate eprPredicate : this.mAllEprPredicates) {
            for (Object object : eprPredicate.getDPLLAtoms()) {
                if (((DPLLAtom)object).getDecideStatus() != null || eprPredicate.getDawg().getValue(((EprGroundPredicateAtom)object).getArgumentsAsWord()) == EprTheory.TriBool.UNKNOWN) continue;
                Object object2 = eprPredicate.getDawg().getValue(((EprGroundPredicateAtom)object).getArgumentsAsWord()) == EprTheory.TriBool.TRUE ? object : ((Literal)object).negate();
                this.mEprTheory.addGroundLiteralToPropagate((Literal)object2, null);
            }
        }
        return null;
    }

    private DecideStackDecisionLiteral decide() {
        for (EprClause eprClause : this.mClauses) {
            DawgState<ApplicationTerm, Boolean> dawgState = eprClause.getUndecidedPoints();
            if (DawgFactory.isEmpty(dawgState)) continue;
            for (ClauseLiteral clauseLiteral : eprClause.getLiterals()) {
                DawgState<ApplicationTerm, Boolean> dawgState2;
                if (clauseLiteral instanceof ClauseDpllLiteral) {
                    assert (clauseLiteral.getLiteral().getAtom().getDecideStatus() == clauseLiteral.getLiteral().negate());
                    continue;
                }
                ClauseEprLiteral clauseEprLiteral = (ClauseEprLiteral)clauseLiteral;
                if (clauseEprLiteral.getEprPredicate() instanceof EprEqualityPredicate && !clauseEprLiteral.getPolarity() || DawgFactory.isEmpty(dawgState2 = this.mEprTheory.getDawgFactory().createProduct(dawgState, clauseEprLiteral.getDawg(), (bl, triBool) -> bl != false && triBool == EprTheory.TriBool.UNKNOWN))) continue;
                DawgState<ApplicationTerm, Boolean> dawgState3 = clauseEprLiteral.clauseDawg2litDawg(dawgState2);
                EprTheory.TriBool triBool2 = clauseEprLiteral.getPolarity() ? EprTheory.TriBool.TRUE : EprTheory.TriBool.FALSE;
                DawgState<ApplicationTerm, EprTheory.TriBool> dawgState4 = this.mEprTheory.getDawgFactory().createMapped(dawgState3, bl -> bl != false ? triBool2 : EprTheory.TriBool.UNKNOWN);
                return new DecideStackDecisionLiteral(clauseEprLiteral.getEprPredicate(), dawgState4);
            }
        }
        return null;
    }

    public Clause eprDpllLoop() {
        DecideStackDecisionLiteral decideStackDecisionLiteral;
        while ((decideStackDecisionLiteral = this.decide()) != null) {
            this.pushEntry(decideStackDecisionLiteral);
            this.doPropagations();
        }
        return null;
    }

    public Clause createEprClause(Set<Literal> set) {
        EprClause eprClause = this.mEprTheory.getEprClauseFactory().getEprClause(set);
        this.mEprTheory.getLogger().debug("EPRDEBUG: (EprClauseManager) creating new EprClause: " + String.valueOf(eprClause));
        this.mClauses.add(eprClause);
        return null;
    }

    public void addNewEprPredicate(EprPredicate eprPredicate) {
        if (eprPredicate instanceof EprEqualityPredicate) {
            this.mEprEqualities.add((EprEqualityPredicate)eprPredicate);
        }
        this.mAllEprPredicates.add((Object)eprPredicate);
    }

    public void push() {
        this.mClauses.beginScope();
        this.mAllEprPredicates.beginScope();
        this.mEprEqualities.beginScope();
    }

    public void pop() {
        this.mClauses.endScope();
        this.mAllEprPredicates.endScope();
        this.mEprEqualities.endScope();
    }
}

