/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SMTFeatureExtractionTermClassifier
extends NonRecursive {
    private Set<Term> mTermsInWhichWeAlreadyDescended;
    private final Map<String, Integer> mOccuringSortNames = new HashMap<String, Integer>();
    private final Map<String, Integer> mOccuringFunctionNames = new HashMap<String, Integer>();
    private final Map<Integer, Integer> mOccuringQuantifiers = new HashMap<Integer, Integer>();
    private boolean mHasArrays = false;
    private int mNumberOfArrays = 0;
    private int mNumberOfVariables = 0;
    private int mNumberOfFunctions = 0;
    private int mNumberOfQuantifiers = 0;
    private int mDAGSize = 0;
    private long mTreeSize = 0L;
    private final UnionFind<Term> mVariableEquivalenceClasses;
    private Map<Integer, Set<Term>> mTermsets;
    private int mBiggestEquivalenceClass = 0;
    private final ArrayList<String> mAssertionStack = new ArrayList();
    private final Map<Term, Integer> mVariableToCount;

    public SMTFeatureExtractionTermClassifier() {
        this.mVariableEquivalenceClasses = new UnionFind();
        this.mTermsets = new HashMap<Integer, Set<Term>>();
        this.mVariableToCount = new HashMap<Term, Integer>();
    }

    public void checkTerm(Term term) {
        this.mTermsInWhichWeAlreadyDescended = new HashSet<Term>();
        this.mAssertionStack.add(term.toString());
        this.mDAGSize += new DAGSize().size(term);
        this.mTreeSize += new DAGSize().treesize(term);
        this.run((NonRecursive.Walker)new MyWalker(term));
        this.mTermsInWhichWeAlreadyDescended = null;
    }

    public int getDAGSize() {
        return this.mDAGSize;
    }

    public int getNumberOfFunctions() {
        return this.mNumberOfFunctions;
    }

    public int getNumberOfQuantifiers() {
        return this.mNumberOfQuantifiers;
    }

    public int getNumberOfVariables() {
        return this.mNumberOfVariables;
    }

    public int getNumberOfArrays() {
        return this.mNumberOfArrays;
    }

    public Map<String, Integer> getOccuringFunctionNames() {
        return this.mOccuringFunctionNames;
    }

    public Map<Integer, Integer> getOccuringQuantifiers() {
        return this.mOccuringQuantifiers;
    }

    public Map<String, Integer> getOccuringSortNames() {
        return this.mOccuringSortNames;
    }

    public ArrayList<Integer> getVariableEquivalenceClassSizes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.mVariableEquivalenceClasses.getAllEquivalenceClasses().forEach(set -> arrayList.add(set.size()));
        return arrayList;
    }

    public int getBiggestEquivalenceClass() {
        return this.mBiggestEquivalenceClass;
    }

    public ArrayList<String> getAssertionStack() {
        return this.mAssertionStack;
    }

    public long getTreeSize() {
        return this.mTreeSize;
    }

    public boolean hasArrays() {
        return this.mHasArrays;
    }

    public int getDependencyScore() {
        return this.calcDependencyScore();
    }

    public UnionFind<Term> getEquivalenceClasses() {
        return this.mVariableEquivalenceClasses;
    }

    public static double normalize(double d, double d2, double d3) {
        double d4 = 1.0 - 1.0 / (d != 0.0 ? d : 1.0);
        double d5 = d3 - d2;
        return d4 * d5 + d2;
    }

    public double getScore(ScoringMethod scoringMethod) {
        int n2 = 0;
        if (scoringMethod == ScoringMethod.DEPENDENCY) {
            n2 = this.getDependencyScore();
        } else if (scoringMethod == ScoringMethod.NUM_FUNCTIONS) {
            n2 = this.getNumberOfFunctions();
        } else if (scoringMethod == ScoringMethod.NUM_VARIABLES) {
            n2 = this.getNumberOfVariables();
        } else if (scoringMethod == ScoringMethod.DAGSIZE) {
            n2 = this.getDAGSize();
        } else if (scoringMethod == ScoringMethod.BIGGEST_EQUIVALENCE_CLASS) {
            n2 = this.getBiggestEquivalenceClass();
        } else if (scoringMethod == ScoringMethod.AVERAGE_EQUIVALENCE_CLASS) {
            n2 = (int)this.getVariableEquivalenceClassSizes().stream().mapToInt(n -> n).average().orElse(0.0);
        } else if (scoringMethod == ScoringMethod.NUMBER_OF_EQUIVALENCE_CLASSES) {
            n2 = this.getVariableEquivalenceClassSizes().size();
        } else if (scoringMethod == ScoringMethod.NUMBER_OF_SELECT_FUNCTIONS) {
            n2 = this.getOccuringFunctionNames().getOrDefault("select", 0);
        } else if (scoringMethod == ScoringMethod.NUMBER_OF_STORE_FUNCTIONS) {
            n2 = this.getOccuringFunctionNames().getOrDefault("store", 0);
        } else if (scoringMethod == ScoringMethod.COMPARE_FEATURES) {
            n2 = 1;
        }
        return SMTFeatureExtractionTermClassifier.normalize(n2, 0.5, 1.0);
    }

    private static boolean isApplicationTermWithArityZero(Term term) {
        ApplicationTerm applicationTerm;
        return term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getParameters().length == 0;
    }

    private int calcDependencyScore() {
        int n = 0;
        for (Set set : this.mVariableEquivalenceClasses.getAllEquivalenceClasses()) {
            int n2 = set.size();
            if (n2 > this.mBiggestEquivalenceClass) {
                this.mBiggestEquivalenceClass = n2;
            }
            n = (int)((double)n + Math.pow(n2, 2.0));
        }
        return n;
    }

    private class MyWalker
    extends NonRecursive.TermWalker {
        MyWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive nonRecursive) {
            if (!SMTFeatureExtractionTermClassifier.this.mTermsInWhichWeAlreadyDescended.contains(this.getTerm())) {
                Term term = this.getTerm();
                if (!term.toStringDirect().equals("true") && !term.toStringDirect().equals("false") && (term instanceof TermVariable || SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term))) {
                    Sort sort = term.getSort();
                    String string = term.getSort().toString();
                    if (SMTFeatureExtractionTermClassifier.this.mOccuringSortNames.containsKey(string)) {
                        SMTFeatureExtractionTermClassifier.this.mOccuringSortNames.put(string, SMTFeatureExtractionTermClassifier.this.mOccuringSortNames.get(string) + 1);
                    } else {
                        SMTFeatureExtractionTermClassifier.this.mOccuringSortNames.put(string, 1);
                    }
                    if (sort.isArraySort()) {
                        SMTFeatureExtractionTermClassifier.this.mHasArrays = true;
                        ++SMTFeatureExtractionTermClassifier.this.mNumberOfArrays;
                    }
                }
                super.walk(nonRecursive);
            }
        }

        public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
            SMTFeatureExtractionTermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)annotatedTerm);
            nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(annotatedTerm.getSubterm()));
        }

        private void createAndAddToTermset(int n, Term ... termArray) {
            HashSet<Term> hashSet = new HashSet<Term>(Arrays.asList(termArray));
            hashSet.addAll(SMTFeatureExtractionTermClassifier.this.mTermsets.getOrDefault(n, Collections.emptySet()));
            SMTFeatureExtractionTermClassifier.this.mTermsets.put(n, hashSet);
        }

        private void collectVariables(ApplicationTerm applicationTerm, String string, int n) {
            Term[] termArray = applicationTerm.getParameters();
            if (termArray.length == 1) {
                this.createAndAddToTermset(n, termArray[0]);
            }
            int n2 = 0;
            while (n2 < termArray.length - 1) {
                Term term = termArray[n2];
                Term term2 = termArray[n2 + 1];
                if ((SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term) || term instanceof TermVariable) && (SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term2) || term2 instanceof TermVariable)) {
                    if (string.equals("or")) {
                        this.createAndAddToTermset(n, term);
                        this.createAndAddToTermset(SMTFeatureExtractionTermClassifier.this.mTermsets.size() + 1, term2);
                    } else {
                        this.createAndAddToTermset(n, term, term2);
                    }
                } else if (SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term) && term2 instanceof ConstantTerm) {
                    this.createAndAddToTermset(n, term);
                } else if (SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term2) && term instanceof ConstantTerm) {
                    this.createAndAddToTermset(n, term2);
                } else if (SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term) || term instanceof TermVariable) {
                    this.createAndAddToTermset(n, term);
                    int n3 = var8_8 = string.equals("or") ? SMTFeatureExtractionTermClassifier.this.mTermsets.size() + 1 : n;
                    if (term2 instanceof ApplicationTerm) {
                        this.collectVariables((ApplicationTerm)term2, ((ApplicationTerm)term2).getFunction().getName(), var8_8);
                    }
                } else if (SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term2) || term2 instanceof TermVariable) {
                    this.createAndAddToTermset(n, term2);
                    int n4 = var8_8 = string.equals("or") ? SMTFeatureExtractionTermClassifier.this.mTermsets.size() + 1 : n;
                    if (term instanceof ApplicationTerm) {
                        this.collectVariables((ApplicationTerm)term, ((ApplicationTerm)term).getFunction().getName(), var8_8);
                    }
                } else if (term instanceof ApplicationTerm && term2 instanceof ApplicationTerm) {
                    this.collectVariables((ApplicationTerm)term, ((ApplicationTerm)term).getFunction().getName(), n);
                    var8_8 = string.equals("or") ? SMTFeatureExtractionTermClassifier.this.mTermsets.size() + 1 : n;
                    this.collectVariables((ApplicationTerm)term2, ((ApplicationTerm)term2).getFunction().getName(), var8_8);
                }
                ++n2;
            }
        }

        public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
            String string;
            if (applicationTerm.getParameters().length > 0) {
                string = applicationTerm.getFunction().getName();
                if (SMTFeatureExtractionTermClassifier.this.mOccuringFunctionNames.containsKey(string)) {
                    SMTFeatureExtractionTermClassifier.this.mOccuringFunctionNames.put(string, SMTFeatureExtractionTermClassifier.this.mOccuringFunctionNames.get(string) + 1);
                } else {
                    SMTFeatureExtractionTermClassifier.this.mOccuringFunctionNames.put(string, 1);
                }
                SMTFeatureExtractionTermClassifier.this.mTermsets = new HashMap<Integer, Set<Term>>();
                this.collectVariables(applicationTerm, string, 0);
                SMTFeatureExtractionTermClassifier.this.mTermsets.forEach((n, set) -> {
                    set.forEach(term -> SMTFeatureExtractionTermClassifier.this.mVariableEquivalenceClasses.findAndConstructEquivalenceClassIfNeeded(term));
                    SMTFeatureExtractionTermClassifier.this.mVariableEquivalenceClasses.union((Collection)set);
                });
                ++SMTFeatureExtractionTermClassifier.this.mNumberOfFunctions;
            } else {
                ++SMTFeatureExtractionTermClassifier.this.mNumberOfVariables;
            }
            SMTFeatureExtractionTermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)applicationTerm);
            Term[] termArray = applicationTerm.getParameters();
            int n2 = termArray.length;
            int n3 = 0;
            while (n3 < n2) {
                string = termArray[n3];
                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker((Term)string));
                ++n3;
            }
        }

        public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
        }

        public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
            SMTFeatureExtractionTermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)letTerm);
            nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(letTerm.getSubTerm()));
            Term[] termArray = letTerm.getValues();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term));
                ++n2;
            }
        }

        public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
            int n = quantifiedFormula.getQuantifier();
            if (SMTFeatureExtractionTermClassifier.this.mOccuringQuantifiers.containsKey(quantifiedFormula.getQuantifier())) {
                SMTFeatureExtractionTermClassifier.this.mOccuringQuantifiers.put(n, SMTFeatureExtractionTermClassifier.this.mOccuringQuantifiers.get(n) + 1);
            } else {
                SMTFeatureExtractionTermClassifier.this.mOccuringQuantifiers.put(n, 1);
            }
            ++SMTFeatureExtractionTermClassifier.this.mNumberOfQuantifiers;
            nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(quantifiedFormula.getSubformula()));
        }

        public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
            if (SMTFeatureExtractionTermClassifier.this.mVariableToCount.containsKey(termVariable)) {
                SMTFeatureExtractionTermClassifier.this.mVariableToCount.put((Term)termVariable, SMTFeatureExtractionTermClassifier.this.mVariableToCount.get(termVariable) + 1);
            } else {
                SMTFeatureExtractionTermClassifier.this.mVariableToCount.put((Term)termVariable, 1);
                ++SMTFeatureExtractionTermClassifier.this.mNumberOfVariables;
            }
        }

        public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
            throw new UnsupportedOperationException();
        }
    }

    public static enum ScoringMethod {
        NUM_FUNCTIONS,
        NUM_VARIABLES,
        DAGSIZE,
        DEPENDENCY,
        BIGGEST_EQUIVALENCE_CLASS,
        AVERAGE_EQUIVALENCE_CLASS,
        NUMBER_OF_EQUIVALENCE_CLASSES,
        NUMBER_OF_SELECT_FUNCTIONS,
        NUMBER_OF_STORE_FUNCTIONS,
        COMPARE_FEATURES;

    }
}

