/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc;

import de.uni_freiburg.informatik.ultimate.lib.chc.HcHeadVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ChcPreMetaInfoProvider {
    private final HcSymbolTable mSymbolTable;
    private final List<HornClause> mHornClausesRaw;
    private final HashRelation<HcPredicateSymbol, HornClause> mHornClausesSorted;
    private final Set<HcPredicateSymbol> mAllReachablePredSymbols;
    private final Set<HcHeadVar> mAllHeadHcVars;
    private final Set<HcVar> mAllBodyHcVars;
    private final List<HcHeadVar> mAllHeadHcVarsAsList;
    private final List<HcVar> mAllBodyHcVarsAsList;

    public ChcPreMetaInfoProvider(List<HornClause> list, HcSymbolTable hcSymbolTable) {
        this.mHornClausesRaw = list;
        this.mSymbolTable = hcSymbolTable;
        this.mHornClausesSorted = this.sortHornClausesByHeads(list);
        this.mAllReachablePredSymbols = new LinkedHashSet<HcPredicateSymbol>();
        this.mAllHeadHcVars = new LinkedHashSet<HcHeadVar>();
        this.mAllBodyHcVars = new LinkedHashSet<HcVar>();
        this.mAllHeadHcVarsAsList = new ArrayList<HcHeadVar>();
        this.mAllBodyHcVarsAsList = new ArrayList<HcVar>();
        this.compute();
    }

    private void compute() {
        ArrayDeque<HcPredicateSymbol> arrayDeque = new ArrayDeque<HcPredicateSymbol>();
        HashSet<HcPredicateSymbol> hashSet = new HashSet<HcPredicateSymbol>();
        arrayDeque.push(this.mSymbolTable.getFalseHornClausePredicateSymbol());
        hashSet.add(this.mSymbolTable.getFalseHornClausePredicateSymbol());
        while (!arrayDeque.isEmpty()) {
            HcPredicateSymbol hcPredicateSymbol = (HcPredicateSymbol)arrayDeque.pop();
            this.mAllReachablePredSymbols.add(hcPredicateSymbol);
            this.mAllHeadHcVars.addAll(this.mSymbolTable.getHcHeadVarsForPredSym(hcPredicateSymbol, true));
            Set set = this.mHornClausesSorted.getImage((Object)hcPredicateSymbol);
            for (HornClause hornClause : set) {
                this.mAllBodyHcVars.addAll(hornClause.getBodyVariables());
                for (HcPredicateSymbol hcPredicateSymbol2 : hornClause.getBodyPredicates()) {
                    if (hashSet.contains(hcPredicateSymbol2)) continue;
                    arrayDeque.push(hcPredicateSymbol2);
                    hashSet.add(hcPredicateSymbol2);
                }
            }
        }
        this.mAllHeadHcVarsAsList.addAll(this.mAllHeadHcVars);
        this.mAllBodyHcVarsAsList.addAll(this.mAllBodyHcVars);
    }

    private HashRelation<HcPredicateSymbol, HornClause> sortHornClausesByHeads(List<HornClause> list) {
        HashRelation hashRelation = new HashRelation();
        for (HornClause hornClause : list) {
            if (hornClause.isHeadFalse()) {
                hashRelation.addPair((Object)this.mSymbolTable.getFalseHornClausePredicateSymbol(), (Object)hornClause);
                continue;
            }
            hashRelation.addPair((Object)hornClause.getHeadPredicate(), (Object)hornClause);
        }
        return hashRelation;
    }

    public HashRelation<HcPredicateSymbol, HornClause> getHornClausesSorted() {
        return this.mHornClausesSorted;
    }

    public List<HcHeadVar> getAllHeadHcVarsAsList() {
        return Collections.unmodifiableList(this.mAllHeadHcVarsAsList);
    }

    public List<HcVar> getAllBodyHcVarsAsList() {
        return Collections.unmodifiableList(this.mAllBodyHcVarsAsList);
    }

    public Set<HcPredicateSymbol> getAllReachablePredSymbols() {
        return this.mAllReachablePredSymbols;
    }
}

