/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import java.util.Arrays;

public class FloatFunction {
    private static final String GCC_PREFIX = "__";
    private static final String[] FLOAT_FUNCTIONS = new String[]{"fpclassify", "isfinite", "finite", "isinf", "isnan", "isnormal", "signbit", "sqrt", "fabs", "fmin", "fmax", "trunc", "round", "lround", "llround", "floor", "ceil", "sin", "remainder", "copysign", "fmod", "fdim"};
    private static final String[] TYPE_SUFFIXES = new String[]{"f", "d", "l"};
    private final String mPrefix;
    private final String mFunction;
    private final String mTypeSuffix;

    public FloatFunction(String string, String string2, String string3) {
        this.mPrefix = string;
        this.mFunction = string2;
        this.mTypeSuffix = string3;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getFunctionName() {
        return this.mFunction;
    }

    public String getTypeSuffix() {
        return this.mTypeSuffix;
    }

    public CPrimitive getType() {
        switch (this.mTypeSuffix) {
            case "f": {
                return new CPrimitive(CPrimitive.CPrimitives.FLOAT);
            }
            case "": 
            case "d": {
                return new CPrimitive(CPrimitive.CPrimitives.DOUBLE);
            }
            case "l": {
                return new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE);
            }
        }
        throw new AssertionError((Object)("unknown type suffix " + this.mTypeSuffix));
    }

    public static FloatFunction decode(String string) {
        String string2;
        String string3;
        String string4;
        if (string.startsWith(GCC_PREFIX)) {
            string4 = string.substring(2);
            string3 = GCC_PREFIX;
        } else {
            string4 = string;
            string3 = "";
        }
        String string5 = FloatFunction.returnFirstMatching(string4);
        if (string5 == null) {
            return null;
        }
        String string6 = string4.substring(string5.length());
        if (string6.isEmpty()) {
            string2 = "";
        } else if (Arrays.asList(TYPE_SUFFIXES).contains(string6)) {
            string2 = string6;
        } else {
            return null;
        }
        return new FloatFunction(string3, string5, string2);
    }

    private static String returnFirstMatching(String string) {
        String[] stringArray = FLOAT_FUNCTIONS;
        int n = FLOAT_FUNCTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string.startsWith(string2)) {
                return string2;
            }
            ++n2;
        }
        return null;
    }
}

