/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class LinuxLibraryModel
implements ILibraryModel {
    private final FunctionModelHelper mHelper;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final TypeSizes mTypeSizes;
    private final ExpressionTranslation mExpressionTranslation;

    public LinuxLibraryModel(FunctionModelHelper functionModelHelper, AuxVarInfoBuilder auxVarInfoBuilder, ExpressionResultTransformer expressionResultTransformer, TypeSizes typeSizes, ExpressionTranslation expressionTranslation) {
        this.mHelper = functionModelHelper;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mTypeSizes = typeSizes;
        this.mExpressionTranslation = expressionTranslation;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        return List.of(new ILibraryModel.FunctionModel("sleep", this::handleSleep), new ILibraryModel.FunctionModel("htonl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.UINT))), new ILibraryModel.FunctionModel("htons", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.USHORT))), new ILibraryModel.FunctionModel("ntohl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.UINT))), new ILibraryModel.FunctionModel("ntohs", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.USHORT))), new ILibraryModel.FunctionModel("ffs", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFfs(iDispatcher, iASTFunctionCallExpression, iLocation, string, CPrimitive.CPrimitives.INT)), new ILibraryModel.FunctionModel("ffsl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFfs(iDispatcher, iASTFunctionCallExpression, iLocation, string, CPrimitive.CPrimitives.LONG)), new ILibraryModel.FunctionModel("ffsll", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFfs(iDispatcher, iASTFunctionCallExpression, iLocation, string, CPrimitive.CPrimitives.LONGLONG)));
    }

    private Result handleSleep(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[0]));
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.UINT);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo).setLrValue(new RValue((Expression)auxVarInfo.getExp(), cPrimitive));
        return expressionResultBuilder.addOverapprox(new Overapprox(string, iLocation)).build();
    }

    private Result handleFfs(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive.CPrimitives cPrimitives) {
        Object object;
        IdentifierExpression identifierExpression;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        int n = this.mTypeSizes.getSize(cPrimitives);
        CPrimitive cPrimitive2 = new CPrimitive(cPrimitives);
        if (cPrimitive2.equals(cPrimitive)) {
            identifierExpression = auxVarInfo.getExp();
        } else {
            assert (n >= this.mTypeSizes.getSize(cPrimitive.getType())) : "expected argument larger than INT";
            object = this.mExpressionTranslation.convertIntToInt(iLocation, new ExpressionResult(new RValue((Expression)auxVarInfo.getExp(), cPrimitive)), cPrimitive2);
            expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object);
            identifierExpression = ((ExpressionResult)object).getLrValue().getValue();
        }
        object = this.mExpressionTranslation.constructZero(iLocation, cPrimitive2);
        Expression expression = this.mExpressionTranslation.constructBinaryEqualityExpression(iLocation, 28, expressionResult.getLrValue().getValue(), cPrimitive2, (Expression)object, cPrimitive2);
        Object object2 = this.mExpressionTranslation.constructZero(iLocation, cPrimitive);
        Expression expression2 = this.mExpressionTranslation.constructBinaryEqualityExpression(iLocation, 28, (Expression)auxVarInfo.getExp(), cPrimitive, (Expression)object2, cPrimitive);
        AssumeStatement[] assumeStatementArray = new AssumeStatement[]{new AssumeStatement(iLocation, expression2)};
        object2 = new ArrayList();
        expression2 = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive2, BigInteger.ONE);
        Expression expression3 = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive2, BigInteger.valueOf((long)n * 8L));
        Expression expression4 = ExpressionFactory.and((ILocation)iLocation, List.of(this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 10, expression2, cPrimitive2, (Expression)identifierExpression, cPrimitive2), this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 10, (Expression)identifierExpression, cPrimitive2, expression3, cPrimitive2)));
        ((ArrayList)object2).add(new AssumeStatement(iLocation, expression4));
        Expression expression5 = this.mExpressionTranslation.constructUnaryExpression(iLocation, 6, (Expression)object, cPrimitive2);
        ExpressionResult expressionResult2 = this.mExpressionTranslation.handleBinaryBitwiseExpression(iLocation, 6, this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive2, BigInteger.ONE), cPrimitive2, this.mExpressionTranslation.constructArithmeticIntegerExpression(iLocation, 5, (Expression)identifierExpression, cPrimitive2, expression2, cPrimitive2), cPrimitive2, this.mAuxVarInfoBuilder);
        expressionResultBuilder.addAllExceptLrValueAndStatements(expressionResult2);
        ((ArrayList)object2).addAll(expressionResult2.getStatements());
        ExpressionResult expressionResult3 = this.mExpressionTranslation.handleBinaryBitwiseExpression(iLocation, 12, expressionResult.getLrValue().getValue(), cPrimitive2, expressionResult2.getLrValue().getValue(), cPrimitive2, this.mAuxVarInfoBuilder);
        expressionResultBuilder.addAllExceptLrValueAndStatements(expressionResult3);
        ((ArrayList)object2).addAll(expressionResult3.getStatements());
        Expression expression6 = this.mExpressionTranslation.constructBinaryEqualityExpression(iLocation, 29, (Expression)object, cPrimitive2, expressionResult3.getLrValue().getValue(), cPrimitive2);
        ((ArrayList)object2).add(new AssumeStatement(iLocation, expression6));
        ExpressionResult expressionResult4 = this.mExpressionTranslation.handleBinaryBitwiseExpression(iLocation, 7, expression5, this.mTypeSizes.getCorrespondingUnsignedType(cPrimitive2), this.mExpressionTranslation.constructArithmeticIntegerExpression(iLocation, 5, expression3, cPrimitive2, this.mExpressionTranslation.constructArithmeticIntegerExpression(iLocation, 5, (Expression)identifierExpression, cPrimitive2, expression2, cPrimitive2), cPrimitive2), this.mTypeSizes.getCorrespondingUnsignedType(cPrimitive2), this.mAuxVarInfoBuilder);
        expressionResultBuilder.addAllExceptLrValueAndStatements(expressionResult4);
        ((ArrayList)object2).addAll(expressionResult4.getStatements());
        ExpressionResult expressionResult5 = this.mExpressionTranslation.handleBinaryBitwiseExpression(iLocation, 12, expressionResult.getLrValue().getValue(), cPrimitive2, expressionResult4.getLrValue().getValue(), cPrimitive2, this.mAuxVarInfoBuilder);
        expressionResultBuilder.addAllExceptLrValueAndStatements(expressionResult5);
        ((ArrayList)object2).addAll(expressionResult5.getStatements());
        Expression expression7 = this.mExpressionTranslation.constructBinaryEqualityExpression(iLocation, 28, (Expression)object, cPrimitive2, expressionResult5.getLrValue().getValue(), cPrimitive2);
        ((ArrayList)object2).add(new AssumeStatement(iLocation, expression7));
        Statement[] statementArray = (Statement[])object2.toArray(Statement[]::new);
        expressionResultBuilder.addStatement((Statement)new IfStatement(iLocation, expression, (Statement[])assumeStatementArray, statementArray));
        expressionResultBuilder.setLrValue(new LocalLValue((LeftHandSide)auxVarInfo.getLhs(), (ICType)cPrimitive, null));
        return expressionResultBuilder.build();
    }
}

