/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class LoggingScript
extends WrapperScript {
    private final PrintWriter mPw;
    private final PrintTerm mTermPrinter = new PrintTerm();
    private final FormulaLet mLetter;

    public LoggingScript(String string, boolean bl) throws IOException {
        this(new NoopScript(), string, bl);
    }

    public LoggingScript(String string, boolean bl, boolean bl2) throws IOException {
        this(new NoopScript(), string, bl, bl2);
    }

    public LoggingScript(Script script, String string, boolean bl) throws IOException {
        this(script, string, bl, false);
    }

    public LoggingScript(Script script, String string, boolean bl, boolean bl2) throws IOException {
        super(script);
        OutputStream outputStream;
        if (string.equals("<stdout>")) {
            outputStream = System.out;
        } else if (string.equals("<stderr>")) {
            outputStream = System.err;
        } else {
            outputStream = new FileOutputStream(string);
            if (string.endsWith(".gz")) {
                outputStream = new GZIPOutputStream(outputStream);
            }
        }
        this.mPw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream)), bl);
        this.mLetter = bl2 ? new FormulaLet() : null;
    }

    private final Term formatTerm(Term term) {
        return this.mLetter == null ? term : new FormulaLet().let(term);
    }

    @Override
    public void setLogic(String string) throws UnsupportedOperationException, SMTLIBException {
        this.mPw.println("(set-logic " + string + ")");
        super.setLogic(string);
    }

    @Override
    public void setLogic(Logics logics) throws UnsupportedOperationException, SMTLIBException {
        this.mPw.println("(set-logic " + logics.name() + ")");
        super.setLogic(logics);
    }

    @Override
    public void setOption(String string, Object object) throws UnsupportedOperationException, SMTLIBException {
        this.mPw.print("(set-option ");
        this.mPw.print(string);
        this.mPw.print(' ');
        this.mPw.print(PrintTerm.quoteObjectIfString(object));
        this.mPw.println(")");
        super.setOption(string, object);
    }

    @Override
    public void setInfo(String string, Object object) {
        this.mPw.print("(set-info ");
        this.mPw.print(string);
        this.mPw.print(' ');
        this.mPw.print(PrintTerm.quoteObjectIfString(object));
        this.mPw.println(")");
        super.setInfo(string, object);
    }

    @Override
    public FunctionSymbol getFunctionSymbol(String string) {
        return this.mScript.getFunctionSymbol(string);
    }

    @Override
    public void declareSort(String string, int n) throws SMTLIBException {
        this.mPw.print("(declare-sort ");
        this.mPw.print(PrintTerm.quoteIdentifier(string));
        this.mPw.print(' ');
        this.mPw.print(n);
        this.mPw.println(")");
        super.declareSort(string, n);
    }

    @Override
    public void defineSort(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        this.mPw.print("(define-sort ");
        this.mPw.print(PrintTerm.quoteIdentifier(string));
        this.mPw.print(" (");
        String string2 = "";
        Sort[] sortArray2 = sortArray;
        int n = sortArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sort sort2 = sortArray2[n2];
            this.mPw.print(string2);
            this.mTermPrinter.append((Appendable)this.mPw, sort2);
            string2 = " ";
            ++n2;
        }
        this.mPw.print(") ");
        this.mTermPrinter.append((Appendable)this.mPw, sort);
        this.mPw.println(")");
        super.defineSort(string, sortArray, sort);
    }

    @Override
    public void declareDatatype(DataType dataType, DataType.Constructor[] constructorArray) throws SMTLIBException {
        assert (dataType.mNumParams == 0);
        this.mPw.print("(declare-datatype ");
        this.mPw.print(PrintTerm.quoteIdentifier(dataType.getName()));
        this.mPw.print(" (");
        int n = 0;
        while (n < constructorArray.length) {
            this.mPw.print("(");
            this.mPw.print(PrintTerm.quoteIdentifier(constructorArray[n].getName()));
            int n2 = 0;
            while (n2 < constructorArray[n].getArgumentSorts().length) {
                this.mPw.print(" ");
                this.mPw.print("(");
                this.mPw.print(PrintTerm.quoteIdentifier(constructorArray[n].getSelectors()[n2]));
                this.mPw.print(" ");
                this.mPw.print(constructorArray[n].getArgumentSorts()[n2]);
                this.mPw.print(")");
                ++n2;
            }
            this.mPw.print(n != constructorArray.length - 1 ? ") " : ")");
            ++n;
        }
        this.mPw.println("))");
        super.declareDatatype(dataType, constructorArray);
    }

    @Override
    public void declareDatatypes(DataType[] dataTypeArray, DataType.Constructor[][] constructorArray, Sort[][] sortArray) throws SMTLIBException {
        Object object;
        assert (dataTypeArray.length == constructorArray.length && dataTypeArray.length == sortArray.length);
        this.mPw.print("(declare-datatypes (");
        String string = "";
        Object object2 = dataTypeArray;
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            this.mPw.print(string);
            string = " ";
            this.mPw.print("(");
            this.mPw.print(PrintTerm.quoteIdentifier(((SortSymbol)object).getName()));
            this.mPw.print(" ");
            this.mPw.print(((DataType)object).mNumParams);
            this.mPw.print(")");
            ++n2;
        }
        this.mPw.print(") (");
        object = "";
        n2 = 0;
        while (n2 < constructorArray.length) {
            int n3;
            int n4;
            Object[] objectArray;
            this.mPw.print((String)object);
            object = " ";
            if (sortArray[n2] != null) {
                this.mPw.print("(par (");
                String string2 = "";
                objectArray = sortArray[n2];
                n4 = objectArray.length;
                n3 = 0;
                while (n3 < n4) {
                    object2 = objectArray[n3];
                    this.mPw.print(string2);
                    string2 = " ";
                    this.mPw.print(object2);
                    ++n3;
                }
                this.mPw.print(") ");
            }
            this.mPw.print("(");
            String string3 = "";
            objectArray = constructorArray[n2];
            n4 = objectArray.length;
            n3 = 0;
            while (n3 < n4) {
                object2 = objectArray[n3];
                this.mPw.print(string3);
                string3 = " ";
                this.mPw.print("(");
                this.mPw.print(PrintTerm.quoteIdentifier(((DataType.Constructor)object2).getName()));
                int n5 = 0;
                while (n5 < ((DataType.Constructor)object2).getArgumentSorts().length) {
                    this.mPw.print(" ");
                    this.mPw.print("(");
                    this.mPw.print(PrintTerm.quoteIdentifier(((DataType.Constructor)object2).getSelectors()[n5]));
                    this.mPw.print(" ");
                    this.mPw.print(((DataType.Constructor)object2).getArgumentSorts()[n5]);
                    this.mPw.print(")");
                    ++n5;
                }
                this.mPw.print(")");
                ++n3;
            }
            this.mPw.print(")");
            if (sortArray[n2] != null) {
                this.mPw.print(")");
            }
            ++n2;
        }
        this.mPw.println("))");
        super.declareDatatypes(dataTypeArray, constructorArray, sortArray);
    }

    @Override
    public void declareFun(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        this.mPw.print("(declare-fun ");
        this.mPw.print(PrintTerm.quoteIdentifier(string));
        this.mPw.print(" (");
        String string2 = "";
        Sort[] sortArray2 = sortArray;
        int n = sortArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sort sort2 = sortArray2[n2];
            this.mPw.print(string2);
            this.mTermPrinter.append((Appendable)this.mPw, sort2);
            string2 = " ";
            ++n2;
        }
        this.mPw.print(") ");
        this.mTermPrinter.append((Appendable)this.mPw, sort);
        this.mPw.println(")");
        super.declareFun(string, sortArray, sort);
    }

    @Override
    public void defineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
        this.mPw.print("(define-fun ");
        this.mPw.print(PrintTerm.quoteIdentifier(string));
        this.mPw.print(" (");
        String string2 = "(";
        TermVariable[] termVariableArray2 = termVariableArray;
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray2[n2];
            this.mPw.print(string2);
            this.mPw.print(termVariable);
            this.mPw.print(' ');
            this.mTermPrinter.append((Appendable)this.mPw, termVariable.getSort());
            this.mPw.print(')');
            string2 = " (";
            ++n2;
        }
        this.mPw.print(") ");
        this.mTermPrinter.append((Appendable)this.mPw, sort);
        this.mPw.print(' ');
        this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(term));
        this.mPw.println(")");
        super.defineFun(string, termVariableArray, sort, term);
    }

    @Override
    public void push(int n) throws SMTLIBException {
        this.mPw.println("(push " + n + ")");
        super.push(n);
    }

    @Override
    public void pop(int n) throws SMTLIBException {
        this.mPw.println("(pop " + n + ")");
        super.pop(n);
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mPw.print("(assert ");
        this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(term));
        this.mPw.println(")");
        return super.assertTerm(term);
    }

    @Override
    public Script.LBool checkSat() throws SMTLIBException {
        this.mPw.println("(check-sat)");
        return super.checkSat();
    }

    @Override
    public Script.LBool checkSatAssuming(Term ... termArray) throws SMTLIBException {
        this.mPw.print("(check-sat-assuming (");
        String string = "";
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            this.mPw.print(string);
            this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(term));
            string = " ";
            ++n2;
        }
        this.mPw.println("))");
        return super.checkSatAssuming(termArray);
    }

    @Override
    public Term[] getAssertions() throws SMTLIBException {
        this.mPw.println("(get-assertions)");
        return super.getAssertions();
    }

    @Override
    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-proof)");
        return super.getProof();
    }

    @Override
    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-unsat-core)");
        return super.getUnsatCore();
    }

    @Override
    public Map<Term, Term> getValue(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-value (");
        String string = "";
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            this.mPw.print(string);
            this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(term));
            string = " ";
            ++n2;
        }
        this.mPw.println("))");
        return super.getValue(termArray);
    }

    @Override
    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-assignment)");
        return super.getAssignment();
    }

    @Override
    public Object getOption(String string) throws UnsupportedOperationException {
        this.mPw.println("(get-option " + string + ")");
        return super.getOption(string);
    }

    @Override
    public Object getInfo(String string) throws UnsupportedOperationException {
        this.mPw.println("(get-info " + string + ")");
        return super.getInfo(string);
    }

    @Override
    public Term simplify(Term term) throws SMTLIBException {
        this.mPw.print("(simplify ");
        this.mTermPrinter.append((Appendable)this.mPw, term);
        this.mPw.println(")");
        return super.simplify(term);
    }

    @Override
    public void reset() {
        this.mPw.println("(reset)");
        super.reset();
    }

    @Override
    public Term[] getInterpolants(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-interpolants");
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            this.mPw.print(' ');
            this.mTermPrinter.append((Appendable)this.mPw, term);
            ++n2;
        }
        this.mPw.println(')');
        return super.getInterpolants(termArray);
    }

    private void printInterpolantQuery(Term[] termArray, int[] nArray) {
        this.mTermPrinter.append((Appendable)this.mPw, termArray[0]);
        int n = 1;
        while (n < termArray.length) {
            int n2 = nArray[n - 1];
            while (nArray[n] < n2) {
                this.mPw.print(')');
                n2 = nArray[n2 - 1];
            }
            this.mPw.print(' ');
            if (nArray[n] == n) {
                this.mPw.print('(');
            }
            this.mTermPrinter.append((Appendable)this.mPw, termArray[n]);
            ++n;
        }
    }

    @Override
    public Term[] getInterpolants(Term[] termArray, int[] nArray) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-interpolants ");
        this.printInterpolantQuery(termArray, nArray);
        this.mPw.println(')');
        return super.getInterpolants(termArray, nArray);
    }

    @Override
    public Term[] getInterpolants(Term[] termArray, int[] nArray, Term term) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-interpolants ");
        this.printInterpolantQuery(termArray, nArray);
        this.mPw.print(" :proof ");
        this.mTermPrinter.append((Appendable)this.mPw, term);
        this.mPw.println(')');
        return super.getInterpolants(termArray, nArray);
    }

    @Override
    public void exit() {
        this.mPw.println("(exit)");
        this.mPw.flush();
        this.mPw.close();
        super.exit();
    }

    @Override
    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-model)");
        return super.getModel();
    }

    @Override
    public Iterable<Term[]> checkAllsat(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        PrintTerm printTerm = new PrintTerm();
        this.mPw.print("(check-allsat (");
        String string = "";
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            this.mPw.print(string);
            printTerm.append((Appendable)this.mPw, term);
            string = " ";
            ++n2;
        }
        this.mPw.println("))");
        return super.checkAllsat(termArray);
    }

    @Override
    public Term[] findImpliedEquality(Term[] termArray, Term[] termArray2) {
        Term term;
        PrintTerm printTerm = new PrintTerm();
        this.mPw.print("(find-implied-equality (");
        String string = "";
        Term[] termArray3 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term = termArray3[n2];
            this.mPw.print(string);
            printTerm.append((Appendable)this.mPw, term);
            string = " ";
            ++n2;
        }
        this.mPw.print(") (");
        string = "";
        termArray3 = termArray;
        n = termArray.length;
        n2 = 0;
        while (n2 < n) {
            term = termArray3[n2];
            this.mPw.print(string);
            printTerm.append((Appendable)this.mPw, term);
            string = " ";
            ++n2;
        }
        this.mPw.println("))");
        return super.findImpliedEquality(termArray, termArray2);
    }

    @Override
    public QuotedObject echo(QuotedObject quotedObject) {
        this.mPw.print("(echo ");
        this.mPw.print(quotedObject);
        this.mPw.println(')');
        return super.echo(quotedObject);
    }

    public void comment(String string) {
        this.mPw.print("; ");
        this.mPw.println(string);
    }

    @Override
    public void resetAssertions() {
        this.mPw.println("(reset-assertions)");
        super.resetAssertions();
    }

    @Override
    public Term[] getUnsatAssumptions() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-unsat-assumptions)");
        return super.getUnsatAssumptions();
    }
}

