/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class DebugObserver
extends BaseObserver {
    private final ILogger mLogger;

    public DebugObserver(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (iElement instanceof IWalkable) {
            this.walkTree((IWalkable)iElement);
        }
        return false;
    }

    private void walkTree(IWalkable iWalkable) {
        ArrayDeque<IWalkable> arrayDeque = new ArrayDeque<IWalkable>();
        HashSet<IWalkable> hashSet = new HashSet<IWalkable>();
        arrayDeque.add(iWalkable);
        while (!arrayDeque.isEmpty()) {
            IWalkable iWalkable2 = (IWalkable)arrayDeque.poll();
            if (!hashSet.add(iWalkable2)) {
                this.mLogger.debug((Object)("This is not a tree! " + String.valueOf(iWalkable2) + " is on a cylce"));
                continue;
            }
            this.checkNode(iWalkable2);
            for (IWalkable iWalkable3 : iWalkable2.getSuccessors()) {
                if (iWalkable3 == null) {
                    this.mLogger.debug((Object)(String.valueOf(iWalkable2) + " contains null successors"));
                    continue;
                }
                arrayDeque.add(iWalkable3);
            }
        }
    }

    private void checkNode(IWalkable iWalkable) {
        IPayload iPayload;
        if (iWalkable.hasPayload() && (iPayload = iWalkable.getPayload()).hasAnnotation()) {
            Map map = iPayload.getAnnotations();
            Collection collection = CoreUtil.flattenMapValuesToCollection((Map)map);
            this.checkAnnotations(iWalkable, collection);
        }
    }

    private void checkAnnotations(IWalkable iWalkable, Collection<IAnnotations> collection) {
        for (IAnnotations iAnnotations : collection) {
            if (!(iAnnotations instanceof Overapprox)) continue;
            this.mLogger.info((Object)"Overapprox found");
        }
    }
}

