/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;

public class TableauxRow {
    static final int LIMIT_BITS = 30;
    static final int LIMIT = 0x40000000;
    static final int MARKER = 0x40000001;
    private int[] mEntries;
    private BigInteger[] mBigEntries;

    public TableauxRow(LinVar linVar, SortedMap<LinVar, Rational> sortedMap) {
        Rational rational3;
        assert (!sortedMap.containsKey(linVar));
        assert (sortedMap.size() >= 2);
        this.mEntries = new int[sortedMap.size() * 2 + 2];
        Rational rational2 = Rational.ONE;
        for (Rational rational3 : sortedMap.values()) {
            rational2 = rational2.gcd(rational3);
        }
        rational3 = new ArrayList();
        this.mEntries[0] = linVar.mMatrixpos;
        this.mEntries[1] = TableauxRow.addBigInteger((ArrayList<BigInteger>)rational3, rational2.inverse().negate().numerator());
        int n = 2;
        for (Map.Entry<LinVar, Rational> entry : sortedMap.entrySet()) {
            assert (entry.getValue().div(rational2).isIntegral());
            BigInteger bigInteger = entry.getValue().div(rational2).numerator();
            this.mEntries[n] = entry.getKey().mMatrixpos;
            this.mEntries[n + 1] = TableauxRow.addBigInteger((ArrayList<BigInteger>)rational3, bigInteger);
            n += 2;
        }
        if (rational3.size() > 0) {
            this.mBigEntries = rational3.toArray(new BigInteger[rational3.size()]);
        }
    }

    private static int addBigInteger(ArrayList<BigInteger> arrayList, long l) {
        if (l >= -1073741824L && l < 0x40000000L) {
            return (int)l;
        }
        arrayList.add(BigInteger.valueOf(l));
        return 0x40000001 + arrayList.size() - 1;
    }

    private static int addBigInteger(ArrayList<BigInteger> arrayList, BigInteger bigInteger) {
        if (bigInteger.bitLength() <= 30) {
            return bigInteger.intValue();
        }
        arrayList.add(bigInteger);
        return 0x40000001 + arrayList.size() - 1;
    }

    public int findRawIndex(int n) {
        int n2 = 1;
        int n3 = this.size();
        while (n2 < n3) {
            int n4 = (n2 + n3) / 2;
            if (this.mEntries[2 * n4] < n) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n2;
    }

    private int findEntry(int n) {
        int n2 = this.findRawIndex(n);
        return this.mEntries[2 * n2] == n ? this.mEntries[2 * n2 + 1] : 0;
    }

    private BigInteger bigEntry(int n) {
        return n < 0x40000001 ? BigInteger.valueOf(n) : this.mBigEntries[n - 0x40000001];
    }

    private void addRowInt(LinArSolve linArSolve, TableauxRow tableauxRow) {
        int n = tableauxRow.mEntries[0];
        assert (this.mBigEntries == null && tableauxRow.mBigEntries == null);
        int n2 = -tableauxRow.mEntries[1];
        int n3 = this.findEntry(n);
        assert (n3 != 0);
        int n4 = Rational.gcd((int)n2, (int)n3);
        n2 /= n4;
        n3 /= n4;
        int[] nArray = new int[this.mEntries.length / 2 + tableauxRow.mEntries.length / 2];
        long[] lArray = new long[this.mEntries.length / 2 + tableauxRow.mEntries.length / 2];
        int n5 = 2;
        int n6 = 2;
        int n7 = 1;
        nArray[0] = this.mEntries[0];
        lArray[0] = (long)this.mEntries[1] * (long)n2;
        long l = lArray[0];
        while (n5 < this.mEntries.length || n6 < tableauxRow.mEntries.length) {
            long l2;
            if (n6 == tableauxRow.mEntries.length || n5 < this.mEntries.length && this.mEntries[n5] < tableauxRow.mEntries[n6]) {
                if (this.mEntries[n5] != n) {
                    nArray[n7] = this.mEntries[n5];
                    l2 = (long)this.mEntries[n5 + 1] * (long)n2;
                    l = Rational.gcd((long)l, (long)l2);
                    lArray[n7] = l2;
                    ++n7;
                }
                n5 += 2;
                continue;
            }
            if (n5 == this.mEntries.length || this.mEntries[n5] > tableauxRow.mEntries[n6]) {
                linArSolve.mDependentRows.get(tableauxRow.mEntries[n6]).set(this.mEntries[0]);
                nArray[n7] = tableauxRow.mEntries[n6];
                l2 = (long)tableauxRow.mEntries[n6 + 1] * (long)n3;
                l = Rational.gcd((long)l, (long)l2);
                lArray[n7] = l2;
                n6 += 2;
                ++n7;
                continue;
            }
            assert (this.mEntries[n5] == tableauxRow.mEntries[n6]);
            l2 = (long)this.mEntries[n5 + 1] * (long)n2 + (long)tableauxRow.mEntries[n6 + 1] * (long)n3;
            if (l2 != 0L) {
                nArray[n7] = this.mEntries[n5];
                l = Rational.gcd((long)l, (long)l2);
                lArray[n7] = l2;
                ++n7;
            } else {
                linArSolve.mDependentRows.get(this.mEntries[n5]).clear(this.mEntries[0]);
            }
            n5 += 2;
            n6 += 2;
        }
        int[] nArray2 = new int[2 * n7];
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        int n8 = 0;
        while (n8 < n7) {
            nArray2[2 * n8] = nArray[n8];
            nArray2[2 * n8 + 1] = TableauxRow.addBigInteger(arrayList, lArray[n8] / l);
            assert (nArray2[2 * n8 + 1] >= -1073741824 && nArray2[2 * n8 + 1] < 0x40000001 + arrayList.size());
            ++n8;
        }
        this.mEntries = nArray2;
        if (arrayList.size() > 0) {
            this.mBigEntries = arrayList.toArray(new BigInteger[arrayList.size()]);
        }
    }

    private void addRowBigInt(LinArSolve linArSolve, TableauxRow tableauxRow) {
        Object object;
        int n = tableauxRow.mEntries[0];
        BigInteger bigInteger = tableauxRow.bigEntry(tableauxRow.mEntries[1]).negate();
        BigInteger bigInteger2 = this.bigEntry(this.findEntry(n));
        assert (bigInteger2.signum() != 0);
        BigInteger bigInteger3 = Rational.gcd((BigInteger)bigInteger, (BigInteger)bigInteger2);
        bigInteger = bigInteger.divide(bigInteger3);
        bigInteger2 = bigInteger2.divide(bigInteger3);
        int[] nArray = new int[this.mEntries.length / 2 + tableauxRow.mEntries.length / 2];
        BigInteger[] bigIntegerArray = new BigInteger[this.mEntries.length / 2 + tableauxRow.mEntries.length / 2];
        int n2 = 2;
        int n3 = 2;
        int n4 = 1;
        nArray[0] = this.mEntries[0];
        bigIntegerArray[0] = this.bigEntry(this.mEntries[1]).multiply(bigInteger);
        BigInteger bigInteger4 = bigIntegerArray[0];
        while (n2 < this.mEntries.length || n3 < tableauxRow.mEntries.length) {
            if (n3 == tableauxRow.mEntries.length || n2 < this.mEntries.length && this.mEntries[n2] < tableauxRow.mEntries[n3]) {
                if (this.mEntries[n2] != n) {
                    nArray[n4] = this.mEntries[n2];
                    object = this.bigEntry(this.mEntries[n2 + 1]).multiply(bigInteger);
                    bigInteger4 = Rational.gcd((BigInteger)bigInteger4, (BigInteger)object);
                    bigIntegerArray[n4] = object;
                    ++n4;
                }
                n2 += 2;
                continue;
            }
            if (n2 == this.mEntries.length || this.mEntries[n2] > tableauxRow.mEntries[n3]) {
                linArSolve.mDependentRows.get(tableauxRow.mEntries[n3]).set(this.mEntries[0]);
                nArray[n4] = tableauxRow.mEntries[n3];
                object = tableauxRow.bigEntry(tableauxRow.mEntries[n3 + 1]).multiply(bigInteger2);
                bigInteger4 = Rational.gcd((BigInteger)bigInteger4, (BigInteger)object);
                bigIntegerArray[n4] = object;
                n3 += 2;
                ++n4;
                continue;
            }
            assert (this.mEntries[n2] == tableauxRow.mEntries[n3]);
            object = this.bigEntry(this.mEntries[n2 + 1]).multiply(bigInteger).add(tableauxRow.bigEntry(tableauxRow.mEntries[n3 + 1]).multiply(bigInteger2));
            if (((BigInteger)object).signum() != 0) {
                nArray[n4] = this.mEntries[n2];
                bigInteger4 = Rational.gcd((BigInteger)bigInteger4, (BigInteger)object);
                bigIntegerArray[n4] = object;
                ++n4;
            } else {
                linArSolve.mDependentRows.get(this.mEntries[n2]).clear(this.mEntries[0]);
            }
            n2 += 2;
            n3 += 2;
        }
        object = new int[2 * n4];
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        int n5 = 0;
        while (n5 < n4) {
            object[2 * n5] = nArray[n5];
            BigInteger bigInteger5 = bigIntegerArray[n5].divide(bigInteger4);
            object[2 * n5 + 1] = TableauxRow.addBigInteger(arrayList, bigInteger5);
            assert (object[2 * n5 + 1] >= -1073741824 && object[2 * n5 + 1] < 0x40000001 + arrayList.size());
            ++n5;
        }
        this.mEntries = object;
        this.mBigEntries = arrayList.size() > 0 ? arrayList.toArray(new BigInteger[arrayList.size()]) : null;
    }

    public void addRow(LinArSolve linArSolve, TableauxRow tableauxRow) {
        if (this.mBigEntries == null && tableauxRow.mBigEntries == null) {
            this.addRowInt(linArSolve, tableauxRow);
        } else {
            this.addRowBigInt(linArSolve, tableauxRow);
        }
    }

    public void swapRowCol(int n) {
        int n2 = this.mEntries[0];
        int n3 = this.findRawIndex(n);
        int n4 = this.findRawIndex(n2);
        assert (n3 >= 1);
        assert (this.mEntries[2 * n3] == n);
        assert (2 * n4 == this.mEntries.length || this.mEntries[2 * n4] > n2);
        assert (n4 == 1 || this.mEntries[2 * (n4 - 1)] < n2);
        int n5 = this.mEntries[2 * n3 + 1];
        if (n3 < n4) {
            System.arraycopy(this.mEntries, 2 * n3 + 2, this.mEntries, 2 * n3, 2 * (--n4 - n3));
        } else {
            System.arraycopy(this.mEntries, 2 * n4, this.mEntries, 2 * n4 + 2, 2 * (n3 - n4));
        }
        this.mEntries[2 * n4] = n2;
        this.mEntries[2 * n4 + 1] = this.mEntries[1];
        this.mEntries[0] = n;
        this.mEntries[1] = n5;
    }

    public BigInteger getCoeffForPos(int n) {
        return this.bigEntry(this.findEntry(n));
    }

    int getRawIndex(int n) {
        return this.mEntries[2 * n];
    }

    BigInteger getRawCoeff(int n) {
        return this.bigEntry(this.mEntries[2 * n + 1]);
    }

    int size() {
        return this.mEntries.length / 2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getRawCoeff(0)).append(" * y").append(this.getRawIndex(0));
        int n = 1;
        while (n < this.size()) {
            stringBuilder.append(" + ");
            stringBuilder.append(this.getRawCoeff(n)).append(" * x").append(this.getRawIndex(n));
            ++n;
        }
        return stringBuilder.toString();
    }
}

