/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolutionBuilder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiCaseSolvedBinaryRelation
implements ITermProvider {
    private final Term mSubject;
    private final List<Case> mCases;
    private final Set<TermVariable> mAdditionalAuxiliaryVariables;
    private final EnumSet<IntricateOperation> mAdditionalIntricateOperations;
    private final Xnf mXnf;

    public MultiCaseSolvedBinaryRelation(Term term, List<Case> list, Set<TermVariable> set, EnumSet<IntricateOperation> enumSet, Xnf xnf) {
        this.mSubject = term;
        this.mCases = list;
        this.mAdditionalAuxiliaryVariables = set;
        this.mAdditionalIntricateOperations = enumSet;
        this.mXnf = xnf;
    }

    public Term getSubject() {
        return this.mSubject;
    }

    public List<Case> getCases() {
        return this.mCases;
    }

    public Set<IntricateOperation> getIntricateOperations() {
        return Stream.concat(this.mAdditionalIntricateOperations.stream(), this.mCases.stream().flatMap(Case::streamOfIntricateOperations)).collect(Collectors.toSet());
    }

    public Set<TermVariable> getAuxiliaryVariables() {
        return Stream.concat(this.mAdditionalAuxiliaryVariables.stream(), this.mCases.stream().flatMap(case_ -> case_.getAuxiliaryVariables().stream())).collect(Collectors.toSet());
    }

    public Xnf getXnf() {
        return this.mXnf;
    }

    @Override
    public Term toTerm(Script script) {
        Term term;
        Collection collection = this.mCases.stream().map(case_ -> case_.toTerm(script)).collect(Collectors.toList());
        int n = switch (this.mXnf) {
            case Xnf.CNF -> {
                term = SmtUtils.and(script, collection);
                yield 1;
            }
            case Xnf.DNF -> {
                term = SmtUtils.or(script, collection);
                yield 0;
            }
            default -> throw new AssertionError((Object)("unknown case " + String.valueOf((Object)this.mXnf)));
        };
        Set<TermVariable> set = this.getAuxiliaryVariables();
        Term term2 = SmtUtils.quantifier(script, n, set, term);
        return term2;
    }

    public MultiCaseSolutionBuilder constructCopy() {
        MultiCaseSolutionBuilder multiCaseSolutionBuilder = new MultiCaseSolutionBuilder(this.getSubject(), this.getXnf());
        multiCaseSolutionBuilder.splitCases(this.getCases());
        for (TermVariable object : this.mAdditionalAuxiliaryVariables) {
            multiCaseSolutionBuilder.reportAdditionalAuxiliaryVariable(object);
        }
        for (IntricateOperation intricateOperation : this.mAdditionalIntricateOperations) {
            multiCaseSolutionBuilder.reportAdditionalIntricateOperation(intricateOperation);
        }
        return multiCaseSolutionBuilder;
    }

    public boolean isSubjectOnlyOnRhs() {
        for (Case case_ : this.getCases()) {
            boolean bl = this.isSubjectOnlyOnRhs(this.mSubject, case_);
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean isSubjectOnlyOnRhs(Term term, Case case_) {
        if (case_.getSolvedBinaryRelation() != null && !case_.getSolvedBinaryRelation().getLeftHandSide().equals(term)) {
            throw new AssertionError((Object)"illegal subject");
        }
        for (SupportingTerm supportingTerm : case_.getSupportingTerms()) {
            boolean bl = SmtUtils.isSubterm(supportingTerm.getTerm(), term);
            if (!bl) continue;
            return false;
        }
        return true;
    }

    public static enum IntricateOperation {
        DIV_BY_NONCONSTANT,
        DIV_BY_INTEGER_CONSTANT,
        MUL_BY_INTEGER_CONSTANT;

    }

    public static enum Xnf {
        CNF,
        DNF;


        public static Xnf fromQuantifier(int n) {
            if (n == 0) {
                return DNF;
            }
            if (n == 1) {
                return CNF;
            }
            throw new AssertionError();
        }
    }
}

