/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IRAConstantFormatter
extends TermTransformer {
    @Override
    protected void convert(Term term) {
        if (term instanceof ConstantTerm) {
            ConstantTerm constantTerm = (ConstantTerm)term;
            Rational rational = null;
            if (constantTerm.getValue() instanceof Rational) {
                rational = (Rational)constantTerm.getValue();
            } else if (constantTerm.getValue() instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)constantTerm.getValue();
                int n = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                BigInteger bigInteger2 = BigInteger.TEN.pow(n);
                rational = Rational.valueOf(bigInteger, bigInteger2);
            } else if (constantTerm.getValue() instanceof BigInteger) {
                rational = Rational.valueOf((BigInteger)constantTerm.getValue(), BigInteger.ONE);
            } else {
                this.setResult(constantTerm);
                return;
            }
            this.setResult(constantTerm.getTheory().modelRational(rational, constantTerm.getSort()));
        } else {
            super.convert(term);
        }
    }
}

