/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LogicStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Parameter;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.PolyIdentifier;
import java.util.ArrayList;
import java.util.List;

public final class Predicate
extends LogicStatement {
    private static final java.util.function.Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Predicate.class);
    Expression formula;

    public Predicate(PolyIdentifier polyIdentifier, Expression expression) {
        super(polyIdentifier);
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Predicate: " + String.valueOf(this);
    }

    public Predicate(PolyIdentifier polyIdentifier, Parameter[] parameterArray, Expression expression) {
        super(polyIdentifier, parameterArray);
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Predicate: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Predicate").append('[');
        stringBuffer.append(this.formula);
        return stringBuffer.append(']').toString();
    }

    public Expression getFormula() {
        return this.formula;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.formula);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((LogicStatement)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.formula != null) {
                this.formula.accept(aCSLVisitor);
            }
            if (this.polyId != null) {
                this.polyId.accept(aCSLVisitor);
            }
            if (this.parameters != null) {
                Parameter[] parameterArray = this.parameters;
                int n = this.parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter parameter = parameterArray[n2];
                    parameter.accept(aCSLVisitor);
                    ++n2;
                }
            }
        }
    }

    @Override
    public LogicStatement accept(ACSLTransformer aCSLTransformer) {
        LogicStatement logicStatement = aCSLTransformer.transform(this);
        if (logicStatement != this) {
            return logicStatement;
        }
        Expression expression = null;
        if (this.formula != null) {
            expression = this.formula.accept(aCSLTransformer);
        }
        PolyIdentifier polyIdentifier = null;
        if (this.polyId != null) {
            polyIdentifier = this.polyId.accept(aCSLTransformer);
        }
        boolean bl = false;
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        if (this.parameters != null) {
            Parameter[] parameterArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                Parameter parameter2 = parameter.accept(aCSLTransformer);
                bl = bl || parameter2 != parameter;
                arrayList.add(parameter2);
                ++n2;
            }
        }
        if (bl || this.formula != expression || this.polyId != polyIdentifier) {
            return new Predicate(polyIdentifier, arrayList.toArray(new Parameter[0]), expression);
        }
        return this;
    }
}

