/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BasePayloadContainer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class BasicIcfg<LOC extends IcfgLocation>
extends BasePayloadContainer
implements IIcfg<LOC> {
    private static final long serialVersionUID = 1L;
    private final Map<String, Map<DebugIdentifier, LOC>> mProgramPoints;
    private final Map<String, LOC> mEntryNodes;
    private final Map<String, LOC> mExitNodes;
    private final Map<String, Set<LOC>> mErrorNodes;
    private final Set<LOC> mLocationsOfInterest;
    private final Set<LOC> mLoopLocations;
    private CfgSmtToolkit mCfgSmtToolkit;
    private final Set<LOC> mInitialNodes;
    private final String mIdentifier;
    private final Class<LOC> mLocationClass;

    public BasicIcfg(String string, CfgSmtToolkit cfgSmtToolkit, Class<LOC> clazz) {
        this.mLocationClass = Objects.requireNonNull(clazz);
        this.mIdentifier = Objects.requireNonNull(string);
        this.mCfgSmtToolkit = Objects.requireNonNull(cfgSmtToolkit);
        this.mInitialNodes = new LinkedHashSet<LOC>();
        this.mLoopLocations = new LinkedHashSet<LOC>();
        this.mProgramPoints = new LinkedHashMap<String, Map<DebugIdentifier, LOC>>();
        this.mEntryNodes = new LinkedHashMap<String, LOC>();
        this.mExitNodes = new LinkedHashMap<String, LOC>();
        this.mErrorNodes = new LinkedHashMap<String, Set<LOC>>();
        this.mLocationsOfInterest = new LinkedHashSet<LOC>();
        for (String string2 : this.mCfgSmtToolkit.getProcedures()) {
            this.mProgramPoints.put(string2, new LinkedHashMap());
            this.mErrorNodes.put(string2, new LinkedHashSet());
        }
    }

    public void addProcedure(String string) {
        this.mProgramPoints.put(string, new LinkedHashMap());
        this.mErrorNodes.put(string, new LinkedHashSet());
    }

    public void addLocation(LOC LOC, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        Object object;
        if (LOC == null) {
            throw new IllegalArgumentException("Cannot add null location");
        }
        assert (this.getLocationClass().isAssignableFrom(LOC.getClass())) : "Incompatible location types. Should be subclass of " + String.valueOf(this.getLocationClass()) + " but is " + String.valueOf(LOC.getClass());
        String string = BasicIcfg.getProcedure(LOC);
        Map<DebugIdentifier, LOC> map = this.mProgramPoints.get(string);
        assert (map != null) : "Unknown procedure";
        IcfgLocation icfgLocation = (IcfgLocation)map.put(((IcfgLocation)LOC).getDebugIdentifier(), LOC);
        if (((IcfgLocation)LOC).equals(icfgLocation)) {
            return;
        }
        assert (icfgLocation == null) : "Duplicate debug identifier for loc " + String.valueOf(LOC);
        if (bl) {
            this.mInitialNodes.add(LOC);
        }
        if (bl2) {
            object = this.mErrorNodes.get(string);
            assert (object != null) : "Unknown procedure";
            object.add(LOC);
        }
        if (bl3) {
            object = (IcfgLocation)this.mEntryNodes.put(string, LOC);
            assert (object == null || ((IcfgLocation)LOC).equals(object)) : "Do not overwrite the procedure entry node by mistake! Remove the old one first";
        }
        if (bl4) {
            object = (IcfgLocation)this.mExitNodes.put(string, LOC);
            assert (object == null || ((IcfgLocation)LOC).equals(object)) : "Do not overwrite the procedure exit node by mistake! Remove the old one first";
        }
        if (bl5) {
            this.mLoopLocations.add(LOC);
        }
        if (bl6) {
            this.mLocationsOfInterest.add(LOC);
        }
    }

    public void addOrdinaryLocation(LOC LOC) {
        this.addLocation(LOC, false, false, false, false, false, false);
    }

    public boolean removeLocation(IcfgLocation icfgLocation) {
        IcfgLocation icfgLocation2;
        if (icfgLocation == null) {
            return false;
        }
        String string = BasicIcfg.getProcedure(icfgLocation);
        Map<DebugIdentifier, LOC> map = this.mProgramPoints.get(string);
        if (map == null) {
            return false;
        }
        IcfgLocation icfgLocation3 = (IcfgLocation)map.remove(icfgLocation.getDebugIdentifier());
        if (!icfgLocation.equals(icfgLocation3)) {
            assert (icfgLocation3 == null) : "Multiple nodes with identical debug identifier!";
            return false;
        }
        IcfgLocation icfgLocation4 = (IcfgLocation)this.mEntryNodes.get(string);
        if (icfgLocation.equals(icfgLocation4)) {
            this.mEntryNodes.remove(string);
        }
        if (icfgLocation.equals(icfgLocation2 = (IcfgLocation)this.mExitNodes.get(string))) {
            this.mExitNodes.remove(string);
        }
        Set<LOC> set = this.mErrorNodes.get(string);
        set.remove(icfgLocation);
        this.mLoopLocations.remove(icfgLocation);
        this.mInitialNodes.remove(icfgLocation);
        return true;
    }

    private static String getProcedure(IcfgLocation icfgLocation) {
        String string = icfgLocation.getProcedure();
        assert (string != null) : "Location " + String.valueOf(icfgLocation) + " does not have a procedure";
        return string;
    }

    @Override
    public Map<String, Map<DebugIdentifier, LOC>> getProgramPoints() {
        return Collections.unmodifiableMap(this.mProgramPoints);
    }

    @Override
    public Map<String, LOC> getProcedureEntryNodes() {
        return Collections.unmodifiableMap(this.mEntryNodes);
    }

    @Override
    public Map<String, LOC> getProcedureExitNodes() {
        return Collections.unmodifiableMap(this.mExitNodes);
    }

    @Override
    public Map<String, Set<LOC>> getProcedureErrorNodes() {
        return Collections.unmodifiableMap(this.mErrorNodes);
    }

    @Override
    public Set<LOC> getLocationsOfInterest() {
        return Collections.unmodifiableSet(this.mLocationsOfInterest);
    }

    @Override
    public Set<LOC> getLoopLocations() {
        return Collections.unmodifiableSet(this.mLoopLocations);
    }

    @Override
    public CfgSmtToolkit getCfgSmtToolkit() {
        return this.mCfgSmtToolkit;
    }

    public void setCfgSmtToolkit(CfgSmtToolkit cfgSmtToolkit) {
        this.mCfgSmtToolkit = cfgSmtToolkit;
    }

    @Override
    public Set<LOC> getInitialNodes() {
        return Collections.unmodifiableSet(this.mInitialNodes);
    }

    public Set<IcfgEdge> getInitialOutgoingEdges() {
        return this.getInitialNodes().stream().flatMap(icfgLocation -> icfgLocation.getOutgoingEdges().stream()).collect(Collectors.toSet());
    }

    @Override
    public String getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public Class<LOC> getLocationClass() {
        return this.mLocationClass;
    }

    public String toString() {
        return this.graphStructureToString();
    }
}

