/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata;

import de.uni_freiburg.informatik.ultimate.automata.AtsFormat;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.alternating.AlternatingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.CountingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.CountingAutomatonDataStructure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.BaFormatWriter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.GoalFormatWriter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.HanoiFormatWriter;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;

public class AutomatonDefinitionPrinter<LETTER, STATE> {
    private static final String UNSUPPORTED_LABELING = "Unsupported labeling.";
    private static final int ONE = 1;
    private static final boolean DUMP_AUTOMATON = false;
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;

    private AutomatonDefinitionPrinter(AutomataLibraryServices automataLibraryServices) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
    }

    public AutomatonDefinitionPrinter(AutomataLibraryServices automataLibraryServices, String string, String string2, IFormat iFormat, String string3, boolean bl, IAutomaton<?, ?> ... iAutomatonArray) {
        this(automataLibraryServices);
        FileWriter fileWriter = this.getFileWriterWithOptionalAppend(string2, iFormat, bl);
        if (fileWriter != null) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)String.format("Dumping automata %s to %s", string, string2));
            }
            PrintWriter printWriter = new PrintWriter(fileWriter);
            AutomatonDefinitionPrinter.printAutomataToFileWriter(this.mServices, printWriter, string, iFormat, string3, iAutomatonArray);
        }
    }

    public AutomatonDefinitionPrinter(AutomataLibraryServices automataLibraryServices, String string, String string2, Format format, String string3, boolean bl, IAutomaton<?, ?> ... iAutomatonArray) {
        this(automataLibraryServices, string, string2, format.getFormat(), string3, bl, iAutomatonArray);
    }

    public AutomatonDefinitionPrinter(AutomataLibraryServices automataLibraryServices, String string, String string2, IFormat iFormat, String string3, IAutomaton<?, ?> ... iAutomatonArray) {
        this(automataLibraryServices, string, string2, iFormat, string3, false, iAutomatonArray);
    }

    public AutomatonDefinitionPrinter(AutomataLibraryServices automataLibraryServices, String string, String string2, Format format, String string3, IAutomaton<?, ?> ... iAutomatonArray) {
        this(automataLibraryServices, string, string2, format.getFormat(), string3, iAutomatonArray);
    }

    public static String toString(AutomataLibraryServices automataLibraryServices, String string, IAutomaton<?, ?> iAutomaton) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        AutomatonDefinitionPrinter.printAutomaton(automataLibraryServices, new NamedAutomaton(string, iAutomaton), Format.ATS.getFormat(), printWriter);
        return stringWriter.toString();
    }

    public static void writeAutomatonToFile(AutomataLibraryServices automataLibraryServices, String string, Format format, String string2, String string3, NamedAutomaton<?, ?> ... namedAutomatonArray) {
        AutomatonDefinitionPrinter.writeAutomatonToFile(automataLibraryServices, string, format.getFormat(), string2, string3, namedAutomatonArray);
    }

    public static void writeAutomatonToFile(AutomataLibraryServices automataLibraryServices, String string, IFormat iFormat, String string2, String string3, NamedAutomaton<?, ?> ... namedAutomatonArray) {
        File file = new File(string + "." + iFormat.getFileEnding());
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (PrintWriter printWriter = new PrintWriter(new FileWriter(file));){
                iFormat.printHeader(printWriter, string2);
                printWriter.println();
                printWriter.println(string3);
                printWriter.println();
                NamedAutomaton<?, ?>[] namedAutomatonArray2 = namedAutomatonArray;
                int n = namedAutomatonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NamedAutomaton<?, ?> namedAutomaton = namedAutomatonArray2[n2];
                    AutomatonDefinitionPrinter.printAutomaton(automataLibraryServices, namedAutomaton, iFormat, printWriter);
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new AssertionError("Unable to create file writer for " + string, iOException);
        }
    }

    @SafeVarargs
    public static void writeToFileIfPreferred(AutomataLibraryServices automataLibraryServices, String string, String string2, IAutomaton<?, ?> ... iAutomatonArray) {
    }

    private FileWriter getFileWriterWithOptionalAppend(String string, IFormat iFormat, boolean bl) {
        File file = new File(string + "." + iFormat.getFileEnding());
        try {
            return new FileWriter(file, bl);
        }
        catch (IOException iOException) {
            if (this.mLogger.isErrorEnabled()) {
                this.mLogger.error((Object)"Creating FileWriter did not work.", (Throwable)iOException);
            }
            return null;
        }
    }

    private static String getDateTimeFileName() {
        return AutomatonDefinitionPrinter.getDateTimeFromFormat("yyyyMMddHHmmss");
    }

    static String getDateTimeFromFormat(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.ENGLISH);
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    private static void printAutomataToFileWriter(AutomataLibraryServices automataLibraryServices, PrintWriter printWriter, String string, IFormat iFormat, String string2, IAutomaton<?, ?> ... iAutomatonArray) {
        iFormat.printHeader(printWriter, string2);
        if (iAutomatonArray.length == 1) {
            AutomatonDefinitionPrinter.printAutomaton(automataLibraryServices, new NamedAutomaton(string, iAutomatonArray[0]), iFormat, printWriter);
        } else {
            int n = 0;
            while (n < iAutomatonArray.length) {
                AutomatonDefinitionPrinter.printAutomaton(automataLibraryServices, new NamedAutomaton(string + n, iAutomatonArray[n]), iFormat, printWriter);
                ++n;
            }
        }
        printWriter.close();
    }

    private static <LETTER, STATE> void printAutomaton(AutomataLibraryServices automataLibraryServices, NamedAutomaton<LETTER, STATE> namedAutomaton, IFormat iFormat, PrintWriter printWriter) {
        if (namedAutomaton.getAutomaton() instanceof INwaOutgoingLetterAndTransitionProvider) {
            AutomatonDefinitionPrinter.printNestedWordAutomaton(automataLibraryServices, namedAutomaton.getName(), (INwaOutgoingLetterAndTransitionProvider)namedAutomaton.getAutomaton(), iFormat, printWriter);
        } else if (namedAutomaton.getAutomaton() instanceof IPetriNet) {
            AutomatonDefinitionPrinter.printPetriNet(namedAutomaton.getName(), (IPetriNet)namedAutomaton.getAutomaton(), iFormat, printWriter);
        } else if (namedAutomaton.getAutomaton() instanceof AlternatingAutomaton) {
            iFormat.printAlternatingAutomaton(printWriter, namedAutomaton.getName(), (AlternatingAutomaton)namedAutomaton.getAutomaton());
        } else if (namedAutomaton.getAutomaton() instanceof TreeAutomatonBU) {
            iFormat.printTreeAutomaton(printWriter, namedAutomaton.getName(), (TreeAutomatonBU)namedAutomaton.getAutomaton());
        } else if (namedAutomaton.getAutomaton() instanceof BranchingProcess) {
            iFormat.printBranchingProcess(printWriter, namedAutomaton.getName(), (BranchingProcess)namedAutomaton.getAutomaton());
        } else if (namedAutomaton.getAutomaton() instanceof CountingAutomaton) {
            iFormat.printCountingAutomaton(printWriter, namedAutomaton.getName(), (CountingAutomaton)namedAutomaton.getAutomaton());
        } else if (namedAutomaton.getAutomaton() instanceof CountingAutomatonDataStructure) {
            iFormat.printCountingAutomatonDataStructure(printWriter, namedAutomaton.getName(), (CountingAutomatonDataStructure)namedAutomaton.getAutomaton());
        } else {
            throw new AssertionError((Object)"unknown kind of automaton");
        }
    }

    private static <LETTER, STATE> void printNestedWordAutomaton(AutomataLibraryServices automataLibraryServices, String string, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IFormat iFormat, PrintWriter printWriter) throws AssertionError {
        NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates;
        if (iNwaOutgoingLetterAndTransitionProvider instanceof INestedWordAutomaton) {
            nestedWordAutomatonReachableStates = (NestedWordAutomatonReachableStates<LETTER, STATE>)iNwaOutgoingLetterAndTransitionProvider;
        } else {
            try {
                nestedWordAutomatonReachableStates = new NestedWordAutomatonReachableStates<LETTER, STATE>(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider);
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                throw new AssertionError((Object)"Timeout while preparing automaton for printing.");
            }
        }
        iFormat.printNestedWordAutomaton(printWriter, string, nestedWordAutomatonReachableStates);
    }

    private static <LETTER, STATE> void printPetriNet(String string, IPetriNet<LETTER, STATE> iPetriNet, IFormat iFormat, PrintWriter printWriter) throws AssertionError {
        if (!(iPetriNet instanceof BoundedPetriNet)) {
            String string2 = "Unknown Petri net type. Only supported type is " + BoundedPetriNet.class.getSimpleName();
            throw new IllegalArgumentException(string2);
        }
        BoundedPetriNet boundedPetriNet = (BoundedPetriNet)iPetriNet;
        iFormat.printPetriNet(printWriter, string, boundedPetriNet);
    }

    private static void ensureNoCallReturn(IFormat iFormat, INestedWordAutomaton<?, ?> iNestedWordAutomaton) {
        if (!NestedWordAutomataUtils.isFiniteAutomaton(iNestedWordAutomaton)) {
            throw new UnsupportedOperationException(iFormat.getClass().getSimpleName() + " does not support call transitions or return transitions");
        }
    }

    static void failUnsupported() {
        throw new AssertionError((Object)UNSUPPORTED_LABELING);
    }

    private static class BaFormat
    implements IFormat {
        private BaFormat() {
        }

        @Override
        public String getFileEnding() {
            return "ba";
        }

        @Override
        public <L, S> void printNestedWordAutomaton(PrintWriter printWriter, String string, INestedWordAutomaton<L, S> iNestedWordAutomaton) {
            AutomatonDefinitionPrinter.ensureNoCallReturn(this, iNestedWordAutomaton);
            new BaFormatWriter<L, S>(printWriter, iNestedWordAutomaton);
        }
    }

    public static enum Format {
        ATS(AtsFormat::new),
        ATS_NUMERATE(AtsFormat.AtsNumerateFormat::new),
        ATS_QUOTED(AtsFormat.AtsQuotedFormat::new),
        BA(() -> new BaFormat()),
        GFF(() -> new GffFormat()),
        HOA(() -> new HoaFormat());

        private final Supplier<IFormat> mFormatSupplier;

        private Format(Supplier<IFormat> supplier) {
            this.mFormatSupplier = supplier;
        }

        public IFormat getFormat() {
            return this.mFormatSupplier.get();
        }
    }

    private static class GffFormat
    implements IFormat {
        private GffFormat() {
        }

        @Override
        public String getFileEnding() {
            return "gff";
        }

        @Override
        public <L, S> void printNestedWordAutomaton(PrintWriter printWriter, String string, INestedWordAutomaton<L, S> iNestedWordAutomaton) {
            AutomatonDefinitionPrinter.ensureNoCallReturn(this, iNestedWordAutomaton);
            new GoalFormatWriter<L, S>(printWriter, iNestedWordAutomaton);
        }
    }

    private static class HoaFormat
    implements IFormat {
        private HoaFormat() {
        }

        @Override
        public String getFileEnding() {
            return "hoa";
        }

        @Override
        public <L, S> void printNestedWordAutomaton(PrintWriter printWriter, String string, INestedWordAutomaton<L, S> iNestedWordAutomaton) {
            AutomatonDefinitionPrinter.ensureNoCallReturn(this, iNestedWordAutomaton);
            new HanoiFormatWriter<L, S>(printWriter, iNestedWordAutomaton);
        }
    }

    public static interface IFormat {
        public String getFileEnding();

        default public void printHeader(PrintWriter printWriter, String string) {
        }

        public <L, S> void printNestedWordAutomaton(PrintWriter var1, String var2, INestedWordAutomaton<L, S> var3);

        default public <L, S> void printCountingAutomaton(PrintWriter printWriter, String string, CountingAutomaton<L, S> countingAutomaton) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        default public <L, S> void printTreeAutomaton(PrintWriter printWriter, String string, TreeAutomatonBU<? extends IRankedLetter, S> treeAutomatonBU) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        default public <L, S> void printCountingAutomatonDataStructure(PrintWriter printWriter, String string, CountingAutomatonDataStructure<L, S> countingAutomatonDataStructure) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        default public <L, S> void printPetriNet(PrintWriter printWriter, String string, BoundedPetriNet<L, S> boundedPetriNet) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        default public <L, S> void printAlternatingAutomaton(PrintWriter printWriter, String string, AlternatingAutomaton<L, S> alternatingAutomaton) {
            AutomatonDefinitionPrinter.failUnsupported();
        }

        default public <L, S> void printBranchingProcess(PrintWriter printWriter, String string, BranchingProcess<L, S> branchingProcess) {
            AutomatonDefinitionPrinter.failUnsupported();
        }
    }

    public static class NamedAutomaton<LETTER, STATE> {
        private final String mName;
        private final IAutomaton<LETTER, STATE> mAutomaton;

        public NamedAutomaton(String string, IAutomaton<LETTER, STATE> iAutomaton) {
            Objects.requireNonNull(string);
            Objects.requireNonNull(iAutomaton);
            this.mName = string;
            this.mAutomaton = iAutomaton;
        }

        public String getName() {
            return this.mName;
        }

        public IAutomaton<LETTER, STATE> getAutomaton() {
            return this.mAutomaton;
        }
    }
}

