/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import java.util.HashSet;
import java.util.Set;

public class ImplicationVertex<T extends IPredicate> {
    private final T mPredicate;
    private final Set<ImplicationVertex<T>> mChildren;
    private final Set<ImplicationVertex<T>> mParents;
    private final Set<ImplicationVertex<T>> mDescendants;
    private final Set<ImplicationVertex<T>> mAncestors;

    public ImplicationVertex(T t, Set<ImplicationVertex<T>> set, Set<ImplicationVertex<T>> set2) {
        this.mPredicate = t;
        this.mChildren = set;
        this.mParents = set2;
        this.mDescendants = new HashSet<ImplicationVertex<T>>();
        this.mAncestors = new HashSet<ImplicationVertex<T>>();
        this.transitiveReductionAfterAdding();
        this.updateTransitiveClosure();
    }

    private void updateTransitiveClosure() {
        this.mDescendants.addAll(this.mChildren);
        for (ImplicationVertex<T> implicationVertex : this.mChildren) {
            this.mDescendants.addAll(implicationVertex.getDescendants());
        }
        this.mAncestors.addAll(this.mParents);
        for (ImplicationVertex<T> implicationVertex : this.mParents) {
            this.mAncestors.addAll(implicationVertex.getAncestors());
        }
        for (ImplicationVertex<T> implicationVertex : this.mDescendants) {
            implicationVertex.addAncestor(this);
        }
        for (ImplicationVertex<T> implicationVertex : this.mAncestors) {
            implicationVertex.addDescendant(this);
        }
    }

    protected void transitiveReductionAfterAdding() {
        for (ImplicationVertex<T> implicationVertex : this.mParents) {
            for (ImplicationVertex<T> implicationVertex2 : this.mChildren) {
                if (implicationVertex.getChildren().contains(implicationVertex2)) {
                    implicationVertex.removeChild(implicationVertex2);
                    implicationVertex2.removeParent(implicationVertex);
                }
                implicationVertex2.addParent(this);
            }
            implicationVertex.addChild(this);
        }
    }

    public String toString() {
        HashSet hashSet = new HashSet();
        this.mChildren.forEach(implicationVertex -> {
            boolean bl = hashSet.add(implicationVertex.mPredicate);
        });
        return String.valueOf(this.mPredicate.toString()) + "-> " + ((Object)hashSet).toString();
    }

    public Set<ImplicationVertex<T>> getDescendants() {
        return this.mDescendants;
    }

    public Set<ImplicationVertex<T>> getAncestors() {
        return this.mAncestors;
    }

    protected Set<ImplicationVertex<T>> getChildren() {
        return this.mChildren;
    }

    protected Set<ImplicationVertex<T>> getParents() {
        return this.mParents;
    }

    public boolean addAncestor(ImplicationVertex<T> implicationVertex) {
        return this.mAncestors.add(implicationVertex);
    }

    public boolean addDescendant(ImplicationVertex<T> implicationVertex) {
        return this.mDescendants.add(implicationVertex);
    }

    protected boolean addChild(ImplicationVertex<T> implicationVertex) {
        return this.mChildren.add(implicationVertex);
    }

    protected boolean addParent(ImplicationVertex<T> implicationVertex) {
        return this.mParents.add(implicationVertex);
    }

    protected boolean removeChild(ImplicationVertex<T> implicationVertex) {
        return this.mChildren.remove(implicationVertex);
    }

    protected boolean removeParent(ImplicationVertex<T> implicationVertex) {
        return this.mParents.remove(implicationVertex);
    }

    public T getPredicate() {
        return this.mPredicate;
    }
}

