/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstractionwithafas;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.preferences.RcfgPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstractionwithafas.Activator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class CFG2Automaton<LETTER extends IIcfgTransition<?>, RESULT> {
    private static final String INIT_PROCEDURE = "~init";
    protected final ILogger mLogger;
    protected final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final IIcfg<?> mIcfg;
    private final CfgSmtToolkit mCsToolkit;
    private final PredicateFactory mPredicateFactory;
    private final IEmptyStackStateFactory<IPredicate> mContentFactory;
    protected List<INestedWordAutomaton<LETTER, IPredicate>> mAutomata;
    private LETTER mSharedVarsInit;

    public CFG2Automaton(IIcfg<?> iIcfg, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
        this.mIcfg = iIcfg;
        this.mContentFactory = iEmptyStackStateFactory;
        this.mCsToolkit = cfgSmtToolkit;
        this.mPredicateFactory = predicateFactory;
    }

    public abstract RESULT getResult();

    protected void constructProcedureAutomata() {
        RcfgPreferenceInitializer.CodeBlockSize codeBlockSize = (RcfgPreferenceInitializer.CodeBlockSize)RcfgPreferenceInitializer.getPreferences((IUltimateServiceProvider)this.mServices).getEnum("Size of a code block", RcfgPreferenceInitializer.CodeBlockSize.class);
        if (codeBlockSize != RcfgPreferenceInitializer.CodeBlockSize.SingleStatement) {
            throw new IllegalArgumentException("Concurrent programs reqireatomic block encoding.");
        }
        if (!this.mIcfg.getProcedureEntryNodes().containsKey(INIT_PROCEDURE)) {
            throw new IllegalArgumentException("Concurrent program needs procedure ~init to initialize shared variables");
        }
        int n = this.mIcfg.getProcedureEntryNodes().size() - 1;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Program has procedure to initialize shared variables");
            this.mLogger.debug((Object)("Found " + n + "Procedures"));
        }
        this.mAutomata = new ArrayList<INestedWordAutomaton<LETTER, IPredicate>>(n);
        this.mSharedVarsInit = this.extractPrecondition();
        this.mIcfg.getProcedureEntryNodes().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(INIT_PROCEDURE)).map(entry -> this.getNestedWordAutomaton((IcfgLocation)entry.getValue())).forEach(this.mAutomata::add);
        assert (this.mAutomata.size() == n);
    }

    private LETTER extractPrecondition() {
        assert (this.mIcfg.getProcedureEntryNodes().containsKey(INIT_PROCEDURE));
        if (!(this.mIcfg instanceof BoogieIcfgContainer)) {
            throw new UnsupportedOperationException();
        }
        BoogieIcfgContainer boogieIcfgContainer = (BoogieIcfgContainer)this.mIcfg;
        BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)boogieIcfgContainer.getProcedureEntryNodes().get(INIT_PROCEDURE);
        BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)boogieIcfgContainer.getProcedureExitNodes().get(INIT_PROCEDURE);
        ArrayList<StatementSequence> arrayList = new ArrayList<StatementSequence>();
        BoogieIcfgLocation boogieIcfgLocation3 = boogieIcfgLocation;
        while (boogieIcfgLocation3 != boogieIcfgLocation2) {
            assert (boogieIcfgLocation3.getOutgoingEdges().size() == 1);
            assert (boogieIcfgLocation3.getOutgoingEdges().get(0) instanceof StatementSequence);
            StatementSequence statementSequence = (StatementSequence)boogieIcfgLocation3.getOutgoingEdges().get(0);
            assert (statementSequence.getStatements().size() == 1);
            arrayList.add(statementSequence);
            boogieIcfgLocation3 = (IcfgLocation)statementSequence.getTarget();
        }
        return (LETTER)boogieIcfgContainer.getCodeBlockFactory().constructSequentialCompositionAndDisconnectEdges(boogieIcfgLocation, boogieIcfgLocation2, true, false, arrayList, this.mSimplificationTechnique);
    }

    private INestedWordAutomaton<LETTER, IPredicate> getNestedWordAutomaton(IcfgLocation icfgLocation2) {
        Object object2;
        IcfgLocation icfgLocation32;
        this.mLogger.debug((Object)"Step: Collect all LocNodes corresponding to this procedure");
        Set set = new IcfgLocationIterator(icfgLocation2).asStream().collect(Collectors.toSet());
        this.mLogger.debug((Object)"Step: determine the alphabet");
        HashSet hashSet = new HashSet();
        hashSet.add(this.mSharedVarsInit);
        set.stream().flatMap(icfgLocation -> icfgLocation.getOutgoingEdges().stream()).forEach(icfgEdge -> {
            if (icfgEdge instanceof Summary || icfgEdge instanceof IIcfgCallTransition || icfgEdge instanceof IIcfgReturnTransition) {
                throw new IllegalArgumentException("Procedure calls not supported by concurrent trace abstraction");
            }
            hashSet.add(icfgEdge);
        });
        this.mLogger.debug((Object)"Step: construct the automaton");
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(this.mServices), new VpAlphabet(hashSet), this.mContentFactory);
        SPredicate sPredicate = null;
        this.mLogger.debug((Object)"Step: add states");
        HashMap<IcfgLocation, Object> hashMap = new HashMap<IcfgLocation, Object>();
        for (IcfgLocation icfgLocation32 : set) {
            boolean bl = this.isErrorLocation(icfgLocation32);
            object2 = this.mCsToolkit.getManagedScript().getScript().term("true", new Term[0]);
            SPredicate sPredicate2 = this.mPredicateFactory.newSPredicate(icfgLocation32, object2);
            nestedWordAutomaton.addState(false, bl, (Object)sPredicate2);
            hashMap.put(icfgLocation32, sPredicate2);
            if (icfgLocation32 != icfgLocation2) continue;
            assert (sPredicate == null) : "Procedure must haveonly one initial state";
            sPredicate = sPredicate2;
        }
        this.mLogger.debug((Object)"Step: add transitions");
        for (IcfgLocation icfgLocation32 : set) {
            IPredicate iPredicate = (IPredicate)hashMap.get(icfgLocation32);
            if (icfgLocation32.getOutgoingNodes() == null) continue;
            for (Object object2 : icfgLocation32.getOutgoingEdges()) {
                IcfgLocation icfgLocation4 = (IcfgLocation)object2.getTarget();
                IPredicate iPredicate2 = (IPredicate)hashMap.get(icfgLocation4);
                nestedWordAutomaton.addInternalTransition((Object)iPredicate, object2, (Object)iPredicate2);
            }
        }
        this.mLogger.debug((Object)"Step: SharedVarsInit part");
        icfgLocation32 = (BoogieIcfgLocation)this.mSharedVarsInit.getSource();
        Term term = this.mCsToolkit.getManagedScript().getScript().term("true", new Term[0]);
        SPredicate sPredicate3 = this.mPredicateFactory.newSPredicate(icfgLocation32, term);
        nestedWordAutomaton.addState(true, false, (Object)sPredicate3);
        object2 = sPredicate;
        nestedWordAutomaton.addInternalTransition((Object)sPredicate3, this.mSharedVarsInit, object2);
        return nestedWordAutomaton;
    }

    private boolean isErrorLocation(IcfgLocation icfgLocation) {
        if (icfgLocation == null) {
            return false;
        }
        String string = icfgLocation.getProcedure();
        Set set = (Set)this.mIcfg.getProcedureErrorNodes().get(string);
        if (set == null) {
            return false;
        }
        return set.contains(icfgLocation);
    }
}

