/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter;

import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;

class InterpreterException
extends Exception {
    private static final long serialVersionUID = -7514869048479460179L;
    private final ILocation mLocation;
    private final String mShortDescription;
    private final String mLongDescription;

    public InterpreterException(ILocation iLocation, String string) {
        this.mLocation = iLocation;
        this.mLongDescription = string;
        this.mShortDescription = null;
    }

    public InterpreterException(ILocation iLocation, String string, String string2) {
        this.mLocation = iLocation;
        this.mLongDescription = string;
        this.mShortDescription = string2;
    }

    public InterpreterException(ILocation iLocation, Throwable throwable) {
        super(throwable);
        this.mLocation = iLocation;
        this.mLongDescription = InterpreterException.generateLongDescriptionFromThrowable(throwable);
        this.mShortDescription = throwable.getClass().getSimpleName();
    }

    private static String generateLongDescriptionFromThrowable(Throwable throwable) {
        if (throwable.getMessage() == null) {
            return throwable.getClass().getSimpleName();
        }
        return throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
    }

    public ILocation getLocation() {
        return this.mLocation;
    }

    public String getLongDescription() {
        return this.mLongDescription;
    }

    public String getShortDescription() {
        return this.mShortDescription;
    }
}

