/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.Literal;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.XJunction;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class XnfTransformer
extends NnfTransformer {
    public static final boolean POSET_SIMPLIFICATION = true;

    public XnfTransformer(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        super(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.IS_ATOM);
    }

    public XnfTransformer(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, Function<Integer, Boolean> function) {
        super(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.IS_ATOM, function);
    }

    public static class AbortBeforeBlowup
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    protected abstract class XnfTransformerHelper
    extends NnfTransformer.NnfTransformerHelper {
        protected XnfTransformerHelper(IUltimateServiceProvider iUltimateServiceProvider) {
            super(iUltimateServiceProvider);
        }

        public abstract String innerConnectiveSymbol();

        public abstract String outerConnectiveSymbol();

        public abstract String innerJunctionName();

        public abstract String outerJunctionName();

        public abstract Term innerConnective(Script var1, List<Term> var2);

        public abstract Term outerConnective(Script var1, List<Term> var2);

        public abstract Term[] getOuterJuncts(Term var1);

        @Override
        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            Term term;
            String string = applicationTerm.getFunction().getName();
            if (string.equals(this.innerConnectiveSymbol())) {
                Term[] termArray2 = this.applyDistributivityAndOr(termArray);
                term = this.outerConnective(XnfTransformer.this.mScript, Arrays.asList(termArray2));
            } else if (string.equals(this.outerConnectiveSymbol())) {
                term = this.outerConnective(XnfTransformer.this.mScript, Arrays.asList(termArray));
            } else {
                throw new AssertionError();
            }
            this.setResult(term);
        }

        private Term[] applyDistributivityAndOr(Term[] termArray) {
            Object object;
            ResultInnerJunctions resultInnerJunctions;
            try {
                resultInnerJunctions = new ResultInnerJunctions(this.convertInnerJunctionOfOuterJunctionsToSet(termArray));
            }
            catch (XJunction.AtomAndNegationException atomAndNegationException) {
                return new Term[0];
            }
            int n = resultInnerJunctions.numberOfUnprocessedOuterJunctions();
            if (n > 5) {
                if (((Boolean)XnfTransformer.this.mFunAbortIfExponential.apply(n)).booleanValue()) {
                    XnfTransformer.this.mLogger.warn((Object)("aborting because of expected exponential blowup for input size " + n));
                    throw new AbortBeforeBlowup();
                }
                XnfTransformer.this.mLogger.warn((Object)("expecting exponential blowup for input size " + n));
            }
            HashSet<XJunction> hashSet = new HashSet<XJunction>();
            ArrayDeque<ResultInnerJunctions> arrayDeque = new ArrayDeque<ResultInnerJunctions>();
            arrayDeque.add(resultInnerJunctions);
            while (!arrayDeque.isEmpty()) {
                object = (ResultInnerJunctions)arrayDeque.pop();
                if (((ResultInnerJunctions)object).isProcessedToInnerJunction()) {
                    hashSet.add(((ResultInnerJunctions)object).getInnerJunction());
                } else {
                    arrayDeque.addAll(((ResultInnerJunctions)object).processOneOuterJunction());
                }
                if (this.mServices.getProgressMonitorService().continueProcessing()) continue;
                throw new ToolchainCanceledException(((Object)((Object)this)).getClass(), "transforming " + n + " " + this.innerJunctionName());
            }
            object = this.simplifyWithPosetMinimalElements(hashSet);
            Term[] termArray2 = new Term[object.size()];
            int n2 = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                XJunction xJunction = (XJunction)iterator.next();
                termArray2[n2] = this.innerConnective(XnfTransformer.this.mScript, xJunction.toTermList(XnfTransformer.this.mScript));
                ++n2;
            }
            assert (n2 == termArray2.length);
            return termArray2;
        }

        private Set<XJunction> simplifyWithPosetMinimalElements(Set<XJunction> set) {
            boolean bl;
            boolean bl2 = bl = set.size() > 5000;
            if (bl) {
                XnfTransformer.this.mLogger.warn((Object)("Simplifying " + this.outerJunctionName() + " of " + set.size() + " " + this.innerJunctionName() + "s. This might take some time..."));
            }
            XJunctionPosetMinimalElements xJunctionPosetMinimalElements = new XJunctionPosetMinimalElements();
            for (XJunction xJunction : set) {
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(((Object)((Object)this)).getClass(), "XNF transformer was simplifying " + set.size() + " " + this.innerJunctionName() + "s. ");
                }
                xJunctionPosetMinimalElements.add(xJunction);
            }
            if (bl) {
                XnfTransformer.this.mLogger.info((Object)("Simplified to " + this.outerJunctionName() + " of " + xJunctionPosetMinimalElements.getElements().size() + " " + this.innerJunctionName() + "s. "));
            }
            return xJunctionPosetMinimalElements.getElements();
        }

        private Set<XJunction> convertInnerJunctionOfOuterJunctionsToSet(Term[] termArray) {
            HashSet<XJunction> hashSet = new HashSet<XJunction>();
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray2[n2];
                Term[] termArray3 = this.getOuterJuncts(term);
                try {
                    hashSet.add(new XJunction(termArray3));
                }
                catch (XJunction.AtomAndNegationException atomAndNegationException) {}
                ++n2;
            }
            return hashSet;
        }

        private class ResultInnerJunctions {
            private final XJunction mInnerJuncts;
            private final Set<XJunction> mUnprocessedInnerJunctionOfOuterJunctions;

            public ResultInnerJunctions(Set<XJunction> set) throws XJunction.AtomAndNegationException {
                XJunction xJunction = new XJunction();
                this.mUnprocessedInnerJunctionOfOuterJunctions = this.moveOutwardsAbsorbeAndMpsimplify(xJunction, set);
                this.mInnerJuncts = xJunction;
            }

            public ResultInnerJunctions(XJunction xJunction, Set<XJunction> set) throws XJunction.AtomAndNegationException {
                XJunction xJunction2 = new XJunction();
                this.mUnprocessedInnerJunctionOfOuterJunctions = this.moveOutwardsAbsorbeAndMpsimplify(xJunction2, set);
                this.mInnerJuncts = XJunction.disjointUnion(xJunction, xJunction2);
            }

            public boolean isProcessedToInnerJunction() {
                return this.mUnprocessedInnerJunctionOfOuterJunctions.isEmpty();
            }

            public int numberOfUnprocessedOuterJunctions() {
                return this.mUnprocessedInnerJunctionOfOuterJunctions.size();
            }

            public XJunction getInnerJunction() {
                return this.mInnerJuncts;
            }

            public List<ResultInnerJunctions> processOneOuterJunction() {
                Iterator<XJunction> iterator = this.mUnprocessedInnerJunctionOfOuterJunctions.iterator();
                XJunction xJunction = iterator.next();
                iterator.remove();
                ArrayList<ResultInnerJunctions> arrayList = new ArrayList<ResultInnerJunctions>(xJunction.size());
                for (Map.Entry<Term, Literal.Polarity> entry : xJunction.entrySet()) {
                    XJunction xJunction2 = new XJunction(entry.getKey(), entry.getValue());
                    HashSet<XJunction> hashSet = new HashSet<XJunction>(this.mUnprocessedInnerJunctionOfOuterJunctions);
                    hashSet.add(xJunction2);
                    XJunction xJunction3 = new XJunction(this.mInnerJuncts);
                    try {
                        ResultInnerJunctions resultInnerJunctions = new ResultInnerJunctions(xJunction3, hashSet);
                        arrayList.add(resultInnerJunctions);
                    }
                    catch (XJunction.AtomAndNegationException atomAndNegationException) {}
                }
                return arrayList;
            }

            private Set<XJunction> moveOutwardsAbsorbeAndMpsimplify(XJunction xJunction, Set<XJunction> set) throws XJunction.AtomAndNegationException {
                boolean bl;
                while (bl = this.moveSingletonsOutwards(xJunction, set)) {
                    Set<XJunction> set2 = this.applyAbsorbeAndMpsimplify(xJunction, set);
                    if (set2 == set) {
                        return set;
                    }
                    set = set2;
                }
                return set;
            }

            private boolean moveSingletonsOutwards(XJunction xJunction, Set<XJunction> set) throws XJunction.AtomAndNegationException {
                boolean bl = false;
                Iterator<XJunction> iterator = set.iterator();
                while (iterator.hasNext()) {
                    XJunction xJunction2 = iterator.next();
                    if (xJunction2.size() != 1) continue;
                    Map.Entry<Term, Literal.Polarity> entry = xJunction2.entrySet().iterator().next();
                    xJunction.add(entry.getKey(), entry.getValue());
                    bl = true;
                    iterator.remove();
                }
                return bl;
            }

            private Set<XJunction> applyAbsorbeAndMpsimplify(XJunction xJunction, Set<XJunction> set) {
                HashSet<XJunction> hashSet = new HashSet<XJunction>();
                boolean bl = false;
                for (XJunction xJunction2 : set) {
                    XJunction xJunction3 = this.applyAbsorbeAndMpsimplify(xJunction, xJunction2);
                    if (xJunction3 == null) {
                        bl = true;
                        continue;
                    }
                    if (xJunction2 == xJunction3) {
                        hashSet.add(xJunction3);
                        continue;
                    }
                    assert (xJunction2.size() > xJunction3.size());
                    hashSet.add(xJunction3);
                }
                if (bl) {
                    return hashSet;
                }
                return set;
            }

            private XJunction applyAbsorbeAndMpsimplify(XJunction xJunction, XJunction xJunction2) {
                XJunction xJunction3 = xJunction2;
                for (Map.Entry<Term, Literal.Polarity> entry : xJunction.entrySet()) {
                    if (xJunction2.contains(entry.getKey(), entry.getValue())) {
                        return null;
                    }
                    if (!xJunction2.containsNegation(entry.getKey(), entry.getValue())) continue;
                    if (xJunction3 == xJunction2) {
                        xJunction3 = new XJunction(xJunction2);
                    }
                    xJunction3.remove(entry.getKey());
                }
                return xJunction3;
            }
        }

        class XJunctionPosetMinimalElements {
            private final Set<XJunction> mElements = new HashSet<XJunction>();

            XJunctionPosetMinimalElements() {
            }

            public void add(XJunction xJunction) {
                Iterator<XJunction> iterator = this.mElements.iterator();
                while (iterator.hasNext()) {
                    XJunction xJunction2 = iterator.next();
                    if (xJunction2.isSubset(xJunction)) {
                        return;
                    }
                    if (!xJunction.isSubset(xJunction2)) continue;
                    iterator.remove();
                }
                this.mElements.add(xJunction);
            }

            public Set<XJunction> getElements() {
                return this.mElements;
            }

            public int size() {
                return this.mElements.size();
            }
        }
    }
}

