/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ILiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;

public abstract class QuantLiteral
implements ILiteral {
    private final Term mTerm;
    protected QuantClause mClause;
    protected boolean mIsEssentiallyUninterpreted;
    protected boolean mIsArithmetical;
    protected boolean mIsDERUsable;
    protected QuantLiteral mAtom;
    protected QuantLiteral mNegated;

    QuantLiteral(Term term) {
        this.mTerm = term;
        this.mAtom = this;
        this.mIsArithmetical = false;
        this.mIsEssentiallyUninterpreted = false;
        this.mIsDERUsable = false;
    }

    @Override
    public QuantLiteral negate() {
        return this.mNegated;
    }

    public Term getTerm() {
        return this.mTerm;
    }

    public QuantClause getClause() {
        return this.mClause;
    }

    @Override
    public QuantLiteral getAtom() {
        return this.mAtom;
    }

    public boolean isNegated() {
        return this.mAtom == this.mNegated;
    }

    @Override
    public boolean isGround() {
        return false;
    }

    public boolean isAlmostUninterpreted() {
        return this.isEssentiallyUninterpreted() || this.isArithmetical();
    }

    public boolean isEssentiallyUninterpreted() {
        return this.mIsEssentiallyUninterpreted;
    }

    public boolean isArithmetical() {
        return this.mIsArithmetical;
    }

    @Override
    public Term getSMTFormula(Theory theory) {
        return this.mTerm;
    }

    @Override
    public String toString() {
        return this.mTerm.toString();
    }

    static class NegQuantLiteral
    extends QuantLiteral {
        NegQuantLiteral(QuantLiteral quantLiteral) {
            super(quantLiteral.getTerm().getTheory().not(quantLiteral.getTerm()));
            this.mAtom = quantLiteral;
            this.mNegated = quantLiteral;
        }

        @Override
        public Term getSMTFormula(Theory theory) {
            return theory.not(super.getAtom().getSMTFormula(theory));
        }
    }
}

