/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.IVertex;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Map;

public class ModelVertex
implements IVertex {
    private final Map<Term, Term> mWitness;
    private IVertex mTrueChild;
    private IVertex mFalseChild;

    protected ModelVertex(IVertex iVertex, IVertex iVertex2, Map<Term, Term> map) {
        this.mWitness = map;
        this.mTrueChild = iVertex;
        this.mFalseChild = iVertex2;
    }

    protected void setTrueChild(IVertex iVertex) {
        this.mTrueChild = iVertex;
    }

    protected void setFalseChild(IVertex iVertex) {
        this.mFalseChild = iVertex;
    }

    protected IVertex getChild(boolean bl) {
        if (bl) {
            return this.mTrueChild;
        }
        return this.mFalseChild;
    }

    protected void swapChild(IVertex iVertex, IVertex iVertex2) {
        if (iVertex.equals(this.mTrueChild)) {
            this.mTrueChild = iVertex2;
        } else if (iVertex.equals(this.mFalseChild)) {
            this.mFalseChild = iVertex2;
        } else {
            throw new IllegalArgumentException("the node to swap is not a child of this node");
        }
    }

    protected Map<Term, Term> getWitness() {
        return this.mWitness;
    }

    @Override
    public String print() {
        return "inner: " + this.hashCode() % 100 + this.mWitness.toString() + " : " + this.mTrueChild.hashCode() % 100 + this.mTrueChild.toString() + " | " + this.mFalseChild.hashCode() % 100 + this.mFalseChild.toString();
    }

    public String toString() {
        return this.mWitness.toString();
    }
}

