/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.ResultChecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsTotal;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DoubleDeckerVisitor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.ReachableStatesCopy;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementDeterministicStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public final class BuchiComplementDeterministic<LETTER, STATE>
extends DoubleDeckerVisitor<LETTER, STATE>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mTotalizedOperand;
    private final IBuchiComplementDeterministicStateFactory<STATE> mContentFactory;
    private final HashMap<STATE, STATE> mNew2Old = new HashMap();
    private final HashMap<STATE, STATE> mOld2Final = new HashMap();
    private final HashMap<STATE, STATE> mOld2NonFinal = new HashMap();

    public BuchiComplementDeterministic(AutomataLibraryServices automataLibraryServices, IBuchiComplementDeterministicStateFactory<STATE> iBuchiComplementDeterministicStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        this.mContentFactory = iBuchiComplementDeterministicStateFactory;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mTotalizedOperand = new IsTotal<LETTER, STATE>(this.mServices, this.mOperand).getResult() != false ? this.mOperand : new ReachableStatesCopy<LETTER, STATE>(this.mServices, iNestedWordAutomaton, true, false, false, false).getResult();
        this.mTraversedNwa = new NestedWordAutomaton(this.mServices, iNestedWordAutomaton.getVpAlphabet(), iBuchiComplementDeterministicStateFactory);
        this.traverseDoubleDeckerGraph();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". Operand " + this.mOperand.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mTraversedNwa.sizeInformation();
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mTraversedNwa;
    }

    private STATE getOrConstructNewState(STATE STATE, boolean bl, boolean bl2) {
        STATE STATE2;
        STATE STATE3 = STATE2 = bl2 ? this.mOld2Final.get(STATE) : this.mOld2NonFinal.get(STATE);
        if (STATE2 == null) {
            if (bl2) {
                STATE2 = this.mContentFactory.buchiComplementDeterministicFinal(STATE);
                ((NestedWordAutomaton)this.mTraversedNwa).addState(bl, bl2, STATE2);
                this.mOld2Final.put(STATE, STATE2);
            } else {
                STATE2 = this.mContentFactory.buchiComplementDeterministicNonFinal(STATE);
                ((NestedWordAutomaton)this.mTraversedNwa).addState(bl, bl2, STATE2);
                this.mOld2NonFinal.put(STATE, STATE2);
            }
            this.mNew2Old.put(STATE2, STATE);
        }
        return STATE2;
    }

    @Override
    protected Collection<STATE> getInitialStates() {
        Iterator iterator = this.mTotalizedOperand.getInitialStates().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("No initial state.");
        }
        Object STATE = iterator.next();
        assert (!iterator.hasNext());
        Object STATE2 = this.getOrConstructNewState(STATE, true, false);
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(STATE2);
        return arrayList;
    }

    @Override
    protected Collection<STATE> visitAndGetCallSuccessors(DoubleDecker<STATE> doubleDecker) {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        STATE STATE = doubleDecker.getUp();
        boolean bl = this.mTraversedNwa.isFinal(STATE);
        STATE STATE2 = this.mNew2Old.get(STATE);
        for (LETTER LETTER : this.mTotalizedOperand.lettersCall(STATE2)) {
            for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : this.mTotalizedOperand.callSuccessors(STATE2, LETTER)) {
                STATE STATE3;
                STATE STATE4 = outgoingCallTransition.getSucc();
                if (!bl) {
                    STATE3 = this.getOrConstructNewState(STATE4, false, false);
                    ((NestedWordAutomaton)this.mTraversedNwa).addCallTransition(STATE, LETTER, STATE3);
                    arrayList.add(STATE3);
                }
                if (this.mTotalizedOperand.isFinal(STATE4)) continue;
                STATE3 = this.getOrConstructNewState(STATE4, false, true);
                ((NestedWordAutomaton)this.mTraversedNwa).addCallTransition(STATE, LETTER, STATE3);
                arrayList.add(STATE3);
            }
        }
        return arrayList;
    }

    @Override
    protected Collection<STATE> visitAndGetInternalSuccessors(DoubleDecker<STATE> doubleDecker) {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        STATE STATE = doubleDecker.getUp();
        boolean bl = this.mTraversedNwa.isFinal(STATE);
        STATE STATE2 = this.mNew2Old.get(STATE);
        for (LETTER LETTER : this.mTotalizedOperand.lettersInternal(STATE2)) {
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.mTotalizedOperand.internalSuccessors(STATE2, LETTER)) {
                STATE STATE3;
                STATE STATE4 = outgoingInternalTransition.getSucc();
                if (!bl) {
                    STATE3 = this.getOrConstructNewState(STATE4, false, false);
                    ((NestedWordAutomaton)this.mTraversedNwa).addInternalTransition(STATE, LETTER, STATE3);
                    arrayList.add(STATE3);
                }
                if (this.mTotalizedOperand.isFinal(STATE4)) continue;
                STATE3 = this.getOrConstructNewState(STATE4, false, true);
                ((NestedWordAutomaton)this.mTraversedNwa).addInternalTransition(STATE, LETTER, STATE3);
                arrayList.add(STATE3);
            }
        }
        return arrayList;
    }

    @Override
    protected Collection<STATE> visitAndGetReturnSuccessors(DoubleDecker<STATE> doubleDecker) {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        STATE STATE = doubleDecker.getDown();
        if (STATE == this.mTraversedNwa.getEmptyStackState()) {
            return arrayList;
        }
        STATE STATE2 = this.mNew2Old.get(STATE);
        STATE STATE3 = doubleDecker.getUp();
        boolean bl = this.mTraversedNwa.isFinal(STATE3);
        STATE STATE4 = this.mNew2Old.get(STATE3);
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mTotalizedOperand.returnSuccessorsGivenHier(STATE4, STATE2)) {
            STATE STATE5;
            STATE STATE6 = outgoingReturnTransition.getSucc();
            if (!bl) {
                STATE5 = this.getOrConstructNewState(STATE6, false, false);
                ((NestedWordAutomaton)this.mTraversedNwa).addReturnTransition(STATE3, STATE, outgoingReturnTransition.getLetter(), STATE5);
                arrayList.add(STATE5);
            }
            if (this.mTotalizedOperand.isFinal(STATE6)) continue;
            STATE5 = this.getOrConstructNewState(STATE6, false, true);
            ((NestedWordAutomaton)this.mTraversedNwa).addReturnTransition(STATE3, STATE, outgoingReturnTransition.getLetter(), STATE5);
            arrayList.add(STATE5);
        }
        return arrayList;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return ResultChecker.buchiComplement(this.mServices, this.mOperand, this.mTraversedNwa);
    }
}

