/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.rabin.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.rabin.RabinAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.rabin.RabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TransformIterator;
import de.uni_freiburg.informatik.ultimate.util.scc.DefaultSccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class IsEmpty<LETTER, STATE, CRSF extends IStateFactory<STATE>>
extends GeneralOperation<LETTER, STATE, CRSF> {
    private final Boolean mResult;
    private final IRabinAutomaton<LETTER, STATE> mAutomaton;
    private final Set<STATE> mEvidence;

    public IsEmpty(AutomataLibraryServices automataLibraryServices, IRabinAutomaton<LETTER, STATE> iRabinAutomaton) {
        super(automataLibraryServices);
        this.mAutomaton = iRabinAutomaton;
        RabinAutomaton rabinAutomaton = this.getSuffixAutomaton(this.mAutomaton);
        Set set = rabinAutomaton.getInitialStates();
        DefaultSccComputation defaultSccComputation = new DefaultSccComputation(automataLibraryServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID), object -> new TransformIterator(rabinAutomaton.getSuccessors(object).iterator(), IOutgoingTransitionlet::getSucc), rabinAutomaton.size(), set);
        this.mEvidence = this.getEvidence(set, defaultSccComputation.getBalls());
        this.mResult = this.mEvidence.isEmpty();
    }

    private Set<STATE> getEvidence(Set<STATE> set, Collection<StronglyConnectedComponent<STATE>> collection) {
        for (StronglyConnectedComponent<STATE> stronglyConnectedComponent : collection) {
            for (STATE STATE : set) {
                if (!stronglyConnectedComponent.getNodes().contains(STATE)) continue;
                return stronglyConnectedComponent.getNodes();
            }
        }
        return Set.of();
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }

    public NestedLassoWord<LETTER> getCounterexample() throws AutomataOperationCanceledException {
        if (this.mEvidence.isEmpty()) {
            return null;
        }
        Object object = this.mEvidence.stream().filter(this.mAutomaton::isAccepting).findAny().get();
        return new NestedLassoWord<LETTER>(this.getStem(object), this.getLoop(object));
    }

    private NestedWord<LETTER> getStem(STATE STATE) throws AutomataOperationCanceledException {
        HashSet hashSet = new HashSet();
        return this.computeWord(this.mAutomaton.getInitialStates(), STATE, hashSet::add);
    }

    private NestedWord<LETTER> getLoop(STATE STATE) throws AutomataOperationCanceledException {
        HashSet<STATE> hashSet = new HashSet<STATE>(this.mEvidence);
        return this.computeWord(Set.of(STATE), STATE, hashSet::remove);
    }

    private NestedWord<LETTER> computeWord(Set<STATE> set, STATE STATE, Predicate<STATE> predicate) throws AutomataOperationCanceledException {
        HashRelation hashRelation = new HashRelation();
        hashRelation.addAllPairs(List.of(), set);
        while (!this.isCancellationRequested()) {
            HashRelation hashRelation2 = new HashRelation();
            for (Map.Entry entry : hashRelation.entrySet()) {
                for (Object e : (HashSet)entry.getValue()) {
                    for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.mAutomaton.getSuccessors(e)) {
                        STATE STATE2 = outgoingInternalTransition.getSucc();
                        if (!predicate.test(STATE2)) continue;
                        ArrayList<LETTER> arrayList = new ArrayList<LETTER>((Collection)entry.getKey());
                        arrayList.add(outgoingInternalTransition.getLetter());
                        if (STATE2.equals(STATE)) {
                            return NestedWord.nestedWord(new Word<Object>(arrayList.toArray()));
                        }
                        hashRelation2.addPair(arrayList, STATE2);
                    }
                }
            }
            hashRelation = hashRelation2;
        }
        throw new AutomataOperationCanceledException(this.getClass());
    }

    private RabinAutomaton<LETTER, STATE> getSuffixAutomaton(IRabinAutomaton<LETTER, STATE> iRabinAutomaton) {
        RabinAutomaton<LETTER, STATE> rabinAutomaton = RabinAutomataUtils.computeReachableStates(iRabinAutomaton);
        RabinAutomaton<LETTER, STATE> rabinAutomaton2 = new RabinAutomaton<LETTER, STATE>(rabinAutomaton.getAlphabet(), rabinAutomaton.getStates(), rabinAutomaton.getAcceptingStates(), rabinAutomaton.getAcceptingStates(), rabinAutomaton.getFiniteStates(), rabinAutomaton.getTransitions());
        return RabinAutomataUtils.computeReachableIgnoredStates(rabinAutomaton2, rabinAutomaton.getFiniteStates());
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataOperationCanceledException {
        boolean bl = true;
        if (Boolean.FALSE.equals(this.mResult)) {
            NestedLassoWord<LETTER> nestedLassoWord = this.getCounterexample();
            bl = new Accepts(this.mServices, this.mAutomaton, nestedLassoWord).getResult();
        }
        return bl;
    }
}

